/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.ambientsounds;

import com.creativemd.ambientsounds.AmbientSituation;
import com.creativemd.ambientsounds.AmbientSoundLoader;
import com.creativemd.ambientsounds.AmbientSoundResult;
import com.creativemd.ambientsounds.AmbientSounds;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;

public abstract class AmbientCondition {
    public static AmbientConditionObjectParser parser = new AmbientConditionObjectParser();
    public static LinkedHashMap<String, AmbientConditionParser> regionSelectors = new LinkedHashMap();
    public HashMap<String, Object> unknownValues;

    public static boolean checkBiome(String name, Biome biome) {
        String biomename = biome.func_185359_l().toLowerCase().replace("_", " ");
        return biomename.matches(".*" + name.replace("*", ".*") + ".*");
    }

    public abstract boolean is(AmbientSituation var1, AmbientSoundResult var2);

    static {
        regionSelectors.put("always", new AmbientConditionParser(){

            @Override
            public AmbientCondition parseCondition(JsonElement element) throws IllegalArgumentException {
                if (element.isJsonPrimitive() && ((JsonPrimitive)element).isBoolean()) {
                    if (element.getAsBoolean()) {
                        return new AmbientCondition(){

                            @Override
                            public boolean is(AmbientSituation situation, AmbientSoundResult result) {
                                return true;
                            }
                        };
                    }
                    return new AmbientCondition(){

                        @Override
                        public boolean is(AmbientSituation situation, AmbientSoundResult result) {
                            return false;
                        }
                    };
                }
                throw new IllegalArgumentException("Expected a boolean!");
            }
        });
        regionSelectors.put("biomes", new AmbientConditionParser(){

            @Override
            public AmbientCondition parseCondition(JsonElement element) throws IllegalArgumentException {
                if (element.isJsonArray()) {
                    JsonArray array = element.getAsJsonArray();
                    final String[] names = new String[array.size()];
                    for (int i = 0; i < names.length; ++i) {
                        names[i] = array.get(i).getAsString();
                    }
                    return new AmbientCondition(){

                        @Override
                        public boolean is(AmbientSituation situation, AmbientSoundResult result) {
                            int i = 0;
                            while (i < situation.selectedBiomes.size()) {
                                AmbientSituation.BiomeArea area = situation.selectedBiomes.get(i);
                                boolean foundIt = false;
                                for (int j = 0; j < names.length; ++j) {
                                    if (!1.checkBiome(names[j], area.biome)) continue;
                                    ++i;
                                    foundIt = true;
                                    break;
                                }
                                if (foundIt) continue;
                                situation.selectedBiomes.remove(i);
                            }
                            if (!situation.selectedBiomes.isEmpty()) {
                                result.takeBiome = true;
                                return true;
                            }
                            return false;
                        }
                    };
                }
                throw new IllegalArgumentException("Expected a string array!");
            }
        });
        regionSelectors.put("bad-biomes", new AmbientConditionParser(){

            @Override
            public AmbientCondition parseCondition(JsonElement element) throws IllegalArgumentException {
                if (element.isJsonArray()) {
                    JsonArray array = element.getAsJsonArray();
                    final String[] names = new String[array.size()];
                    for (int i = 0; i < names.length; ++i) {
                        names[i] = array.get(i).getAsString();
                    }
                    return new AmbientCondition(){

                        @Override
                        public boolean is(AmbientSituation situation, AmbientSoundResult result) {
                            for (int i = 0; i < situation.selectedBiomes.size(); ++i) {
                                AmbientSituation.BiomeArea area = situation.selectedBiomes.get(i);
                                for (int j = 0; j < names.length; ++j) {
                                    if (!1.checkBiome(names[j], area.biome)) continue;
                                    return false;
                                }
                            }
                            return true;
                        }
                    };
                }
                throw new IllegalArgumentException("Expected a string array!");
            }
        });
        regionSelectors.put("temperature", new AmbientMathConditionParser(){

            @Override
            public boolean is(AmbientMathConditionParser.MathOperator operator, double value, AmbientSituation situation) {
                int i = 0;
                while (i < situation.selectedBiomes.size()) {
                    AmbientSituation.BiomeArea area = situation.selectedBiomes.get(i);
                    if (operator.is(value, area.biome.func_180626_a(area.pos))) {
                        ++i;
                        continue;
                    }
                    situation.selectedBiomes.remove(i);
                }
                return !situation.selectedBiomes.isEmpty();
            }

            @Override
            public double getValue(AmbientSituation situation) {
                return 0.0;
            }

            @Override
            public boolean requiresBiome() {
                return true;
            }
        });
        regionSelectors.put("position", new AmbientConditionParser(){

            @Override
            public AmbientCondition parseCondition(JsonElement element) throws IllegalArgumentException {
                if (element.isJsonObject()) {
                    JsonElement absolute;
                    JsonElement relative;
                    JsonObject object = element.getAsJsonObject();
                    double fadeValue = 0.0;
                    if (object.has("fadeValue")) {
                        JsonElement fade = object.get("fadeValue");
                        if (fade.isJsonPrimitive()) {
                            fadeValue = fade.getAsDouble();
                        } else {
                            throw new IllegalArgumentException("Expected a number for 'fadeValue'!");
                        }
                    }
                    double[] relativePointsTemp = null;
                    Object relativePosition = null;
                    if (object.has("relativePosition")) {
                        relative = object.get("relativePosition");
                        if (relative.isJsonPrimitive() && ((JsonPrimitive)relative).isString()) {
                            AmbientMathConditionParser parser = new AmbientMathConditionParser(){

                                @Override
                                public double getValue(AmbientSituation situation) {
                                    return situation.relativeHeight;
                                }

                                @Override
                                public boolean requiresBiome() {
                                    return false;
                                }
                            };
                            relativePosition = parser.parseCondition(relative);
                            relativePointsTemp = parser.points;
                        } else {
                            throw new IllegalArgumentException("Expected a string for 'relativePosition'!");
                        }
                    }
                    relative = relativePosition;
                    double[] absolutePointsTemp = null;
                    Object absolutePosition = null;
                    if (object.has("absolutePosition")) {
                        absolute = object.get("absolutePosition");
                        if (absolute.isJsonPrimitive() && ((JsonPrimitive)absolute).isString()) {
                            AmbientMathConditionParser parser = new AmbientMathConditionParser(){

                                @Override
                                public double getValue(AmbientSituation situation) {
                                    return situation.player.field_70163_u;
                                }

                                @Override
                                public boolean requiresBiome() {
                                    return false;
                                }
                            };
                            absolutePosition = parser.parseCondition(absolute);
                            absolutePointsTemp = parser.points;
                        } else {
                            throw new IllegalArgumentException("Expected a string for 'absolutePosition'!");
                        }
                    }
                    absolute = absolutePosition;
                    double fade = fadeValue;
                    double[] relativePoints = relativePointsTemp;
                    double[] absolutePoints = absolutePointsTemp;
                    return new AmbientCondition((AmbientCondition)relative, (AmbientCondition)absolute, fade, relativePoints, absolutePoints){
                        final /* synthetic */ AmbientCondition val$relative;
                        final /* synthetic */ AmbientCondition val$absolute;
                        final /* synthetic */ double val$fade;
                        final /* synthetic */ double[] val$relativePoints;
                        final /* synthetic */ double[] val$absolutePoints;
                        {
                            this.val$relative = ambientCondition;
                            this.val$absolute = ambientCondition2;
                            this.val$fade = d;
                            this.val$relativePoints = dArray;
                            this.val$absolutePoints = dArray2;
                        }

                        @Override
                        public boolean is(AmbientSituation situation, AmbientSoundResult result) {
                            int i;
                            if (this.val$relative != null && !this.val$relative.is(situation, result)) {
                                return false;
                            }
                            if (this.val$absolute != null && !this.val$absolute.is(situation, result)) {
                                return false;
                            }
                            double distance = this.val$fade;
                            if (this.val$relativePoints != null) {
                                for (i = 0; i < this.val$relativePoints.length; ++i) {
                                    distance = Math.min(distance, Math.abs((double)situation.relativeHeight - this.val$relativePoints[i]));
                                }
                            }
                            if (this.val$absolutePoints != null) {
                                for (i = 0; i < this.val$absolutePoints.length; ++i) {
                                    distance = Math.min(distance, Math.abs((double)situation.relativeHeight - this.val$absolutePoints[i]));
                                }
                            }
                            if (distance < this.val$fade) {
                                result.volume *= (float)(distance / this.val$fade);
                            }
                            return true;
                        }
                    };
                }
                throw new IllegalArgumentException("Expected an object!");
            }
        });
        regionSelectors.put("underwater", new AmbientConditionParser(){

            @Override
            public AmbientCondition parseCondition(final JsonElement element) throws IllegalArgumentException {
                if (element.isJsonPrimitive() && ((JsonPrimitive)element).isBoolean()) {
                    return new AmbientCondition(){

                        @Override
                        public boolean is(AmbientSituation situation, AmbientSoundResult result) {
                            return element.getAsBoolean() == situation.player.func_70055_a(Material.field_151586_h);
                        }
                    };
                }
                throw new IllegalArgumentException("Expected a boolean!");
            }
        });
        regionSelectors.put("underwater-pitch", new AmbientConditionParser(){

            @Override
            public AmbientCondition parseCondition(JsonElement element) throws IllegalArgumentException {
                if (element.isJsonObject()) {
                    final JsonObject object = element.getAsJsonObject();
                    return new AmbientCondition(){

                        @Override
                        public boolean is(AmbientSituation situation, AmbientSoundResult result) {
                            if (situation.player.func_70055_a(Material.field_151586_h)) {
                                int depth = 0;
                                AxisAlignedBB bb = situation.player.func_174813_aQ().func_72314_b((double)-0.1f, (double)-0.4f, (double)-0.1f);
                                while (situation.world.func_72875_a(bb, Material.field_151586_h)) {
                                    ++depth;
                                    bb = bb.func_186670_a(new BlockPos(0, 1, 0));
                                }
                                double minPitch = object.has("min") ? object.get("min").getAsDouble() : 0.5;
                                double maxPitch = object.has("max") ? object.get("max").getAsDouble() : 2.0;
                                double pitchPerBlock = object.has("pitchPerBlock") ? object.get("pitchPerBlock").getAsDouble() : 0.3;
                                result.pitch = (float)Math.max(minPitch, maxPitch - (double)depth * pitchPerBlock);
                                return true;
                            }
                            return false;
                        }
                    };
                }
                throw new IllegalArgumentException("Expected an object!");
            }
        });
        regionSelectors.put("isRaining", new AmbientConditionParser(){

            @Override
            public AmbientCondition parseCondition(final JsonElement element) throws IllegalArgumentException {
                if (element.isJsonPrimitive() && ((JsonPrimitive)element).isBoolean()) {
                    return new AmbientCondition(){

                        @Override
                        public boolean is(AmbientSituation situation, AmbientSoundResult result) {
                            return element.getAsBoolean() == situation.isRaining;
                        }
                    };
                }
                throw new IllegalArgumentException("Expected a boolean!");
            }
        });
        regionSelectors.put("isStorming", new AmbientConditionParser(){

            @Override
            public AmbientCondition parseCondition(final JsonElement element) throws IllegalArgumentException {
                if (element.isJsonPrimitive() && ((JsonPrimitive)element).isBoolean()) {
                    return new AmbientCondition(){

                        @Override
                        public boolean is(AmbientSituation situation, AmbientSoundResult result) {
                            return element.getAsBoolean() == situation.isThundering;
                        }
                    };
                }
                throw new IllegalArgumentException("Expected a boolean!");
            }
        });
        regionSelectors.put("top-block", new AmbientConditionParser(){

            @Override
            public AmbientCondition parseCondition(JsonElement element) throws IllegalArgumentException {
                if (element.isJsonPrimitive() && ((JsonPrimitive)element).isString()) {
                    String name = element.getAsString();
                    final Block block = Block.func_149684_b((String)name);
                    if (block == null) {
                        throw new IllegalArgumentException("Invalid block name '" + name + "'!");
                    }
                    return new AmbientCondition(){

                        @Override
                        public boolean is(AmbientSituation situation, AmbientSoundResult result) {
                            int i = 0;
                            while (i < situation.selectedBiomes.size()) {
                                AmbientSituation.BiomeArea area = situation.selectedBiomes.get(i);
                                if (area.biome.field_76752_A.func_177230_c() == block) {
                                    ++i;
                                    continue;
                                }
                                situation.selectedBiomes.remove(i);
                            }
                            if (!situation.selectedBiomes.isEmpty()) {
                                result.takeBiome = true;
                                return true;
                            }
                            return false;
                        }
                    };
                }
                throw new IllegalArgumentException("Expected a string!");
            }
        });
        regionSelectors.put("treesPerChunk", new AmbientMathConditionParser(){

            @Override
            public boolean is(AmbientMathConditionParser.MathOperator operator, double value, AmbientSituation situation) {
                int i = 0;
                while (i < situation.selectedBiomes.size()) {
                    AmbientSituation.BiomeArea area = situation.selectedBiomes.get(i);
                    if (operator.is(value, area.biome.field_76760_I.field_76832_z)) {
                        ++i;
                        continue;
                    }
                    situation.selectedBiomes.remove(i);
                }
                return !situation.selectedBiomes.isEmpty();
            }

            @Override
            public double getValue(AmbientSituation situation) {
                return 0.0;
            }

            @Override
            public boolean requiresBiome() {
                return true;
            }
        });
        regionSelectors.put("regions", new AmbientConditionParser(){

            @Override
            public AmbientCondition parseCondition(JsonElement element) throws IllegalArgumentException {
                if (element.isJsonArray()) {
                    JsonArray array = element.getAsJsonArray();
                    AmbientCondition[] regions = new AmbientCondition[array.size()];
                    for (int i = 0; i < regions.length; ++i) {
                        regions[i] = new AmbientRegionCondition(array.get(i).getAsString());
                    }
                    return new AmbientArrayOrCondition(regions);
                }
                throw new IllegalArgumentException("Expected a string array!");
            }
        });
        regionSelectors.put("bad-regions", new AmbientConditionParser(){

            @Override
            public AmbientCondition parseCondition(JsonElement element) throws IllegalArgumentException {
                if (element.isJsonArray()) {
                    JsonArray array = element.getAsJsonArray();
                    AmbientCondition[] regions = new AmbientCondition[array.size()];
                    for (int i = 0; i < regions.length; ++i) {
                        regions[i] = new AmbientInvertCondition(new AmbientRegionCondition(array.get(i).getAsString()));
                    }
                    return new AmbientArrayAndCondition(regions);
                }
                throw new IllegalArgumentException("Expected a string array!");
            }
        });
        regionSelectors.put("variants", new AmbientConditionParser(){

            @Override
            public AmbientCondition parseCondition(JsonElement element) throws IllegalArgumentException {
                return parser.parseCondition(element);
            }
        });
        regionSelectors.put("dimensions", new AmbientConditionParser(){

            @Override
            public AmbientCondition parseCondition(JsonElement element) throws IllegalArgumentException {
                if (element.isJsonArray()) {
                    final JsonArray array = element.getAsJsonArray();
                    return new AmbientCondition(){

                        @Override
                        public boolean is(AmbientSituation situation, AmbientSoundResult result) {
                            for (int i = 0; i < array.size(); ++i) {
                                JsonElement element = array.get(i);
                                if (element.getAsJsonPrimitive().isNumber()) {
                                    if (situation.world.field_73011_w.getDimension() != element.getAsInt()) continue;
                                    return true;
                                }
                                if (element.getAsJsonPrimitive().isString()) {
                                    if (!situation.world.field_73011_w.func_186058_p().name().equals(element.getAsString())) continue;
                                    return true;
                                }
                                throw new IllegalArgumentException("Expected a string or a number!");
                            }
                            return false;
                        }
                    };
                }
                throw new IllegalArgumentException("Expected a string array!");
            }
        });
        regionSelectors.put("bad-dimensions", new AmbientConditionParser(){

            @Override
            public AmbientCondition parseCondition(JsonElement element) throws IllegalArgumentException {
                if (element.isJsonArray()) {
                    final JsonArray array = element.getAsJsonArray();
                    return new AmbientCondition(){

                        @Override
                        public boolean is(AmbientSituation situation, AmbientSoundResult result) {
                            for (int i = 0; i < array.size(); ++i) {
                                JsonElement element = array.get(i);
                                if (element.getAsJsonPrimitive().isNumber()) {
                                    if (situation.world.field_73011_w.getDimension() != element.getAsInt()) continue;
                                    return false;
                                }
                                if (element.getAsJsonPrimitive().isString()) {
                                    if (!situation.world.field_73011_w.func_186058_p().name().equals(element.getAsString())) continue;
                                    return false;
                                }
                                throw new IllegalArgumentException("Expected a string or a number!");
                            }
                            return true;
                        }
                    };
                }
                throw new IllegalArgumentException("Expected a string array!");
            }
        });
    }

    public static abstract class AmbientMathConditionParser
    extends AmbientConditionParser {
        public double[] points;

        public abstract double getValue(AmbientSituation var1);

        public boolean is(MathOperator operator, double value, AmbientSituation situation) {
            return operator.is(value, this.getValue(situation));
        }

        public abstract boolean requiresBiome();

        @Override
        public AmbientCondition parseCondition(JsonElement element) throws IllegalArgumentException {
            if (element.isJsonPrimitive() && ((JsonPrimitive)element).isString()) {
                String[] parts = element.getAsString().split("&");
                AmbientCondition[] conditions = new AmbientCondition[parts.length];
                this.points = new double[parts.length];
                for (int i = 0; i < parts.length; ++i) {
                    double value;
                    final MathOperator operator = MathOperator.getOperator(parts[i]);
                    this.points[i] = value = Double.parseDouble(parts[i].replaceFirst(operator.identifier, ""));
                    conditions[i] = new AmbientCondition(){

                        @Override
                        public boolean is(AmbientSituation situation, AmbientSoundResult result) {
                            if (this.is(operator, value, situation)) {
                                if (this.requiresBiome()) {
                                    result.takeBiome = true;
                                }
                                return true;
                            }
                            return false;
                        }
                    };
                }
                return new AmbientArrayAndCondition(conditions);
            }
            throw new IllegalArgumentException("Expected a string!");
        }

        public static enum MathOperator {
            greater_equals(">="){

                @Override
                public boolean is(double base, double value) {
                    return base <= value;
                }
            }
            ,
            smaller_equals("<="){

                @Override
                public boolean is(double base, double value) {
                    return base >= value;
                }
            }
            ,
            greater(">"){

                @Override
                public boolean is(double base, double value) {
                    return base < value;
                }
            }
            ,
            smaller("<"){

                @Override
                public boolean is(double base, double value) {
                    return base > value;
                }
            }
            ,
            equals("="){

                @Override
                public boolean is(double base, double value) {
                    return base == value;
                }
            };

            public final String identifier;

            private MathOperator(String identifier) {
                this.identifier = identifier;
            }

            public abstract boolean is(double var1, double var3);

            public static MathOperator getOperator(String input) throws IllegalArgumentException {
                for (int i = 0; i < MathOperator.values().length; ++i) {
                    if (!input.startsWith(MathOperator.values()[i].identifier)) continue;
                    return MathOperator.values()[i];
                }
                throw new IllegalArgumentException("Missing valid operator: '" + input + "'!");
            }
        }
    }

    public static class AmbientConditionObjectParser
    extends AmbientConditionParser {
        @Override
        public AmbientCondition parseCondition(JsonElement element) throws IllegalArgumentException {
            if (element.isJsonArray()) {
                JsonArray array = element.getAsJsonArray();
                AmbientCondition[] conditions = new AmbientCondition[array.size()];
                for (int i = 0; i < array.size(); ++i) {
                    try {
                        conditions[i] = this.parseCondition(array.get(i));
                        continue;
                    }
                    catch (Exception e) {
                        AmbientSounds.logger.error("Could not load condition of '" + element + "'!");
                        e.printStackTrace();
                    }
                }
                return new AmbientArrayOrCondition(conditions);
            }
            if (element.isJsonObject()) {
                JsonObject object = element.getAsJsonObject();
                ArrayList<AmbientCondition> conditions = new ArrayList<AmbientCondition>();
                HashMap<String, JsonElement> unknown = new HashMap<String, JsonElement>();
                for (Map.Entry entry : object.entrySet()) {
                    AmbientConditionParser parser = regionSelectors.get(entry.getKey());
                    if (parser != null) {
                        try {
                            conditions.add(parser.parseCondition((JsonElement)entry.getValue()));
                        }
                        catch (Exception e) {
                            AmbientSounds.logger.error("Could not load condition of '" + (String)entry.getKey() + ":" + entry.getValue() + "'!");
                            e.printStackTrace();
                        }
                        continue;
                    }
                    unknown.put((String)entry.getKey(), (JsonElement)entry.getValue());
                }
                AmbientArrayAndCondition condition = new AmbientArrayAndCondition(conditions.toArray(new AmbientCondition[0]));
                this.treatUnknownValues(condition, unknown);
                return condition;
            }
            throw new IllegalArgumentException("Expected element to be either an array or an object!");
        }

        public void treatUnknownValues(AmbientCondition condition, HashMap<String, JsonElement> unknown) {
        }
    }

    public static abstract class AmbientConditionParser {
        public abstract AmbientCondition parseCondition(JsonElement var1) throws IllegalArgumentException;
    }

    public static class AmbientRegionCondition
    extends AmbientCondition {
        public String regionName;
        public AmbientCondition condition;

        public AmbientRegionCondition(String region) {
            this.regionName = region;
        }

        @Override
        public boolean is(AmbientSituation situation, AmbientSoundResult result) {
            if (this.condition == null) {
                this.condition = AmbientSoundLoader.regions.get(this.regionName);
                if (this.condition == null) {
                    throw new IllegalArgumentException("Region '" + this.regionName + "' does not exist!");
                }
            }
            return this.condition.is(situation, result);
        }
    }

    public static class AmbientInvertCondition
    extends AmbientCondition {
        public AmbientCondition condition;

        public AmbientInvertCondition(AmbientCondition condition) {
            this.condition = condition;
        }

        @Override
        public boolean is(AmbientSituation situation, AmbientSoundResult result) {
            return !this.condition.is(situation, result);
        }
    }

    public static class AmbientArrayAndCondition
    extends AmbientCondition {
        public final AmbientCondition[] conditions;

        public AmbientArrayAndCondition(AmbientCondition[] conditions) {
            this.conditions = conditions;
        }

        @Override
        public boolean is(AmbientSituation situation, AmbientSoundResult result) {
            ArrayList<AmbientSituation.BiomeArea> previous = situation.selectedBiomes;
            for (int i = 0; i < this.conditions.length; ++i) {
                situation.selectedBiomes = new ArrayList<AmbientSituation.BiomeArea>(previous);
                if (!this.conditions[i].is(situation, result)) {
                    return false;
                }
                result.conditions.add(this.conditions[i]);
            }
            return true;
        }
    }

    public static class AmbientArrayOrCondition
    extends AmbientCondition {
        public final AmbientCondition[] conditions;

        public AmbientArrayOrCondition(AmbientCondition[] conditions) {
            this.conditions = conditions;
        }

        @Override
        public boolean is(AmbientSituation situation, AmbientSoundResult result) {
            ArrayList<AmbientSituation.BiomeArea> previous = situation.selectedBiomes;
            for (int i = 0; i < this.conditions.length; ++i) {
                situation.selectedBiomes = new ArrayList<AmbientSituation.BiomeArea>(previous);
                if (!this.conditions[i].is(situation, result)) continue;
                result.conditions.add(this.conditions[i]);
                return true;
            }
            situation.selectedBiomes = previous;
            return false;
        }
    }
}

