/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.swampmobs.model;

import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.model.ModelObjOld;
import com.lycanitesmobs.swampmobs.SwampMobs;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelDweller
extends ModelObjOld {
    boolean attackAlt = false;
    boolean attacking = false;

    public ModelDweller() {
        this(1.0f);
    }

    public ModelDweller(float shadowSize) {
        this.initModel("Dweller", SwampMobs.instance.group, "entity/dweller");
        this.setPartCenter("head", 0.0f, 1.5f, 0.2f);
        this.setPartCenter("mouth", 0.0f, 1.5f, 0.2f);
        this.setPartCenter("body", 0.0f, 1.5f, 0.2f);
        this.setPartCenter("leftarm", 0.4f, 1.5f, 0.0f);
        this.setPartCenter("rightarm", -0.4f, 1.5f, 0.0f);
        this.setPartCenter("tail01", 0.0f, 1.0f, 0.0f);
        this.setPartCenter("tail02", 0.0f, 0.45f, -0.1f);
        this.setPartCenter("tail03", 0.0f, 0.11f, -0.3f);
        this.setPartCenter("tail04", 0.0f, 0.1f, -0.85f);
        this.setPartCenter("tail05", 0.0f, 0.09f, -1.3f);
        this.setPartCenter("tail06", 0.0f, 0.08f, -1.65f);
        this.trophyScale = 1.0f;
        this.trophyOffset = new float[]{0.0f, 0.0f, -0.4f};
    }

    @Override
    public void animatePart(String partName, EntityLiving entity, float time, float distance, float loop, float lookY, float lookX, float scale) {
        super.animatePart(partName, entity, time, distance, loop, lookY, lookX, scale);
        float pi = (float)Math.PI;
        float posX = 0.0f;
        float posY = 0.0f;
        float posZ = 0.0f;
        float angleX = 0.0f;
        float angleY = 0.0f;
        float angleZ = 0.0f;
        float rotation = 0.0f;
        float rotX = 0.0f;
        float rotY = 0.0f;
        float rotZ = 0.0f;
        float scaleX = 1.0f;
        float scaleY = 1.0f;
        float scaleZ = 1.0f;
        if (partName.equals("mouth")) {
            if (!this.lockHeadX) {
                rotX = (float)((double)rotX + Math.toDegrees(lookX / 57.295776f));
            }
            if (!this.lockHeadY) {
                rotY = (float)((double)rotY + Math.toDegrees(lookY / 57.295776f));
            }
        }
        if (partName.equals("mouth")) {
            this.translate(0.0f, -0.2f, 0.0f);
            angleX = -1.0f;
        }
        if (partName.equals("mouth")) {
            rotation = (float)((double)rotation + Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.09f)) * 0.05f - 0.05f));
            if (entity instanceof EntityCreatureBase && ((EntityCreatureBase)entity).justAttacked()) {
                rotation = 20.0f;
            }
            this.rotate(rotation, angleX, angleY, angleZ);
            rotation = 0.0f;
        }
        if (partName.equals("mouth")) {
            this.translate(-0.0f, 0.2f, 0.0f);
        }
        if (partName.equals("leftarm")) {
            rotZ = (float)((double)rotZ - Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.09f)) * 0.05f + 0.05f));
            rotX = (float)((double)rotX - Math.toDegrees(MathHelper.func_76126_a((float)(loop * 0.067f)) * 0.05f));
            if (entity instanceof EntityCreatureBase && ((EntityCreatureBase)entity).justAttacked()) {
                rotY = this.attackAlt ? 40.0f : -25.0f;
            }
        }
        if (partName.equals("rightarm")) {
            rotZ = (float)((double)rotZ + Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.09f)) * 0.05f + 0.05f));
            rotX = (float)((double)rotX + Math.toDegrees(MathHelper.func_76126_a((float)(loop * 0.067f)) * 0.05f));
            if (entity instanceof EntityCreatureBase && ((EntityCreatureBase)entity).justAttacked()) {
                rotY = this.attackAlt ? 40.0f : -25.0f;
            }
        }
        if (entity instanceof EntityCreatureBase && ((EntityCreatureBase)entity).justAttacked() && !this.attacking) {
            this.attackAlt = !this.attackAlt;
            this.attacking = true;
        }
        if (entity instanceof EntityCreatureBase && !((EntityCreatureBase)entity).justAttacked()) {
            this.attacking = false;
        }
        float walkSwing = 0.1f;
        float walkOffset = 0.1f;
        time *= 4.0f;
        if (partName.equals("leftarm")) {
            this.translate(-0.4f, 0.0f, 0.2f);
        }
        if (partName.equals("rightarm")) {
            this.translate(0.4f, 0.0f, 0.2f);
        }
        if (partName.equals("leftarm") || partName.equals("rightarm")) {
            this.rotate(0.0f, 0.0f, (float)this.rotateToPoint(0.0, 0.0, -0.5, MathHelper.func_76126_a((float)(time * walkSwing)) * walkSwing));
        }
        if (partName.equals("leftarm")) {
            this.translate(0.4f, 0.0f, -0.2f);
        }
        if (partName.equals("rightarm")) {
            this.translate(-0.4f, 0.0f, -0.2f);
        }
        if (partName.equals("body")) {
            rotZ = (float)((double)rotZ + this.rotateToPoint(0.0, 0.0, -0.5, MathHelper.func_76126_a((float)(time * walkSwing)) * walkSwing));
        }
        if (partName.equals("tail01") || partName.equals("tail02") || partName.equals("tail03") || partName.equals("tail04") || partName.equals("tail05") || partName.equals("tail06")) {
            double[] tailAnimation = new double[]{0.0, 0.0, 0.0, 0.0};
            if (partName.equals("tail01")) {
                tailAnimation = this.getTailRotation(partName, "body", 1, walkSwing, walkOffset, time);
            }
            if (partName.equals("tail02")) {
                tailAnimation = this.getTailRotation(partName, "tail01", 2, walkSwing, walkOffset, time);
            }
            if (partName.equals("tail03")) {
                tailAnimation = this.getTailRotation(partName, "tail02", 3, walkSwing, walkOffset, time);
            }
            if (partName.equals("tail04")) {
                tailAnimation = this.getTailRotation(partName, "tail03", 4, walkSwing, walkOffset, time);
            }
            if (partName.equals("tail05")) {
                tailAnimation = this.getTailRotation(partName, "tail04", 5, walkSwing, walkOffset, time);
            }
            if (partName.equals("tail06")) {
                tailAnimation = this.getTailRotation(partName, "tail05", 6, walkSwing, walkOffset, time);
            }
            posX = (float)((double)posX + tailAnimation[0]);
            rotY = (float)((double)rotY + tailAnimation[2]);
            if (partName.equals("tail01") || partName.equals("tail02") || partName.equals("tail03")) {
                rotZ = (float)((double)rotZ + tailAnimation[3]);
            }
        }
        this.translate(posX, posY, posZ);
        this.rotate(rotation, angleX, angleY, angleZ);
        this.rotate(rotX, rotY, rotZ);
        this.scale(scaleX, scaleY, scaleZ);
    }

    public double[] getTailRotation(String tailName, String targetName, int tailID, float walkSwing, float walkOffset, float time) {
        double[] animation = new double[4];
        animation[0] = MathHelper.func_76126_a((float)((time + walkOffset * (float)tailID) * walkSwing * (float)tailID)) * walkSwing;
        float parentX = MathHelper.func_76126_a((float)((time + walkOffset * (float)(tailID - 1)) * walkSwing * (float)tailID)) * walkSwing;
        float[] partDifference = this.comparePartCenters(tailName, targetName);
        if (tailID == 1) {
            partDifference[1] = partDifference[1] + 0.5f;
        }
        double[] rotations = this.rotateToPoint((float)animation[0], 0.0, 0.0, parentX - partDifference[0], -partDifference[1], partDifference[2]);
        animation[1] = rotations[0];
        animation[2] = rotations[1];
        animation[3] = rotations[2];
        return animation;
    }
}

