/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.swampmobs.entity;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.PotionBase;
import com.lycanitesmobs.api.IGroupHunter;
import com.lycanitesmobs.api.IGroupPrey;
import com.lycanitesmobs.core.entity.EntityCreatureTameable;
import com.lycanitesmobs.core.entity.ai.EntityAIAttackMelee;
import com.lycanitesmobs.core.entity.ai.EntityAIAvoid;
import com.lycanitesmobs.core.entity.ai.EntityAIBeg;
import com.lycanitesmobs.core.entity.ai.EntityAIFollowOwner;
import com.lycanitesmobs.core.entity.ai.EntityAIFollowParent;
import com.lycanitesmobs.core.entity.ai.EntityAILookIdle;
import com.lycanitesmobs.core.entity.ai.EntityAIMate;
import com.lycanitesmobs.core.entity.ai.EntityAIStealth;
import com.lycanitesmobs.core.entity.ai.EntityAISwimming;
import com.lycanitesmobs.core.entity.ai.EntityAITargetAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerThreats;
import com.lycanitesmobs.core.entity.ai.EntityAITargetParent;
import com.lycanitesmobs.core.entity.ai.EntityAITargetRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAITempt;
import com.lycanitesmobs.core.entity.ai.EntityAIWander;
import com.lycanitesmobs.core.entity.ai.EntityAIWatchClosest;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.ObjectLists;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityLurker
extends EntityCreatureTameable
implements IGroupHunter {
    public EntityLurker(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.ARTHROPOD;
        this.hasAttackSound = true;
        this.setupMob();
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIStealth(this).setStealthTime(20).setStealthAttack(true).setStealthMove(true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAvoid(this).setNearSpeed(2.0).setFarSpeed(1.5).setNearDistance(5.0).setFarDistance(10.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee(this).setLongMemory(false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiSit);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFollowOwner(this).setStrayDistance(8.0).setLostDistance(32.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAITempt(this).setItem(new ItemStack(ObjectManager.getItem("lurkertreat"))).setTemptDistanceMin(2.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIMate(this));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIFollowParent(this));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWander(this));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIBeg(this));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAIWatchClosest(this).setTargetClass(EntityPlayer.class));
        this.field_70714_bg.func_75776_a(12, (EntityAIBase)new EntityAILookIdle(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAITargetOwnerRevenge(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAITargetOwnerAttack(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetRevenge(this).setHelpCall(true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityPlayer.class));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityVillager.class));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(IGroupPrey.class));
        if (CreatureManager.getInstance().config.predatorsAttackAnimals) {
            this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityChicken.class));
            this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(IGroupPrey.class));
        }
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAITargetParent(this).setSightCheck(false).setDistance(32.0));
        this.field_70715_bh.func_75776_a(6, (EntityAIBase)new EntityAITargetOwnerThreats(this));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70638_az() != null) {
            PotionBase stalkingEffect = ObjectManager.getPotionEffect("plague");
            if (stalkingEffect != null && this.func_70638_az().func_70644_a((Potion)stalkingEffect)) {
                this.setAvoidTarget(this.func_70638_az());
            } else {
                this.setAvoidTarget(null);
            }
        } else {
            this.setAvoidTarget(null);
        }
        if (this.field_70122_E && !this.func_130014_f_().field_72995_K && this.field_70146_Z.nextInt(10) == 0) {
            if (this.hasAttackTarget()) {
                this.leap(6.0f, 0.4, (Entity)this.func_70638_az());
            } else if (this.hasAvoidTarget()) {
                this.leap(4.0, 0.4);
            }
        }
    }

    @Override
    public boolean canStealth() {
        if (this.func_130014_f_().field_72995_K) {
            return false;
        }
        if (this.hasAttackTarget()) {
            PotionBase stalkingEffect;
            if (this.func_70638_az() instanceof EntityPlayer) {
                EntityPlayer playerTarget = (EntityPlayer)this.func_70638_az();
                ItemStack itemstack = playerTarget.field_71071_by.func_70448_g();
                if (itemstack != null && this.isTamingItem(itemstack)) {
                    return false;
                }
            }
            if ((stalkingEffect = ObjectManager.getPotionEffect("plague")) != null && !this.func_70638_az().func_70644_a((Potion)stalkingEffect)) {
                return false;
            }
            if (this.func_70068_e((Entity)this.func_70638_az()) < 25.0) {
                return false;
            }
        } else if (this.isMoving()) {
            return false;
        }
        return true;
    }

    @Override
    public void startStealth() {
        if (this.func_130014_f_().field_72995_K) {
            EnumParticleTypes particle = EnumParticleTypes.SMOKE_NORMAL;
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            for (int i = 0; i < 100; ++i) {
                this.func_130014_f_().func_175688_a(particle, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
            }
        }
        super.startStealth();
    }

    @Override
    public boolean canClimb() {
        return true;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return 5;
    }

    @Override
    public boolean isTamingItem(ItemStack itemstack) {
        return itemstack.func_77973_b() == ObjectManager.getItem("lurkertreat");
    }

    @Override
    public boolean isHealingItem(ItemStack testStack) {
        return ObjectLists.inItemList("CookedMeat", testStack);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_98034_c(EntityPlayer player) {
        if (this.isTamed() && this.func_70902_q() == player) {
            return false;
        }
        return this.func_82150_aj();
    }
}

