/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.shadowmobs.entity;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.api.IGroupAlpha;
import com.lycanitesmobs.api.IGroupHunter;
import com.lycanitesmobs.api.IGroupPredator;
import com.lycanitesmobs.api.IGroupPrey;
import com.lycanitesmobs.api.IGroupShadow;
import com.lycanitesmobs.core.entity.EntityCreatureAgeable;
import com.lycanitesmobs.core.entity.EntityCreatureRideable;
import com.lycanitesmobs.core.entity.ai.EntityAIAttackMelee;
import com.lycanitesmobs.core.entity.ai.EntityAIBeg;
import com.lycanitesmobs.core.entity.ai.EntityAILookIdle;
import com.lycanitesmobs.core.entity.ai.EntityAISwimming;
import com.lycanitesmobs.core.entity.ai.EntityAITargetAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerThreats;
import com.lycanitesmobs.core.entity.ai.EntityAITargetRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAITargetRiderAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetRiderRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAITempt;
import com.lycanitesmobs.core.entity.ai.EntityAIWander;
import com.lycanitesmobs.core.entity.ai.EntityAIWatchClosest;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.ObjectLists;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class EntityShade
extends EntityCreatureRideable
implements IGroupPredator,
IGroupHunter,
IGroupShadow {
    public EntityShade(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.hasAttackSound = true;
        this.hasJumpSound = true;
        this.canGrow = false;
        this.setupMob();
        this.field_70138_W = 1.0f;
        this.attackTime = 40;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAITempt(this).setItem(new ItemStack(ObjectManager.getItem("shadetreat"))).setTemptDistanceMin(4.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIAttackMelee(this).setSpeed(1.5));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander(this).setSpeed(1.0));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIBeg(this));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest(this).setTargetClass(EntityPlayer.class));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAILookIdle(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAITargetRiderRevenge(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAITargetRiderAttack(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetRevenge(this));
        if (CreatureManager.getInstance().config.predatorsAttackAnimals) {
            this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityCow.class).setTameTargetting(true));
            this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityPig.class).setTameTargetting(true));
            this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntitySheep.class).setTameTargetting(true));
        }
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityPlayer.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityVillager.class));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityPigZombie.class));
        if (CreatureManager.getInstance().config.predatorsAttackAnimals) {
            this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(IGroupAlpha.class));
            this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityAnimal.class));
        }
        this.field_70715_bh.func_75776_a(6, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(IGroupPrey.class));
        this.field_70715_bh.func_75776_a(7, (EntityAIBase)new EntityAITargetOwnerThreats(this));
    }

    @Override
    public void mountAbility(Entity rider) {
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        if (this.abilityToggled) {
            return;
        }
        if (this.getStamina() < this.getStaminaCost()) {
            return;
        }
        this.specialAttack();
        this.applyStaminaCost();
    }

    @Override
    public float getStaminaCost() {
        return 100.0f;
    }

    @Override
    public int getStaminaRecoveryWarmup() {
        return 100;
    }

    @Override
    public float getStaminaRecoveryMax() {
        return 1.0f;
    }

    @Override
    public double func_70042_X() {
        return (double)this.field_70131_O * 0.85;
    }

    @Override
    public boolean attackMelee(Entity target, double damageScale) {
        if (!super.attackMelee(target, damageScale)) {
            return false;
        }
        float leeching = this.getEffectStrength(this.getAttackDamage(damageScale) / 4.0f);
        this.func_70691_i(leeching);
        if (this.func_70681_au().nextFloat() <= 0.1f) {
            this.specialAttack();
        }
        return true;
    }

    public void specialAttack() {
        double distance = 5.0;
        List possibleTargets = this.func_130014_f_().func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(distance, distance, distance), possibleTarget -> possibleTarget.func_70089_S() && possibleTarget != this && !this.func_184215_y((Entity)possibleTarget) && !this.func_184191_r((Entity)possibleTarget) && this.func_70686_a(possibleTarget.getClass()) && this.canAttackEntity((EntityLivingBase)possibleTarget));
        if (!possibleTargets.isEmpty()) {
            for (EntityLivingBase possibleTarget2 : possibleTargets) {
                boolean doDamage = true;
                if (this.getRider() instanceof EntityPlayer && MinecraftForge.EVENT_BUS.post((Event)new AttackEntityEvent((EntityPlayer)this.getRider(), (Entity)possibleTarget2))) {
                    doDamage = false;
                }
                if (!doDamage) continue;
                if (ObjectManager.getPotionEffect("fear") != null) {
                    possibleTarget2.func_70690_d(new PotionEffect((Potion)ObjectManager.getPotionEffect("fear"), this.getEffectDuration(5), 1));
                    continue;
                }
                possibleTarget2.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 200, 0));
            }
        }
        this.playAttackSound();
        this.setJustAttacked();
    }

    @Override
    public boolean canBeTempted() {
        return true;
    }

    @Override
    public boolean petControlsEnabled() {
        return false;
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return 10;
    }

    @Override
    public boolean isDamageTypeApplicable(String type, DamageSource source, float damage) {
        if (type.equals("inWall")) {
            return false;
        }
        return super.isDamageTypeApplicable(type, source, damage);
    }

    @Override
    public float getFallResistance() {
        return 10.0f;
    }

    @Override
    public EntityCreatureAgeable createChild(EntityCreatureAgeable baby) {
        return new EntityShade(this.func_130014_f_());
    }

    @Override
    public boolean isBreedingItem(ItemStack itemStack) {
        return false;
    }

    @Override
    public boolean isTamingItem(ItemStack itemstack) {
        return itemstack.func_77973_b() == ObjectManager.getItem("shadetreat");
    }

    @Override
    public boolean isHealingItem(ItemStack testStack) {
        return ObjectLists.inItemList("cookedmeat", testStack);
    }
}

