/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.plainsmobs.entity;

import com.lycanitesmobs.api.IGroupAlpha;
import com.lycanitesmobs.api.IGroupHunter;
import com.lycanitesmobs.api.IGroupPredator;
import com.lycanitesmobs.api.IGroupPrey;
import com.lycanitesmobs.core.config.ConfigBase;
import com.lycanitesmobs.core.entity.EntityCreatureAgeable;
import com.lycanitesmobs.core.entity.EntityCreatureTameable;
import com.lycanitesmobs.core.entity.ai.EntityAIAttackMelee;
import com.lycanitesmobs.core.entity.ai.EntityAIAvoid;
import com.lycanitesmobs.core.entity.ai.EntityAIFollowOwner;
import com.lycanitesmobs.core.entity.ai.EntityAIGetBlock;
import com.lycanitesmobs.core.entity.ai.EntityAIGetItem;
import com.lycanitesmobs.core.entity.ai.EntityAILookIdle;
import com.lycanitesmobs.core.entity.ai.EntityAISwimming;
import com.lycanitesmobs.core.entity.ai.EntityAITargetAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetAvoid;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerThreats;
import com.lycanitesmobs.core.entity.ai.EntityAITargetRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAIWander;
import com.lycanitesmobs.core.entity.ai.EntityAIWatchClosest;
import com.lycanitesmobs.core.info.ObjectLists;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityKobold
extends EntityCreatureTameable
implements IMob,
IGroupPrey {
    public boolean torchGreifing = true;
    private int torchLootingTime = 20;

    public EntityKobold(World world) {
        super(world);
        this.torchGreifing = ConfigBase.getConfig(this.creatureInfo.group, "general").getBool("Features", "Kobold Torch Griefing", this.torchGreifing, "Set to false to stop Kobolds from stealing torches.");
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.hasAttackSound = true;
        this.spreadFire = false;
        this.canGrow = false;
        this.babySpawnChance = 0.1;
        this.setupMob();
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee(this).setTargetClass(EntityPlayer.class).setLongMemory(false));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIGetItem(this).setDistanceMax(32.0).setSpeed(1.2));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiSit);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFollowOwner(this).setStrayDistance(8.0).setLostDistance(32.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIAvoid(this).setNearSpeed(1.8).setFarSpeed(1.4).setNearDistance(3.0).setFarDistance(16.0));
        if (this.torchGreifing) {
            this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIGetBlock(this).setDistanceMax(8).setSpeed(1.2).setBlockName("torch").setTamedLooting(false));
        }
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWander(this).setPauseRate(30));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest(this).setTargetClass(EntityPlayer.class));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAILookIdle(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAITargetOwnerRevenge(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAITargetOwnerAttack(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetRevenge(this).setHelpCall(true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityPlayer.class));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityVillager.class).setCheckSight(false));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAvoid(this).setTargetClass(EntityPlayer.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAvoid(this).setTargetClass(IGroupHunter.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAvoid(this).setTargetClass(IGroupPredator.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAvoid(this).setTargetClass(IGroupAlpha.class));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAITargetAvoid(this).setTargetClass(EntityVillager.class));
        this.field_70715_bh.func_75776_a(6, (EntityAIBase)new EntityAITargetOwnerThreats(this));
    }

    @Override
    protected boolean func_70692_ba() {
        if (this.inventory.hasBagItems()) {
            return false;
        }
        return super.func_70692_ba();
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.isTamed() && this.func_130014_f_().func_82736_K().func_82766_b("mobGriefing") && this.torchGreifing && this.torchLootingTime-- <= 0) {
            this.torchLootingTime = 60;
            int distance = 2;
            String targetName = "torch";
            ArrayList possibleTargets = new ArrayList();
            for (int x = (int)this.field_70165_t - distance; x < (int)this.field_70165_t + distance; ++x) {
                block1: for (int y = (int)this.field_70163_u - distance; y < (int)this.field_70163_u + distance; ++y) {
                    for (int z = (int)this.field_70161_v - distance; z < (int)this.field_70161_v + distance; ++z) {
                        BlockPos pos = new BlockPos(x, y, z);
                        Block searchBlock = this.func_130014_f_().func_180495_p(pos).func_177230_c();
                        if (searchBlock == null || searchBlock == Blocks.field_150350_a) continue;
                        Object possibleTarget = null;
                        if (!ObjectLists.isName(searchBlock, targetName)) continue;
                        this.func_130014_f_().func_175655_b(pos, true);
                        continue block1;
                    }
                }
            }
        }
    }

    @Override
    public boolean canAttackEntity(EntityLivingBase targetEntity) {
        if (targetEntity.func_110143_aJ() / targetEntity.func_110138_aP() > 0.5f) {
            return false;
        }
        return super.canAttackEntity(targetEntity);
    }

    @Override
    public int getNoBagSize() {
        return 10;
    }

    @Override
    public int getBagSize() {
        return 10;
    }

    @Override
    public boolean canPickupItems() {
        return ConfigBase.getConfig(this.creatureInfo.group, "general").getBool("Features", "Kobold Thievery", true, "Set to false to prevent Kobold from collecting items.");
    }

    @Override
    public EntityCreatureAgeable createChild(EntityCreatureAgeable baby) {
        return new EntityKobold(this.func_130014_f_());
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }
}

