/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.mountainmobs.entity;

import com.lycanitesmobs.core.config.ConfigBase;
import com.lycanitesmobs.core.entity.EntityCreatureTameable;
import com.lycanitesmobs.core.entity.ai.EntityAIAttackRanged;
import com.lycanitesmobs.core.entity.ai.EntityAIBreakDoor;
import com.lycanitesmobs.core.entity.ai.EntityAIFollowOwner;
import com.lycanitesmobs.core.entity.ai.EntityAILookIdle;
import com.lycanitesmobs.core.entity.ai.EntityAISwimming;
import com.lycanitesmobs.core.entity.ai.EntityAITargetAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerThreats;
import com.lycanitesmobs.core.entity.ai.EntityAITargetRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAIWander;
import com.lycanitesmobs.core.entity.ai.EntityAIWatchClosest;
import com.lycanitesmobs.core.info.ObjectLists;
import com.lycanitesmobs.mountainmobs.entity.EntityBoulderBlast;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityTroll
extends EntityCreatureTameable
implements IMob {
    public boolean trollGreifing = true;
    public boolean stoneForm = false;

    public EntityTroll(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.hasAttackSound = false;
        this.trollGreifing = ConfigBase.getConfig(this.creatureInfo.group, "general").getBool("Features", "Troll Griefing", this.trollGreifing, "Set to false to disable Troll block destruction.");
        this.solidCollision = true;
        this.setupMob();
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        if (this.func_70661_as() instanceof PathNavigateGround) {
            PathNavigateGround pathNavigateGround = (PathNavigateGround)this.func_70661_as();
            pathNavigateGround.func_179688_b(true);
        }
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIBreakDoor(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIAttackRanged(this).setSpeed(0.5).setRange(14.0f).setMinChaseDistance(5.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)this.aiSit);
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIFollowOwner(this).setStrayDistance(8.0).setLostDistance(32.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWander(this));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest(this).setTargetClass(EntityPlayer.class));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAILookIdle(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAITargetOwnerRevenge(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAITargetOwnerAttack(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetRevenge(this).setHelpCall(true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityPlayer.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityVillager.class));
        this.field_70715_bh.func_75776_a(6, (EntityAIBase)new EntityAITargetOwnerThreats(this));
    }

    @Override
    public String getTextureName() {
        if (this.stoneForm) {
            return super.getTextureName() + "_stone";
        }
        return super.getTextureName();
    }

    @Override
    public void func_70636_d() {
        float distance;
        super.func_70636_d();
        if (!this.stoneForm) {
            if (this.isDaytime() && this.func_130014_f_().func_175710_j(this.func_180425_c())) {
                this.stoneForm = true;
            }
        } else if (!this.isDaytime() || !this.func_130014_f_().func_175710_j(this.func_180425_c())) {
            this.stoneForm = false;
        }
        if (!this.func_130014_f_().field_72995_K && this.func_70638_az() != null && this.func_130014_f_().func_82736_K().func_82766_b("mobGriefing") && this.trollGreifing && (distance = this.func_70638_az().func_70032_d((Entity)this)) <= this.field_70130_N + 4.0f) {
            this.destroyArea((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 10.0f, true);
        }
    }

    @Override
    public float getAISpeedModifier() {
        if (this.stoneForm) {
            return 0.125f;
        }
        return 1.0f;
    }

    @Override
    public void attackRanged(Entity target, float range) {
        this.fireProjectile(EntityBoulderBlast.class, target, range, 0.0f, new Vec3d(0.0, 0.0, 0.0), 1.2f, 2.0f, 1.0f);
        super.attackRanged(target, range);
    }

    @Override
    public float getDamageModifier(DamageSource damageSrc) {
        if ("Jarno".equals(this.func_95999_t())) {
            return 0.0f;
        }
        if (this.stoneForm) {
            if (damageSrc.func_76346_g() != null) {
                EntityLivingBase entityLiving;
                Item heldItem = null;
                if (damageSrc.func_76346_g() instanceof EntityLivingBase && (entityLiving = (EntityLivingBase)damageSrc.func_76346_g()).func_184586_b(EnumHand.MAIN_HAND) != null) {
                    heldItem = entityLiving.func_184586_b(EnumHand.MAIN_HAND).func_77973_b();
                }
                if (ObjectLists.isPickaxe(heldItem)) {
                    return 2.0f;
                }
            }
            return 0.25f;
        }
        if (damageSrc.func_76347_k()) {
            return 2.0f;
        }
        return 1.0f;
    }

    @Override
    public float getFallResistance() {
        return 50.0f;
    }

    @Override
    public boolean canBurn() {
        return !this.stoneForm;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }
}

