/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.mountainmobs.entity;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.entity.EntityCreatureRideable;
import com.lycanitesmobs.core.entity.ai.EntityAIAttackRanged;
import com.lycanitesmobs.core.entity.ai.EntityAILookIdle;
import com.lycanitesmobs.core.entity.ai.EntityAIPlayerControl;
import com.lycanitesmobs.core.entity.ai.EntityAITargetAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerThreats;
import com.lycanitesmobs.core.entity.ai.EntityAITargetRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAITempt;
import com.lycanitesmobs.core.entity.ai.EntityAIWander;
import com.lycanitesmobs.core.entity.ai.EntityAIWatchClosest;
import com.lycanitesmobs.core.info.ObjectLists;
import com.lycanitesmobs.mountainmobs.entity.EntityArcaneLaserStorm;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityBeholder
extends EntityCreatureRideable {
    public EntityBeholder(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.hasAttackSound = false;
        this.justAttackedTime = (short)20;
        this.solidCollision = true;
        this.setupMob();
        this.field_70138_W = 1.0f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIPlayerControl(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAITempt(this).setItem(new ItemStack(ObjectManager.getItem("beholdertreat"))).setTemptDistanceMin(4.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIAttackRanged(this).setSpeed(0.25).setRange(40.0f).setMinChaseDistance(10.0f).setLongMemory(false));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander(this).setPauseRate(30));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest(this).setTargetClass(EntityPlayer.class));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAILookIdle(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAITargetOwnerRevenge(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAITargetOwnerAttack(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetRevenge(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityPlayer.class));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityVillager.class));
        this.field_70715_bh.func_75776_a(6, (EntityAIBase)new EntityAITargetOwnerThreats(this));
    }

    @Override
    public void riderEffects(EntityLivingBase rider) {
        if (rider.func_70644_a(MobEffects.field_76419_f)) {
            rider.func_184589_d(MobEffects.field_76419_f);
        }
        if (rider.func_70644_a((Potion)ObjectManager.getPotionEffect("weight"))) {
            rider.func_184589_d((Potion)ObjectManager.getPotionEffect("weight"));
        }
    }

    @Override
    public void onDamage(DamageSource damageSrc, float damage) {
        super.onDamage(damageSrc, damage);
        Entity damageEntity = damageSrc.func_76346_g();
        if (damageEntity != null && ("mob".equals(damageSrc.field_76373_n) || "player".equals(damageSrc.field_76373_n)) && damageEntity instanceof EntityLivingBase) {
            EntityLivingBase targetLiving = (EntityLivingBase)damageEntity;
            ArrayList<Potion> goodEffects = new ArrayList<Potion>();
            for (Object potionEffectObj : targetLiving.func_70651_bq()) {
                Potion potion;
                if (!(potionEffectObj instanceof PotionEffect) || (potion = ((PotionEffect)potionEffectObj).func_188419_a()) == null || !ObjectLists.inEffectList("buffs", potion)) continue;
                goodEffects.add(potion);
            }
            if (goodEffects.size() > 0 && this.func_70681_au().nextBoolean()) {
                if (goodEffects.size() > 1) {
                    targetLiving.func_184589_d((Potion)goodEffects.get(this.func_70681_au().nextInt(goodEffects.size())));
                } else {
                    targetLiving.func_184589_d((Potion)goodEffects.get(0));
                }
                float leeching = damage * 1.1f;
                this.func_70691_i(leeching);
            }
        }
    }

    @Override
    public boolean isFlying() {
        return true;
    }

    @Override
    public boolean petControlsEnabled() {
        return false;
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return 5;
    }

    @Override
    public void attackRanged(Entity target, float range) {
        this.fireProjectile(EntityArcaneLaserStorm.class, target, range, 0.0f, new Vec3d(0.0, 0.0, 0.0), 1.2f, 2.0f, 1.0f);
        super.attackRanged(target, range);
    }

    @Override
    public boolean isDamageEntityApplicable(Entity entity) {
        if (entity instanceof EntityBeholder) {
            return false;
        }
        return super.isDamageEntityApplicable(entity);
    }

    @Override
    public boolean canBurn() {
        return false;
    }

    @Override
    public double func_70042_X() {
        return (double)this.field_70131_O * 0.9;
    }

    @Override
    public boolean isTamingItem(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        return itemStack.func_77973_b() == ObjectManager.getItem("beholdertreat");
    }

    @Override
    public void mountAbility(Entity rider) {
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        if (this.abilityToggled) {
            return;
        }
        if (this.hasPickupEntity()) {
            this.dropPickupEntity();
            return;
        }
        if (this.getStamina() < this.getStaminaCost()) {
            return;
        }
        if (rider instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)rider;
            EntityArcaneLaserStorm projectile = new EntityArcaneLaserStorm(this.func_130014_f_(), (EntityLivingBase)player);
            this.func_130014_f_().func_72838_d((Entity)projectile);
            this.func_184185_a(projectile.getLaunchSound(), 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            this.setJustAttacked();
        }
        this.applyStaminaCost();
    }

    @Override
    public float getStaminaCost() {
        return 10.0f;
    }

    @Override
    public int getStaminaRecoveryWarmup() {
        return 40;
    }

    @Override
    public float getStaminaRecoveryMax() {
        return 1.0f;
    }

    public float func_70013_c() {
        if (this.justAttacked()) {
            return 1.0f;
        }
        return super.func_70013_c();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        if (this.justAttacked()) {
            return 0xF000F0;
        }
        return super.func_70070_b();
    }
}

