/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.junglemobs.entity;

import com.lycanitesmobs.api.IGroupAlpha;
import com.lycanitesmobs.api.IGroupHunter;
import com.lycanitesmobs.api.IGroupPredator;
import com.lycanitesmobs.core.entity.EntityCreatureTameable;
import com.lycanitesmobs.core.entity.ai.EntityAIAttackMelee;
import com.lycanitesmobs.core.entity.ai.EntityAIAttackRanged;
import com.lycanitesmobs.core.entity.ai.EntityAIAvoid;
import com.lycanitesmobs.core.entity.ai.EntityAIFollowOwner;
import com.lycanitesmobs.core.entity.ai.EntityAILookIdle;
import com.lycanitesmobs.core.entity.ai.EntityAISwimming;
import com.lycanitesmobs.core.entity.ai.EntityAITargetAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetAvoid;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerThreats;
import com.lycanitesmobs.core.entity.ai.EntityAIWander;
import com.lycanitesmobs.core.entity.ai.EntityAIWatchClosest;
import com.lycanitesmobs.junglemobs.entity.EntityPoop;
import com.lycanitesmobs.junglemobs.entity.EntityVespid;
import com.lycanitesmobs.junglemobs.entity.EntityVespidQueen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class EntityConba
extends EntityCreatureTameable
implements IMob {
    EntityAIAttackRanged aiAttackRanged;
    EntityAIAttackMelee aiAttackMelee;
    EntityAIAvoid aiAvoid;
    public boolean vespidInfection = false;
    public int vespidInfectionTime = 0;

    public EntityConba(World par1World) {
        super(par1World);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.hasAttackSound = true;
        this.setupMob();
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming(this));
        this.aiAttackMelee = new EntityAIAttackMelee(this).setLongMemory(true).setEnabled(false);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.aiAttackMelee);
        this.aiAttackRanged = new EntityAIAttackRanged(this).setSpeed(1.0).setRange(16.0f).setMinChaseDistance(10.0f).setChaseTime(-1);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.aiAttackRanged);
        this.aiAvoid = new EntityAIAvoid(this).setNearSpeed(1.5).setFarSpeed(1.3).setNearDistance(5.0).setFarDistance(9.0);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiAvoid);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiSit);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFollowOwner(this).setStrayDistance(8.0).setLostDistance(32.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander(this));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest(this).setTargetClass(EntityPlayer.class));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAILookIdle(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAITargetOwnerRevenge(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAITargetOwnerAttack(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityPlayer.class));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityVillager.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAvoid(this).setTargetClass(EntityPlayer.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAvoid(this).setTargetClass(IGroupHunter.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAvoid(this).setTargetClass(IGroupPredator.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAvoid(this).setTargetClass(IGroupAlpha.class));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAITargetAvoid(this).setTargetClass(EntityVillager.class));
        this.field_70715_bh.func_75776_a(6, (EntityAIBase)new EntityAITargetOwnerThreats(this));
    }

    @Override
    public String getSpeciesName() {
        String entityName;
        String infection = "";
        if (this.vespidInfection && (entityName = EntityList.func_75621_b((Entity)this)) != null) {
            infection = I18n.func_74838_a((String)("entity." + this.creatureInfo.group.filename + "." + entityName + ".infected")) + " ";
        }
        return infection + super.getSpeciesName();
    }

    @Override
    public String getTextureName() {
        if (this.vespidInfection) {
            return super.getTextureName() + "_infected";
        }
        return super.getTextureName();
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70122_E && !this.func_130014_f_().field_72995_K) {
            if (this.hasAvoidTarget()) {
                if (this.field_70146_Z.nextInt(10) == 0) {
                    this.leap(1.0f, 0.6, (Entity)this.func_70638_az());
                }
            } else if (this.field_70146_Z.nextInt(50) == 0 && this.isMoving()) {
                this.leap(1.0, 0.6);
            }
        }
        if (!this.func_130014_f_().field_72995_K) {
            if (!this.vespidInfection && "theswarm".equals(this.spawnEventType)) {
                this.vespidInfection = true;
            }
            if (this.vespidInfection && !this.func_130014_f_().field_72995_K) {
                this.aiAttackMelee.setEnabled(true);
                this.aiAttackRanged.setEnabled(false);
                if (this.vespidInfectionTime++ >= 1200) {
                    this.spawnVespidSwarm();
                    this.func_70106_y();
                }
            } else {
                this.aiAttackMelee.setEnabled(false);
                this.aiAttackRanged.setEnabled(true);
            }
        }
        if (this.func_130014_f_().field_72995_K) {
            this.vespidInfection = this.extraAnimation01();
            if (this.vespidInfection) {
                for (int i = 0; i < 2; ++i) {
                    this.func_130014_f_().func_175688_a(EnumParticleTypes.SPELL_WITCH, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
    }

    @Override
    public void func_70619_bc() {
        if (!this.func_130014_f_().field_72995_K && this.func_70638_az() != null && this.func_70638_az() != this.getAvoidTarget()) {
            this.setAvoidTarget(this.func_70638_az());
        }
        super.func_70619_bc();
    }

    @Override
    public boolean func_70686_a(Class targetClass) {
        if (this.vespidInfection && (targetClass.isAssignableFrom(EntityVespid.class) || targetClass.isAssignableFrom(EntityVespidQueen.class))) {
            return false;
        }
        return super.func_70686_a(targetClass);
    }

    @Override
    public void attackRanged(Entity target, float range) {
        this.fireProjectile(EntityPoop.class, target, range, 0.0f, new Vec3d(0.0, 0.0, 0.0), 1.2f, 2.0f, 1.0f);
        super.attackRanged(target, range);
    }

    @Override
    public boolean canAttackEntity(EntityLivingBase targetEntity) {
        if (targetEntity instanceof EntityVespid || targetEntity instanceof EntityVespidQueen) {
            return false;
        }
        return super.canAttackEntity(targetEntity);
    }

    @Override
    public void func_70645_a(DamageSource damageSource) {
        if (!this.func_130014_f_().field_72995_K && this.vespidInfection) {
            this.spawnVespidSwarm();
        }
        super.func_70645_a(damageSource);
    }

    public void spawnVespidSwarm() {
        int j = 2 + this.field_70146_Z.nextInt(5) + this.func_130014_f_().func_175659_aa().func_151525_a() - 1;
        for (int k = 0; k < j; ++k) {
            float f = ((float)(k % 2) - 0.5f) * this.field_70130_N / 4.0f;
            float f1 = ((float)(k / 2) - 0.5f) * this.field_70130_N / 4.0f;
            EntityVespid vespid = new EntityVespid(this.func_130014_f_());
            vespid.func_70012_b(this.field_70165_t + (double)f, this.field_70163_u + 0.5, this.field_70161_v + (double)f1, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
            vespid.setSubspecies(this.getSubspeciesIndex(), true);
            vespid.setGrowingAge(vespid.growthTime);
            vespid.spawnEventType = this.spawnEventType;
            this.func_130014_f_().func_72838_d((Entity)vespid);
            if (this.func_70638_az() == null) continue;
            vespid.func_70604_c(this.func_70638_az());
        }
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public boolean extraAnimation01() {
        if (!this.func_130014_f_().field_72995_K) {
            return this.vespidInfection;
        }
        return this.extraAnimation01;
    }

    @Override
    public float getFallResistance() {
        return 100.0f;
    }

    @Override
    public void func_70037_a(NBTTagCompound nbtTagCompound) {
        super.func_70037_a(nbtTagCompound);
        if (nbtTagCompound.func_74764_b("VespidInfection")) {
            this.vespidInfection = nbtTagCompound.func_74767_n("VespidInfection");
        }
        if (nbtTagCompound.func_74764_b("VespidInfectionTime")) {
            this.vespidInfectionTime = nbtTagCompound.func_74762_e("VespidInfectionTime");
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound nbtTagCompound) {
        super.func_70014_b(nbtTagCompound);
        nbtTagCompound.func_74757_a("VespidInfection", this.vespidInfection);
        if (this.vespidInfection) {
            nbtTagCompound.func_74768_a("VespidInfectionTime", this.vespidInfectionTime);
        }
    }
}

