/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.freshwatermobs.entity;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.api.IGroupAnimal;
import com.lycanitesmobs.api.IGroupBoss;
import com.lycanitesmobs.api.IGroupHeavy;
import com.lycanitesmobs.api.IGroupPredator;
import com.lycanitesmobs.api.IGroupPrey;
import com.lycanitesmobs.core.config.ConfigBase;
import com.lycanitesmobs.core.entity.EntityCreatureAgeable;
import com.lycanitesmobs.core.entity.EntityCreatureRideable;
import com.lycanitesmobs.core.entity.ai.EntityAIAttackMelee;
import com.lycanitesmobs.core.entity.ai.EntityAIBeg;
import com.lycanitesmobs.core.entity.ai.EntityAILookIdle;
import com.lycanitesmobs.core.entity.ai.EntityAIPlayerControl;
import com.lycanitesmobs.core.entity.ai.EntityAIStayByWater;
import com.lycanitesmobs.core.entity.ai.EntityAITargetAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerThreats;
import com.lycanitesmobs.core.entity.ai.EntityAITargetRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAITargetRiderAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetRiderRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAITempt;
import com.lycanitesmobs.core.entity.ai.EntityAIWander;
import com.lycanitesmobs.core.entity.ai.EntityAIWatchClosest;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.ObjectLists;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityThresher
extends EntityCreatureRideable
implements IMob,
IGroupPredator,
IGroupHeavy {
    EntityAIWander wanderAI;
    protected int whirlpoolRange = 8;
    protected int whirlpoolEnergy = 0;
    protected int whirlpoolEnergyMax = 100;
    protected boolean whirlpoolRecharging = true;
    protected int mountedWhirlpool = 0;

    public EntityThresher(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.spawnsOnLand = false;
        this.spawnsInWater = true;
        this.hasAttackSound = true;
        this.babySpawnChance = 0.0;
        this.canGrow = true;
        this.setupMob();
        this.hitAreaWidthScale = 2.0f;
        this.hitAreaHeightScale = 1.0f;
        this.field_70144_Y = 0.9f;
        this.whirlpoolRange = ConfigBase.getConfig(this.creatureInfo.group, "general").getInt("Features", "Thresher Whirlpool Range", this.whirlpoolRange, "The range (in blocks) of the Thresher's whirlpool pull effect, set to 0 to disable, note that the Roa is nearly 10 blocks in size itself which the range must cover.");
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIStayByWater(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIPlayerControl(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt(this).setItem(new ItemStack(ObjectManager.getItem("threshertreat"))).setTemptDistanceMin(4.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackMelee(this).setLongMemory(false).setRange(2.0));
        this.wanderAI = new EntityAIWander(this);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)this.wanderAI.setPauseRate(60));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIBeg(this));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest(this).setTargetClass(EntityPlayer.class));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAILookIdle(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAITargetRiderRevenge(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAITargetRiderAttack(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetRevenge(this).setHelpCall(true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityPlayer.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityVillager.class));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(IGroupPrey.class));
        if (CreatureManager.getInstance().config.predatorsAttackAnimals) {
            this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(IGroupAnimal.class));
            this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityAnimal.class));
            this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntitySquid.class));
        }
        this.field_70715_bh.func_75776_a(6, (EntityAIBase)new EntityAITargetOwnerThreats(this));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_130014_f_().field_72995_K) {
            if (this.whirlpoolRecharging && ++this.whirlpoolEnergy >= this.whirlpoolEnergyMax) {
                this.whirlpoolRecharging = false;
            }
            this.whirlpoolEnergy = Math.min(this.whirlpoolEnergy, this.whirlpoolEnergyMax);
            if (this.canWhirlpool()) {
                for (Entity entity : this.getNearbyEntities(Entity.class, null, this.whirlpoolRange)) {
                    EntityLivingBase entityLivingBase;
                    if (entity == this || entity == this.func_184179_bs() || entity instanceof IGroupBoss || entity instanceof IGroupHeavy || entity instanceof EntityLivingBase && ((entityLivingBase = (EntityLivingBase)entity).func_70644_a((Potion)ObjectManager.getPotionEffect("weight")) || !this.canAttackEntity(entityLivingBase))) continue;
                    EntityPlayerMP player = null;
                    if (entity instanceof EntityPlayerMP) {
                        player = (EntityPlayerMP)entity;
                        if (player.field_71075_bZ.field_75098_d) continue;
                    }
                    double xDist = this.field_70165_t - entity.field_70165_t;
                    double zDist = this.field_70161_v - entity.field_70161_v;
                    double xzDist = MathHelper.func_76133_a((double)(xDist * xDist + zDist * zDist));
                    double factor = 0.1;
                    entity.func_70024_g(xDist / xzDist * factor + entity.field_70159_w * factor, factor, zDist / xzDist * factor + entity.field_70179_y * factor);
                    if (player == null) continue;
                    player.field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity(entity));
                }
                if (--this.whirlpoolEnergy <= 0) {
                    this.whirlpoolRecharging = true;
                }
            }
        }
        if (this.mountedWhirlpool > 0) {
            --this.mountedWhirlpool;
        }
    }

    @Override
    public void riderEffects(EntityLivingBase rider) {
        rider.func_70690_d(new PotionEffect(MobEffects.field_76427_o, 105, 1));
        if (rider.func_70644_a((Potion)ObjectManager.getPotionEffect("paralysis"))) {
            rider.func_184589_d((Potion)ObjectManager.getPotionEffect("paralysis"));
        }
        if (rider.func_70644_a((Potion)ObjectManager.getPotionEffect("penetration"))) {
            rider.func_184589_d((Potion)ObjectManager.getPotionEffect("penetration"));
        }
    }

    @Override
    public boolean extraAnimation01() {
        if (this.func_130014_f_().field_72995_K) {
            return super.extraAnimation01();
        }
        return this.canWhirlpool();
    }

    public boolean canWhirlpool() {
        if (this.func_130014_f_().field_72995_K) {
            return this.extraAnimation01();
        }
        if (!this.func_70090_H()) {
            return false;
        }
        if (this.func_184179_bs() != null && this.mountedWhirlpool > 0) {
            return true;
        }
        return !this.whirlpoolRecharging && this.hasAttackTarget() && this.func_70032_d((Entity)this.func_70638_az()) <= (float)(this.whirlpoolRange * 3);
    }

    @Override
    public float getBlockPathWeight(int x, int y, int z) {
        int waterWeight = 10;
        Block block = this.func_130014_f_().func_180495_p(new BlockPos(x, y, z)).func_177230_c();
        if (block == Blocks.field_150355_j) {
            return (super.getBlockPathWeight(x, y, z) + 1.0f) * (float)(waterWeight + 1);
        }
        if (block == Blocks.field_150358_i) {
            return (super.getBlockPathWeight(x, y, z) + 1.0f) * (float)waterWeight;
        }
        if (this.func_130014_f_().func_72896_J() && this.func_130014_f_().func_175710_j(new BlockPos(x, y, z))) {
            return (super.getBlockPathWeight(x, y, z) + 1.0f) * (float)(waterWeight + 1);
        }
        if (this.func_70638_az() != null) {
            return super.getBlockPathWeight(x, y, z);
        }
        if (this.waterContact()) {
            return -999999.0f;
        }
        return super.getBlockPathWeight(x, y, z);
    }

    @Override
    public boolean isStrongSwimmer() {
        return true;
    }

    @Override
    public boolean canWalk() {
        return false;
    }

    @Override
    public double func_70042_X() {
        return (double)this.field_70131_O * 0.5;
    }

    @Override
    public boolean func_70648_aU() {
        return true;
    }

    @Override
    public boolean canBreatheAboveWater() {
        return false;
    }

    @Override
    public void mountAbility(Entity rider) {
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        if (this.getStamina() < this.getStaminaCost()) {
            return;
        }
        this.applyStaminaCost();
        this.mountedWhirlpool = 20;
    }

    @Override
    public float getStaminaCost() {
        return 1.0f;
    }

    @Override
    public int getStaminaRecoveryWarmup() {
        return 0;
    }

    @Override
    public float getStaminaRecoveryMax() {
        return 2.0f;
    }

    @Override
    public boolean shouldDismountInWater(Entity rider) {
        return false;
    }

    @Override
    public void onDismounted(Entity entity) {
        super.onDismounted(entity);
        if (entity != null && entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76427_o, 100, 1));
        }
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return 10;
    }

    @Override
    public EntityCreatureAgeable createChild(EntityCreatureAgeable baby) {
        return new EntityThresher(this.func_130014_f_());
    }

    @Override
    public boolean isTamingItem(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        return itemStack.func_77973_b() == ObjectManager.getItem("threshertreat");
    }

    @Override
    public boolean isHealingItem(ItemStack testStack) {
        return ObjectLists.inItemList("cookedmeat", testStack) || ObjectLists.inItemList("cookedfish", testStack);
    }

    @Override
    public boolean petControlsEnabled() {
        return false;
    }
}

