/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.freshwatermobs.entity;

import com.lycanitesmobs.ExtendedEntity;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.api.IGroupHeavy;
import com.lycanitesmobs.core.entity.EntityCreatureTameable;
import com.lycanitesmobs.core.entity.ai.EntityAIAttackMelee;
import com.lycanitesmobs.core.entity.ai.EntityAIFollowOwner;
import com.lycanitesmobs.core.entity.ai.EntityAILookIdle;
import com.lycanitesmobs.core.entity.ai.EntityAIStayByWater;
import com.lycanitesmobs.core.entity.ai.EntityAISwimming;
import com.lycanitesmobs.core.entity.ai.EntityAITargetAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerThreats;
import com.lycanitesmobs.core.entity.ai.EntityAITargetRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAITargetRiderAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetRiderRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAITempt;
import com.lycanitesmobs.core.entity.ai.EntityAIWander;
import com.lycanitesmobs.core.entity.ai.EntityAIWatchClosest;
import com.lycanitesmobs.core.info.ObjectLists;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityStrider
extends EntityCreatureTameable
implements IGroupHeavy {
    protected EntityAIWander wanderAI;
    protected EntityAIAttackMelee attackAI;
    protected int pickupCooldown = 100;
    private int pickupTime = 0;

    public EntityStrider(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.spawnsOnLand = true;
        this.spawnsInWater = true;
        this.hasAttackSound = true;
        this.babySpawnChance = 0.0;
        this.canGrow = true;
        this.setupMob();
        this.hitAreaWidthScale = 1.5f;
        this.hitAreaHeightScale = 1.0f;
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.field_70138_W = 4.0f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming(this).setSink(true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.aiSit);
        this.attackAI = new EntityAIAttackMelee(this).setLongMemory(false);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.attackAI);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowOwner(this).setStrayDistance(8.0).setLostDistance(32.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAITempt(this).setItem(new ItemStack(ObjectManager.getItem("stridertreat"))).setTemptDistanceMin(4.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIStayByWater(this).setSpeed(1.25));
        this.wanderAI = new EntityAIWander(this);
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)this.wanderAI);
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest(this).setTargetClass(EntityPlayer.class));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAILookIdle(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAITargetOwnerRevenge(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAITargetOwnerAttack(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAITargetRiderRevenge(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAITargetRiderAttack(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetRevenge(this).setHelpCall(true));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityPlayer.class).setCheckSight(false));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityVillager.class).setCheckSight(false));
        this.field_70715_bh.func_75776_a(6, (EntityAIBase)new EntityAITargetOwnerThreats(this));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_130014_f_().field_72995_K) {
            if (this.func_70090_H()) {
                this.wanderAI.setPauseRate(120);
            } else {
                this.wanderAI.setPauseRate(0);
            }
            if (this.isTamed() && this.hasPickupEntity() && this.getPickupEntity() == this.func_70902_q()) {
                this.dropPickupEntity();
            }
            this.attackAI.setEnabled(!this.hasPickupEntity());
            if (this.hasPickupEntity()) {
                ExtendedEntity extendedEntity = ExtendedEntity.getForEntity(this.getPickupEntity());
                if (extendedEntity != null) {
                    extendedEntity.setPickedUpByEntity((Entity)this);
                }
                if (this.pickupTime++ % 40 == 0) {
                    this.attackEntityAsMob((Entity)this.getPickupEntity(), 0.5);
                    if (this.getPickupEntity() instanceof EntityLivingBase && ObjectManager.getPotionEffect("penetration") != null) {
                        this.getPickupEntity().func_70690_d(new PotionEffect((Potion)ObjectManager.getPotionEffect("penetration"), this.getEffectDuration(5), 1));
                    }
                }
            } else {
                if (this.pickupCooldown > 0) {
                    --this.pickupCooldown;
                }
                this.pickupTime = 0;
            }
        }
    }

    @Override
    public float getAISpeedModifier() {
        if (this.func_70090_H()) {
            return 2.0f;
        }
        if (this.waterContact()) {
            return 1.5f;
        }
        return super.getAISpeedModifier();
    }

    @Override
    public boolean func_96092_aw() {
        return false;
    }

    @Override
    public float getBlockPathWeight(int x, int y, int z) {
        int waterWeight = 10;
        Block block = this.func_130014_f_().func_180495_p(new BlockPos(x, y, z)).func_177230_c();
        if (block == Blocks.field_150355_j) {
            return (super.getBlockPathWeight(x, y, z) + 1.0f) * (float)(waterWeight + 1);
        }
        if (block == Blocks.field_150358_i) {
            return (super.getBlockPathWeight(x, y, z) + 1.0f) * (float)waterWeight;
        }
        if (this.func_130014_f_().func_72896_J() && this.func_130014_f_().func_175710_j(new BlockPos(x, y, z))) {
            return (super.getBlockPathWeight(x, y, z) + 1.0f) * (float)(waterWeight + 1);
        }
        if (this.func_70638_az() != null) {
            return super.getBlockPathWeight(x, y, z);
        }
        if (this.waterContact()) {
            return -999999.0f;
        }
        return super.getBlockPathWeight(x, y, z);
    }

    @Override
    public BlockPos getWanderPosition(BlockPos wanderPosition) {
        BlockPos groundPos = wanderPosition.func_177977_b();
        while (groundPos.func_177956_o() > 0 && !this.func_130014_f_().func_180495_p(groundPos).func_185904_a().func_76220_a()) {
            groundPos = groundPos.func_177977_b();
        }
        return groundPos.func_177984_a();
    }

    @Override
    public boolean attackMelee(Entity target, double damageScale) {
        EntityLivingBase entityLivingBase;
        if (!super.attackMelee(target, damageScale)) {
            return false;
        }
        if (target instanceof EntityLivingBase && this.canPickupEntity(entityLivingBase = (EntityLivingBase)target) && this.func_70685_l(target)) {
            this.pickupEntity(entityLivingBase);
            this.pickupCooldown = 100;
        }
        return true;
    }

    @Override
    public void onDamage(DamageSource damageSrc, float damage) {
        if (this.hasPickupEntity() && this.func_70681_au().nextFloat() <= 0.25f) {
            this.dropPickupEntity();
        }
        super.onDamage(damageSrc, damage);
    }

    @Override
    public boolean func_70648_aU() {
        return true;
    }

    @Override
    public float getFallResistance() {
        return 20.0f;
    }

    @Override
    public double[] getPickupOffset(Entity entity) {
        return new double[]{0.0, 5.5, 0.0};
    }

    @Override
    public boolean canPickupEntity(EntityLivingBase entity) {
        if (this.pickupCooldown > 0) {
            return false;
        }
        return super.canPickupEntity(entity);
    }

    @Override
    public void dropPickupEntity() {
        ExtendedEntity extendedEntity = ExtendedEntity.getForEntity(this.getPickupEntity());
        if (extendedEntity != null) {
            extendedEntity.setPickedUpByEntity(null);
        }
        this.pickupEntity = null;
    }

    @Override
    public int getBagSize() {
        return 15;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public boolean isTamingItem(ItemStack itemstack) {
        return itemstack.func_77973_b() == ObjectManager.getItem("stridertreat");
    }

    @Override
    public boolean isHealingItem(ItemStack testStack) {
        return ObjectLists.inItemList("cookedmeat", testStack);
    }
}

