/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.freshwatermobs.entity;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.api.IGroupAnimal;
import com.lycanitesmobs.api.IGroupPredator;
import com.lycanitesmobs.api.IGroupPrey;
import com.lycanitesmobs.core.entity.EntityCreatureAgeable;
import com.lycanitesmobs.core.entity.EntityCreatureRideable;
import com.lycanitesmobs.core.entity.ai.EntityAIAttackMelee;
import com.lycanitesmobs.core.entity.ai.EntityAIAttackRanged;
import com.lycanitesmobs.core.entity.ai.EntityAIBeg;
import com.lycanitesmobs.core.entity.ai.EntityAILookIdle;
import com.lycanitesmobs.core.entity.ai.EntityAIPlayerControl;
import com.lycanitesmobs.core.entity.ai.EntityAIStayByWater;
import com.lycanitesmobs.core.entity.ai.EntityAITargetAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerThreats;
import com.lycanitesmobs.core.entity.ai.EntityAITargetRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAITargetRiderAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetRiderRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAITempt;
import com.lycanitesmobs.core.entity.ai.EntityAIWander;
import com.lycanitesmobs.core.entity.ai.EntityAIWatchClosest;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.ObjectLists;
import com.lycanitesmobs.freshwatermobs.entity.EntityWaterJet;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityIoray
extends EntityCreatureRideable
implements IMob,
IGroupPredator {
    EntityAIWander wanderAI;
    EntityAIAttackRanged rangedAttackAI;
    EntityWaterJet projectile = null;
    EntityWaterJet abilityProjectile = null;

    public EntityIoray(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.spawnsOnLand = false;
        this.spawnsInWater = true;
        this.hasAttackSound = true;
        this.babySpawnChance = 0.0;
        this.canGrow = true;
        this.setupMob();
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIStayByWater(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIPlayerControl(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt(this).setItem(new ItemStack(ObjectManager.getItem("ioraytreat"))).setTemptDistanceMin(4.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIAttackMelee(this).setLongMemory(false).setMaxChaseDistance(4.0f));
        this.rangedAttackAI = new EntityAIAttackRanged(this).setSpeed(0.75).setStaminaTime(100).setRange(8.0f).setMinChaseDistance(4.0f).setMountedAttacking(false);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)this.rangedAttackAI);
        this.wanderAI = new EntityAIWander(this);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)this.wanderAI.setPauseRate(60));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIBeg(this));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest(this).setTargetClass(EntityPlayer.class));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAILookIdle(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAITargetRiderRevenge(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAITargetRiderAttack(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetRevenge(this).setHelpCall(true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityPlayer.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityVillager.class));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(IGroupPrey.class));
        if (CreatureManager.getInstance().config.predatorsAttackAnimals) {
            this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(IGroupAnimal.class));
            this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityAnimal.class));
            this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntitySquid.class));
        }
        this.field_70715_bh.func_75776_a(6, (EntityAIBase)new EntityAITargetOwnerThreats(this));
    }

    @Override
    public void riderEffects(EntityLivingBase rider) {
        rider.func_70690_d(new PotionEffect(MobEffects.field_76427_o, 105, 1));
        if (rider.func_70644_a((Potion)ObjectManager.getPotionEffect("paralysis"))) {
            rider.func_184589_d((Potion)ObjectManager.getPotionEffect("paralysis"));
        }
        if (rider.func_70644_a((Potion)ObjectManager.getPotionEffect("penetration"))) {
            rider.func_184589_d((Potion)ObjectManager.getPotionEffect("penetration"));
        }
    }

    @Override
    public float getBlockPathWeight(int x, int y, int z) {
        int waterWeight = 10;
        Block block = this.func_130014_f_().func_180495_p(new BlockPos(x, y, z)).func_177230_c();
        if (block == Blocks.field_150355_j) {
            return (super.getBlockPathWeight(x, y, z) + 1.0f) * (float)(waterWeight + 1);
        }
        if (block == Blocks.field_150358_i) {
            return (super.getBlockPathWeight(x, y, z) + 1.0f) * (float)waterWeight;
        }
        if (this.func_130014_f_().func_72896_J() && this.func_130014_f_().func_175710_j(new BlockPos(x, y, z))) {
            return (super.getBlockPathWeight(x, y, z) + 1.0f) * (float)(waterWeight + 1);
        }
        if (this.func_70638_az() != null) {
            return super.getBlockPathWeight(x, y, z);
        }
        if (this.waterContact()) {
            return -999999.0f;
        }
        return super.getBlockPathWeight(x, y, z);
    }

    @Override
    public boolean isStrongSwimmer() {
        return true;
    }

    @Override
    public boolean canWalk() {
        return false;
    }

    @Override
    public double func_70042_X() {
        return (double)this.field_70131_O * 0.6;
    }

    @Override
    public boolean func_70648_aU() {
        return true;
    }

    @Override
    public boolean canBreatheAboveWater() {
        return false;
    }

    @Override
    public boolean canBurn() {
        return false;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.5f;
    }

    @Override
    public void attackRanged(Entity target, float range) {
        if (this.projectile != null && this.projectile.func_70089_S()) {
            this.projectile.setTime(20);
        } else {
            this.projectile = null;
        }
        if (this.projectile == null) {
            this.projectile = new EntityWaterJet(this.func_130014_f_(), (EntityLivingBase)this, 20, 10);
            this.projectile.setOffset(0.0, 0.0, 1.0);
            this.func_184185_a(this.projectile.getLaunchSound(), 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            this.func_130014_f_().func_72838_d((Entity)this.projectile);
        }
        super.attackRanged(target, range);
    }

    @Override
    public void mountAbility(Entity rider) {
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        if (this.getStamina() < this.getStaminaRecoveryMax() * 2.0f) {
            return;
        }
        if (this.hasAttackTarget()) {
            this.func_70624_b(null);
        }
        if (this.abilityProjectile != null && this.abilityProjectile.func_70089_S()) {
            this.abilityProjectile.setTime(20);
        } else {
            this.abilityProjectile = null;
        }
        if (this.abilityProjectile == null) {
            if (this.func_184179_bs() == null || !(this.func_184179_bs() instanceof EntityLivingBase)) {
                return;
            }
            this.abilityProjectile = new EntityWaterJet(this.func_130014_f_(), (EntityLivingBase)this.func_184179_bs(), 25, 20, (Entity)this);
            this.abilityProjectile.setOffset(0.0, 1.0, 1.0);
            this.func_184185_a(this.abilityProjectile.getLaunchSound(), 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            this.func_130014_f_().func_72838_d((Entity)this.abilityProjectile);
        }
        this.applyStaminaCost();
    }

    @Override
    public boolean shouldDismountInWater(Entity rider) {
        return false;
    }

    @Override
    public void onDismounted(Entity entity) {
        super.onDismounted(entity);
        if (entity != null && entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76427_o, 100, 1));
        }
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return 10;
    }

    @Override
    public EntityCreatureAgeable createChild(EntityCreatureAgeable baby) {
        return new EntityIoray(this.func_130014_f_());
    }

    @Override
    public boolean isTamingItem(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        return itemStack.func_77973_b() == ObjectManager.getItem("ioraytreat");
    }

    @Override
    public boolean isHealingItem(ItemStack testStack) {
        return ObjectLists.inItemList("cookedmeat", testStack) || ObjectLists.inItemList("cookedfish", testStack);
    }

    @Override
    public boolean petControlsEnabled() {
        return false;
    }
}

