/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.elementalmobs.renderer;

import com.lycanitesmobs.AssetManager;
import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.renderer.LayerBase;
import com.lycanitesmobs.core.renderer.RenderCreature;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector4f;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class LayerDjinn
extends LayerBase {
    public LayerDjinn(RenderCreature renderer) {
        super(renderer);
    }

    @Override
    public boolean canRenderPart(String partName, EntityCreatureBase entity, boolean trophy) {
        return partName.contains("ribbon");
    }

    @Override
    public ResourceLocation getLayerTexture(EntityCreatureBase entity) {
        String textureName = entity.getTextureName();
        if (entity.getSubspecies() != null) {
            textureName = textureName + "_" + entity.getSubspecies().name;
        }
        if (AssetManager.getTexture(textureName = textureName + "_ribbon") == null) {
            AssetManager.addTexture(textureName, entity.creatureInfo.group, "textures/entity/" + textureName.toLowerCase() + ".png");
        }
        return AssetManager.getTexture(textureName);
    }

    @Override
    public Vector2f getTextureOffset(String partName, EntityCreatureBase entity, boolean trophy, float loop) {
        return new Vector2f(-loop * 25.0f, 0.0f);
    }

    @Override
    public Vector4f getPartColor(String partName, EntityCreatureBase entity, boolean trophy) {
        return new Vector4f(1.0f, 1.0f, 1.0f, 0.75f);
    }

    @Override
    public void onRenderStart(String partName, Entity entity, boolean trophy) {
        GL11.glEnable((int)3042);
    }

    @Override
    public void onRenderFinish(String partName, Entity entity, boolean trophy) {
        GL11.glDisable((int)3042);
    }
}

