/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.elementalmobs.model;

import com.lycanitesmobs.core.model.template.ModelTemplateElemental;
import com.lycanitesmobs.core.renderer.LayerBase;
import com.lycanitesmobs.core.renderer.LayerGlow;
import com.lycanitesmobs.core.renderer.RenderCreature;
import com.lycanitesmobs.elementalmobs.ElementalMobs;
import com.lycanitesmobs.elementalmobs.entity.EntitySpectre;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ModelSpectre
extends ModelTemplateElemental {
    public ModelSpectre() {
        this(1.0f);
    }

    public ModelSpectre(float shadowSize) {
        this.initModel("spectre", ElementalMobs.instance.group, "entity/spectre");
        this.trophyScale = 1.2f;
        this.trophyOffset = new float[]{0.0f, 0.0f, -0.4f};
        this.trophyMouthOffset = new float[]{0.0f, -0.25f, 0.0f};
    }

    @Override
    public void addCustomLayers(RenderCreature renderer) {
        super.addCustomLayers(renderer);
        renderer.func_177094_a(new LayerGlow(renderer));
    }

    @Override
    public boolean canBaseRenderPart(String partName, Entity entity, boolean trophy) {
        if ("effect02".equals(partName) || "effect03".equals(partName)) {
            if (entity instanceof EntitySpectre) {
                return ((EntitySpectre)entity).canPull();
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean canRenderPart(String partName, Entity entity, LayerBase layer, boolean trophy) {
        if ("effect02".equals(partName) || "effect03".equals(partName)) {
            if (entity instanceof EntitySpectre) {
                return ((EntitySpectre)entity).canPull();
            }
            return false;
        }
        return super.canRenderPart(partName, entity, layer, trophy);
    }

    @Override
    public void animatePart(String partName, EntityLiving entity, float time, float distance, float loop, float lookY, float lookX, float scale) {
        super.animatePart(partName, entity, time, distance, loop, lookY, lookX, scale);
        boolean isPulling = false;
        if (entity instanceof EntitySpectre) {
            isPulling = ((EntitySpectre)entity).canPull();
        }
        if ("effect01".equals(partName)) {
            this.rotate(25.0f, 0.0f, -loop * 10.0f);
            float effectScale = 1.0f + (float)Math.cos(loop / 10.0f) * 0.1f;
            if (isPulling) {
                effectScale *= 2.0f;
            }
            this.scale(effectScale, effectScale, effectScale);
        } else if ("effect02".equals(partName)) {
            this.rotate(0.0f, 0.0f, -loop * 10.0f);
            float effectScale = 2.0f + (float)Math.cos(loop / 10.0f);
            this.scale(effectScale, effectScale, effectScale);
        } else if ("effect03".equals(partName)) {
            this.rotate(0.0f, 0.0f, loop * 10.0f);
            float effectScale = 2.0f + (float)Math.cos(loop / 10.0f);
            this.scale(effectScale, effectScale, effectScale);
        } else if (partName.contains("mouthleft")) {
            this.rotate((float)Math.cos(loop / 10.0f) * 4.0f, (float)Math.cos(loop / 10.0f) * 4.0f, 0.0f);
        } else if (partName.contains("mouthright")) {
            this.rotate((float)Math.cos(loop / 10.0f) * 4.0f, -((float)Math.cos(loop / 10.0f)) * 4.0f, 0.0f);
        } else if (partName.contains("mawleft")) {
            this.rotate(0.0f, (float)Math.cos(loop / 10.0f) * 10.0f + (float)(isPulling ? 90 : 0), 0.0f);
        } else if (partName.contains("mawright")) {
            this.rotate(0.0f, -((float)Math.cos(loop / 10.0f)) * 10.0f - (float)(isPulling ? 90 : 0), 0.0f);
        }
    }

    @Override
    public void onRenderStart(LayerBase layer, String partName, Entity entity, boolean renderAsTrophy) {
        super.onRenderStart(layer, partName, entity, renderAsTrophy);
        if (!partName.contains("effect")) {
            return;
        }
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
    }

    @Override
    public void onRenderFinish(LayerBase layer, String partName, Entity entity, boolean renderAsTrophy) {
        super.onRenderFinish(layer, partName, entity, renderAsTrophy);
        if (!partName.contains("effect")) {
            return;
        }
        GL11.glDisable((int)3042);
    }
}

