/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.elementalmobs.model;

import com.lycanitesmobs.core.model.template.ModelTemplateElemental;
import com.lycanitesmobs.core.renderer.LayerBase;
import com.lycanitesmobs.core.renderer.LayerEffect;
import com.lycanitesmobs.core.renderer.RenderCreature;
import com.lycanitesmobs.elementalmobs.ElementalMobs;
import javax.vecmath.Vector4f;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ModelReiver
extends ModelTemplateElemental {
    float maxLeg = 0.0f;

    public ModelReiver() {
        this(1.0f);
    }

    public ModelReiver(float shadowSize) {
        this.initModel("reiver", ElementalMobs.instance.group, "entity/reiver");
        this.trophyScale = 1.0f;
        this.trophyOffset = new float[]{0.0f, 0.0f, -0.2f};
    }

    @Override
    public void addCustomLayers(RenderCreature renderer) {
        super.addCustomLayers(renderer);
        renderer.func_177094_a(new LayerEffect(renderer, "pulse01", false, false, false));
        renderer.func_177094_a(new LayerEffect(renderer, "pulse02", false, false, false));
        renderer.func_177094_a(new LayerEffect(renderer, "pulse03", false, false, false));
    }

    @Override
    public void animatePart(String partName, EntityLiving entity, float time, float distance, float loop, float lookY, float lookX, float scale) {
        if (partName.contains("effect")) {
            this.rotate(25.0f, 0.0f, 0.0f);
        }
        super.animatePart(partName, entity, time, distance, loop, lookY, lookX, scale);
    }

    @Override
    public Vector4f getPartColor(String partName, Entity entity, LayerBase layer, boolean trophy, float loop) {
        if (layer == null) {
            return super.getPartColor(partName, entity, layer, trophy, loop);
        }
        float alphaSpeed = 10.0f;
        if ("pulse02".equals(layer.name)) {
            alphaSpeed = 9.5f;
            loop += 100.0f;
        }
        if ("pulse03".equals(layer.name)) {
            alphaSpeed = 9.0f;
            loop += 200.0f;
        }
        float alpha = loop * alphaSpeed % 360.0f;
        return new Vector4f(1.0f, 1.0f, 1.0f, (float)Math.cos(Math.toRadians(alpha)) / 2.0f + 0.5f);
    }

    @Override
    public void onRenderStart(LayerBase layer, String partName, Entity entity, boolean renderAsTrophy) {
        super.onRenderStart(layer, partName, entity, renderAsTrophy);
        if (layer == null) {
            return;
        }
        GL11.glEnable((int)3042);
    }

    @Override
    public void onRenderFinish(LayerBase layer, String partName, Entity entity, boolean renderAsTrophy) {
        super.onRenderFinish(layer, partName, entity, renderAsTrophy);
        if (layer == null) {
            return;
        }
        GL11.glDisable((int)3042);
    }
}

