/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.elementalmobs.model;

import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.model.template.ModelTemplateElemental;
import com.lycanitesmobs.core.renderer.LayerBase;
import com.lycanitesmobs.core.renderer.LayerEffect;
import com.lycanitesmobs.core.renderer.RenderCreature;
import com.lycanitesmobs.elementalmobs.ElementalMobs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ModelArgus
extends ModelTemplateElemental {
    public ModelArgus() {
        this(1.0f);
    }

    public ModelArgus(float shadowSize) {
        this.initModel("argus", ElementalMobs.instance.group, "entity/argus");
        this.trophyScale = 1.2f;
        this.trophyOffset = new float[]{0.0f, 0.0f, -0.4f};
        this.trophyMouthOffset = new float[]{0.0f, -0.25f, 0.0f};
    }

    @Override
    public void addCustomLayers(RenderCreature renderer) {
        super.addCustomLayers(renderer);
        LayerEffect layer = new LayerEffect(renderer, "flash");
        layer.glow = true;
        layer.additive = true;
        renderer.func_177094_a(layer);
    }

    @Override
    public boolean canRenderPart(String partName, Entity entity, LayerBase layer, boolean trophy) {
        if (layer instanceof LayerEffect && entity instanceof EntityCreatureBase) {
            return ((EntityCreatureBase)entity).justAttacked();
        }
        return super.canRenderPart(partName, entity, layer, trophy);
    }

    @Override
    public void animatePart(String partName, EntityLiving entity, float time, float distance, float loop, float lookY, float lookX, float scale) {
        super.animatePart(partName, entity, time, distance, loop, lookY, lookX, scale);
        if (partName.contains("arm")) {
            float rotX = (float)Math.toDegrees(MathHelper.func_76126_a((float)(loop * 0.067f)) * 0.05f) * 4.0f;
            float rotY = (float)Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.09f)) * 0.1f);
            if ("arm01".equals(partName) || "arm02".equals(partName) || "arm03".equals(partName)) {
                this.rotate(rotX, rotY, loop * 8.0f);
                this.translate(MathHelper.func_76134_b((float)loop) * 0.05f - 0.05f, MathHelper.func_76134_b((float)loop) * 0.05f - 0.05f, 0.0f);
            } else if ("arm04".equals(partName) || "arm05".equals(partName) || "arm06".equals(partName)) {
                this.rotate(rotX, rotY, -loop * 8.0f);
                this.translate(MathHelper.func_76134_b((float)(-loop)) * 0.05f - 0.05f, MathHelper.func_76134_b((float)(-loop)) * 0.05f - 0.05f, 0.0f);
            }
        }
        if (partName.contains("tail")) {
            float tailSwipeX = 32.0f;
            float tailSwipeY = 32.0f;
            this.rotate(MathHelper.func_76134_b((float)(loop * 0.1f)) * tailSwipeX - tailSwipeX * 90.0f, MathHelper.func_76126_a((float)(loop * 0.2f)) * tailSwipeY - tailSwipeY * 90.0f, 0.0f);
        }
    }

    @Override
    public void onRenderStart(LayerBase layer, String partName, Entity entity, boolean renderAsTrophy) {
        super.onRenderStart(layer, partName, entity, renderAsTrophy);
        if (!partName.contains("effect")) {
            return;
        }
        GL11.glEnable((int)3042);
    }

    @Override
    public void onRenderFinish(LayerBase layer, String partName, Entity entity, boolean renderAsTrophy) {
        super.onRenderFinish(layer, partName, entity, renderAsTrophy);
        if (!partName.contains("effect")) {
            return;
        }
        GL11.glDisable((int)3042);
    }
}

