/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.elementalmobs.entity;

import com.lycanitesmobs.api.IGroupFire;
import com.lycanitesmobs.api.IGroupIce;
import com.lycanitesmobs.api.IGroupPlant;
import com.lycanitesmobs.api.IGroupRock;
import com.lycanitesmobs.api.IGroupWater;
import com.lycanitesmobs.core.config.ConfigBase;
import com.lycanitesmobs.core.entity.EntityCreatureTameable;
import com.lycanitesmobs.core.entity.ai.EntityAIAttackMelee;
import com.lycanitesmobs.core.entity.ai.EntityAIFollowOwner;
import com.lycanitesmobs.core.entity.ai.EntityAILookIdle;
import com.lycanitesmobs.core.entity.ai.EntityAISwimming;
import com.lycanitesmobs.core.entity.ai.EntityAITargetAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerThreats;
import com.lycanitesmobs.core.entity.ai.EntityAITargetRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAIWander;
import com.lycanitesmobs.core.entity.ai.EntityAIWatchClosest;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;

public class EntityVolcan
extends EntityCreatureTameable
implements IMob,
IGroupRock,
IGroupFire {
    private EntityAIAttackMelee meleeAttackAI;
    public int volcanMeltRadius = 2;

    public EntityVolcan(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.hasAttackSound = true;
        this.volcanMeltRadius = ConfigBase.getConfig(this.creatureInfo.group, "general").getInt("Features", "Volcan Block Melting Radius", this.volcanMeltRadius, "Controls how far Volcans melt blocks, set to 0 to disable.");
        this.setupMob();
        this.field_70138_W = 1.0f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming(this));
        this.meleeAttackAI = new EntityAIAttackMelee(this).setLongMemory(true);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.meleeAttackAI);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiSit);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowOwner(this).setStrayDistance(8.0).setLostDistance(32.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWander(this));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest(this).setTargetClass(EntityPlayer.class));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAILookIdle(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAITargetOwnerRevenge(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAITargetOwnerAttack(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetRevenge(this).setHelpCall(true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(IGroupIce.class));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(IGroupWater.class));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntitySnowman.class));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntitySilverfish.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityPlayer.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityVillager.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(IGroupPlant.class));
        this.field_70715_bh.func_75776_a(6, (EntityAIBase)new EntityAITargetOwnerThreats(this));
    }

    @Override
    public void func_70105_a(float width, float height) {
        if (this.getSubspeciesIndex() == 3) {
            super.func_70105_a(width * 2.0f, height * 2.0f);
            return;
        }
        super.func_70105_a(width, height);
    }

    @Override
    public double getRenderScale() {
        if (this.getSubspeciesIndex() == 3) {
            return this.sizeScale * 2.0;
        }
        return this.sizeScale;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_130014_f_().field_72995_K && this.updateTick % 40L == 0L) {
            List<EntityLivingBase> aoeTargets = this.getNearbyEntities(EntityLivingBase.class, null, 4.0);
            for (EntityLivingBase entityObj : aoeTargets) {
                EntityLivingBase target = entityObj;
                if (target == this || target instanceof IGroupFire || !this.func_70686_a(entityObj.getClass()) || !this.canAttackEntity(target) || !this.func_70635_at().func_75522_a((Entity)target)) continue;
                target.func_70015_d(2);
            }
        }
        if (this.updateTick % 40L == 0L && this.volcanMeltRadius > 0 && !this.isTamed() && this.func_130014_f_().func_82736_K().func_82766_b("mobGriefing")) {
            int range = this.volcanMeltRadius;
            int w = -((int)Math.ceil(this.field_70130_N) + range);
            while ((double)w <= Math.ceil(this.field_70130_N) + (double)range) {
                int d = -((int)Math.ceil(this.field_70130_N) + range);
                while ((double)d <= Math.ceil(this.field_70130_N) + (double)range) {
                    int h = -((int)Math.ceil(this.field_70131_O) + range);
                    while ((double)h <= Math.ceil(this.field_70131_O)) {
                        Block block = this.func_130014_f_().func_180495_p(this.func_180425_c().func_177982_a(w, h, d)).func_177230_c();
                        if (block == Blocks.field_150343_Z || block == Blocks.field_150347_e || block == Blocks.field_150351_n) {
                            IBlockState blockState = Blocks.field_150356_k.func_176223_P().func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(5));
                            if (block == Blocks.field_150343_Z) {
                                blockState = Blocks.field_150353_l.func_176223_P();
                            }
                            this.func_130014_f_().func_175656_a(this.func_180425_c().func_177982_a(w, h, d), blockState);
                        } else if (block == Blocks.field_150355_j || block == Blocks.field_150358_i || block == Blocks.field_150432_aD || block == Blocks.field_150431_aC) {
                            this.func_130014_f_().func_180501_a(this.func_180425_c().func_177982_a(w, h, d), Blocks.field_150350_a.func_176223_P(), 0);
                        }
                        ++h;
                    }
                    ++d;
                }
                ++w;
            }
        }
        if (this.func_130014_f_().field_72995_K) {
            int i;
            for (i = 0; i < 2; ++i) {
                this.func_130014_f_().func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
                this.func_130014_f_().func_175688_a(EnumParticleTypes.DRIP_LAVA, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
            }
            if (this.field_70173_aa % 10 == 0) {
                for (i = 0; i < 2; ++i) {
                    this.func_130014_f_().func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
    }

    @Override
    public boolean attackMelee(Entity target, double damageScale) {
        if (!super.attackMelee(target, damageScale)) {
            return false;
        }
        if (target instanceof EntitySilverfish) {
            target.func_70106_y();
        }
        return true;
    }

    @Override
    public boolean isFlying() {
        return true;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public float getDamageModifier(DamageSource damageSrc) {
        if (damageSrc.func_76347_k()) {
            return 0.0f;
        }
        return super.getDamageModifier(damageSrc);
    }

    @Override
    public boolean isDamageTypeApplicable(String type, DamageSource source, float damage) {
        if (type.equals("cactus") || type.equals("inWall")) {
            return false;
        }
        return super.isDamageTypeApplicable(type, source, damage);
    }

    @Override
    public boolean canBurn() {
        return false;
    }

    @Override
    public boolean waterDamage() {
        return true;
    }
}

