/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.elementalmobs.entity;

import com.lycanitesmobs.api.IGroupRock;
import com.lycanitesmobs.core.config.ConfigBase;
import com.lycanitesmobs.core.entity.EntityCreatureTameable;
import com.lycanitesmobs.core.entity.ai.EntityAIAttackMelee;
import com.lycanitesmobs.core.entity.ai.EntityAIFollowOwner;
import com.lycanitesmobs.core.entity.ai.EntityAILookIdle;
import com.lycanitesmobs.core.entity.ai.EntityAISwimming;
import com.lycanitesmobs.core.entity.ai.EntityAITargetAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerThreats;
import com.lycanitesmobs.core.entity.ai.EntityAITargetRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAIWander;
import com.lycanitesmobs.core.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;

public class EntityTremor
extends EntityCreatureTameable
implements IMob,
IGroupRock {
    private EntityAIAttackMelee meleeAttackAI;
    public int tremorExplosionStrength = 1;

    public EntityTremor(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.hasAttackSound = true;
        this.tremorExplosionStrength = ConfigBase.getConfig(this.creatureInfo.group, "general").getInt("Features", "Tremor Explosion Strength", this.tremorExplosionStrength, "Controls the strength of a Tremor's explosion when attacking, set to -1 to disable completely.");
        this.setupMob();
        this.field_70138_W = 1.0f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming(this));
        this.meleeAttackAI = new EntityAIAttackMelee(this).setLongMemory(true);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.meleeAttackAI);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiSit);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowOwner(this).setStrayDistance(8.0).setLostDistance(32.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWander(this));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest(this).setTargetClass(EntityPlayer.class));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAILookIdle(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAITargetOwnerRevenge(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAITargetOwnerAttack(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetRevenge(this).setHelpCall(true));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityPlayer.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityVillager.class));
        this.field_70715_bh.func_75776_a(6, (EntityAIBase)new EntityAITargetOwnerThreats(this));
    }

    @Override
    public void func_70105_a(float width, float height) {
        if (this.getSubspeciesIndex() == 3) {
            super.func_70105_a(width * 2.0f, height * 2.0f);
            return;
        }
        super.func_70105_a(width, height);
    }

    @Override
    public double getRenderScale() {
        if (this.getSubspeciesIndex() == 3) {
            return this.sizeScale * 2.0;
        }
        return this.sizeScale;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_130014_f_().field_72995_K && this.getSubspeciesIndex() == 3 && !this.isPetType("familiar") && this.hasAttackTarget() && this.func_70068_e((Entity)this.func_70638_az()) > 1.0 && this.func_70681_au().nextInt(20) == 0) {
            if (this.field_70163_u - 1.0 > this.func_70638_az().field_70163_u) {
                this.leap(6.0f, -1.0, (Entity)this.func_70638_az());
            } else if (this.field_70163_u + 1.0 < this.func_70638_az().field_70163_u) {
                this.leap(6.0f, 1.0, (Entity)this.func_70638_az());
            } else {
                this.leap(6.0f, 0.0, (Entity)this.func_70638_az());
            }
        }
        if (this.func_130014_f_().field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                this.func_130014_f_().func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    @Override
    public boolean attackMelee(Entity target, double damageScale) {
        boolean damageTerrain;
        if (!super.attackMelee(target, damageScale)) {
            return false;
        }
        int explosionStrength = Math.max(1, this.tremorExplosionStrength);
        boolean bl = damageTerrain = this.tremorExplosionStrength > 0 && this.func_130014_f_().func_82736_K().func_82766_b("mobGriefing");
        if (this.isPetType("familiar")) {
            explosionStrength = 1;
            damageTerrain = false;
        }
        this.func_130014_f_().func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, (float)explosionStrength, damageTerrain);
        return true;
    }

    @Override
    public boolean isFlying() {
        return true;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public boolean isDamageTypeApplicable(String type, DamageSource source, float damage) {
        if (source.func_94541_c()) {
            this.func_70691_i(damage);
            return false;
        }
        if (type.equals("cactus") || type.equals("inWall")) {
            return false;
        }
        return super.isDamageTypeApplicable(type, source, damage);
    }

    @Override
    public boolean isDamageEntityApplicable(Entity entity) {
        if (entity instanceof EntityWither) {
            return false;
        }
        return super.isDamageEntityApplicable(entity);
    }

    @Override
    public boolean canBurn() {
        return false;
    }

    @Override
    public boolean hideFromWithers() {
        return true;
    }
}

