/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.elementalmobs.entity;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.api.IGroupBoss;
import com.lycanitesmobs.api.IGroupHeavy;
import com.lycanitesmobs.api.IGroupShadow;
import com.lycanitesmobs.core.entity.EntityCreatureTameable;
import com.lycanitesmobs.core.entity.ai.EntityAIAttackMelee;
import com.lycanitesmobs.core.entity.ai.EntityAIFollowOwner;
import com.lycanitesmobs.core.entity.ai.EntityAILookIdle;
import com.lycanitesmobs.core.entity.ai.EntityAIStealth;
import com.lycanitesmobs.core.entity.ai.EntityAISwimming;
import com.lycanitesmobs.core.entity.ai.EntityAITargetAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerThreats;
import com.lycanitesmobs.core.entity.ai.EntityAITargetRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAIWander;
import com.lycanitesmobs.core.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.potion.Potion;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntitySpectre
extends EntityCreatureTameable
implements IMob,
IGroupShadow,
IGroupHeavy {
    protected int pullRange = 6;
    protected int pullEnergy = 0;
    protected int pullEnergyMax = 40;
    protected int pullEnergyRecharge = 0;
    protected int pullEnergyRechargeMax = 80;
    protected boolean pullRecharging = true;

    public EntitySpectre(World par1World) {
        super(par1World);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.hasAttackSound = true;
        this.spawnsInWater = true;
        this.setupMob();
        this.field_70138_W = 1.0f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIStealth(this).setStealthTime(20).setStealthAttack(true).setStealthMove(true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee(this).setLongMemory(true));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiSit);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowOwner(this).setStrayDistance(8.0).setLostDistance(32.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWander(this));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest(this).setTargetClass(EntityPlayer.class));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAILookIdle(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAITargetOwnerRevenge(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAITargetOwnerAttack(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetRevenge(this).setHelpCall(true));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityPlayer.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityVillager.class));
        this.field_70715_bh.func_75776_a(6, (EntityAIBase)new EntityAITargetOwnerThreats(this));
    }

    @Override
    public void func_70105_a(float width, float height) {
        if (this.getSubspeciesIndex() == 3) {
            super.func_70105_a(width * 2.0f, height * 2.0f);
            return;
        }
        super.func_70105_a(width, height);
    }

    @Override
    public double getRenderScale() {
        if (this.getSubspeciesIndex() == 3) {
            return this.sizeScale * 2.0;
        }
        return this.sizeScale;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_130014_f_().field_72995_K) {
            if (this.pullRecharging && ++this.pullEnergyRecharge >= this.pullEnergyRechargeMax) {
                this.pullRecharging = false;
                this.pullEnergy = this.pullEnergyMax;
                this.pullEnergyRecharge = 0;
            }
            this.pullEnergy = Math.min(this.pullEnergy, this.pullEnergyMax);
            if (this.canPull()) {
                for (EntityLivingBase entity : this.getNearbyEntities(EntityLivingBase.class, null, this.pullRange)) {
                    if (entity == this || entity == this.func_184179_bs() || entity instanceof IGroupBoss || entity instanceof IGroupHeavy || entity.func_70644_a((Potion)ObjectManager.getPotionEffect("weight")) || !this.canAttackEntity(entity)) continue;
                    EntityPlayerMP player = null;
                    if (entity instanceof EntityPlayerMP) {
                        player = (EntityPlayerMP)entity;
                        if (player.field_71075_bZ.field_75098_d) continue;
                    }
                    double xDist = this.field_70165_t - entity.field_70165_t;
                    double zDist = this.field_70161_v - entity.field_70161_v;
                    double xzDist = MathHelper.func_76133_a((double)(xDist * xDist + zDist * zDist));
                    double factor = 0.1;
                    double motionCap = 10.0;
                    if (entity.field_70159_w < motionCap && entity.field_70159_w > -motionCap && entity.field_70179_y < motionCap && entity.field_70179_y > -motionCap) {
                        entity.func_70024_g(xDist / xzDist * factor + entity.field_70159_w * factor, 0.0, zDist / xzDist * factor + entity.field_70179_y * factor);
                    }
                    if (player == null) continue;
                    player.field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity((Entity)entity));
                }
                if (--this.pullEnergy <= 0) {
                    this.pullRecharging = true;
                    this.pullEnergyRecharge = 0;
                }
            }
        }
        if (this.func_130014_f_().field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                this.func_130014_f_().func_175688_a(EnumParticleTypes.SUSPENDED_DEPTH, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    @Override
    public boolean extraAnimation01() {
        if (this.func_130014_f_().field_72995_K) {
            return super.extraAnimation01();
        }
        return this.canPull();
    }

    public boolean canPull() {
        if (this.func_130014_f_().field_72995_K) {
            return this.extraAnimation01();
        }
        return !this.pullRecharging && this.hasAttackTarget() && this.func_70032_d((Entity)this.func_70638_az()) <= (float)(this.pullRange * 3);
    }

    @Override
    public boolean isFlying() {
        return true;
    }

    @Override
    public boolean isStrongSwimmer() {
        return true;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public boolean isDamageTypeApplicable(String type, DamageSource source, float damage) {
        if (type.equals("inWall")) {
            return false;
        }
        return super.isDamageTypeApplicable(type, source, damage);
    }

    @Override
    public boolean func_70648_aU() {
        return true;
    }
}

