/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.elementalmobs.entity;

import com.lycanitesmobs.api.IGroupPlant;
import com.lycanitesmobs.core.config.ConfigBase;
import com.lycanitesmobs.core.entity.EntityCreatureTameable;
import com.lycanitesmobs.core.entity.ai.EntityAIAttackRanged;
import com.lycanitesmobs.core.entity.ai.EntityAIAvoid;
import com.lycanitesmobs.core.entity.ai.EntityAIFollowOwner;
import com.lycanitesmobs.core.entity.ai.EntityAILookIdle;
import com.lycanitesmobs.core.entity.ai.EntityAISwimming;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerThreats;
import com.lycanitesmobs.core.entity.ai.EntityAITargetRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAIWander;
import com.lycanitesmobs.core.entity.ai.EntityAIWatchClosest;
import com.lycanitesmobs.elementalmobs.entity.EntityFaeBolt;
import com.lycanitesmobs.elementalmobs.entity.EntityLifeDrain;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityNymph
extends EntityCreatureTameable
implements IMob,
IGroupPlant {
    EntityAIAttackRanged rangedAttackAI;
    public int healingRate = 20;
    private int farmingTick = 0;
    EntityLifeDrain projectile = null;

    public EntityNymph(World par1World) {
        super(par1World);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.hasAttackSound = false;
        this.setWidth = 0.8f;
        this.setHeight = 1.2f;
        this.fleeHealthPercent = 1.0f;
        this.isHostileByDefault = false;
        this.setupMob();
        this.field_70138_W = 1.0f;
        this.healingRate = ConfigBase.getConfig(this.creatureInfo.group, "general").getInt("Features", "Nymph Healing Rate", this.healingRate, "Sets the rate in ticks (20 ticks = 1 second) that a Nymph heals surrounding entities.");
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiSit);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowOwner(this).setStrayDistance(8.0).setLostDistance(32.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIAvoid(this).setNearSpeed(1.3).setFarSpeed(1.2).setNearDistance(5.0).setFarDistance(20.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWander(this));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest(this).setTargetClass(EntityPlayer.class));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAILookIdle(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAITargetOwnerRevenge(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAITargetOwnerAttack(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetRevenge(this).setHelpCall(true));
        this.field_70715_bh.func_75776_a(6, (EntityAIBase)new EntityAITargetOwnerThreats(this));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_130014_f_().field_72995_K) {
            if (this.healingRate > 0 && !this.isPetType("familiar") && this.updateTick % (long)this.healingRate == 0L) {
                List<EntityLivingBase> aoeTargets = this.getNearbyEntities(EntityLivingBase.class, null, 4.0);
                for (EntityLivingBase entityObj : aoeTargets) {
                    EntityLivingBase target = entityObj;
                    if (target == this || target instanceof EntityNymph || target == this.func_70638_az() || target == this.getAvoidTarget()) continue;
                    target.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 60, 0));
                }
            }
            if (this.hasAvoidTarget() && this.updateTick % (long)this.getRangedCooldown() == 0L) {
                this.attackRanged((Entity)this.getAvoidTarget(), this.func_70032_d((Entity)this.getAvoidTarget()));
            }
        }
    }

    @Override
    public void attackRanged(Entity target, float range) {
        this.fireProjectile(EntityFaeBolt.class, target, range, 0.0f, new Vec3d(0.0, 0.0, 0.0), 0.5f, 1.0f, 1.0f);
        super.attackRanged(target, range);
    }

    @Override
    public boolean isFlying() {
        return true;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return 5;
    }
}

