/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.elementalmobs.entity;

import com.lycanitesmobs.api.IFusable;
import com.lycanitesmobs.api.IGroupRock;
import com.lycanitesmobs.core.config.ConfigBase;
import com.lycanitesmobs.core.entity.EntityCreatureTameable;
import com.lycanitesmobs.core.entity.ai.EntityAIAttackMelee;
import com.lycanitesmobs.core.entity.ai.EntityAIFollowFuse;
import com.lycanitesmobs.core.entity.ai.EntityAIFollowOwner;
import com.lycanitesmobs.core.entity.ai.EntityAILookIdle;
import com.lycanitesmobs.core.entity.ai.EntityAISwimming;
import com.lycanitesmobs.core.entity.ai.EntityAITargetAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetFuse;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerThreats;
import com.lycanitesmobs.core.entity.ai.EntityAITargetRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAIWander;
import com.lycanitesmobs.core.entity.ai.EntityAIWatchClosest;
import com.lycanitesmobs.core.info.ObjectLists;
import com.lycanitesmobs.elementalmobs.entity.EntityArgus;
import com.lycanitesmobs.elementalmobs.entity.EntityCinder;
import com.lycanitesmobs.elementalmobs.entity.EntityJengu;
import com.lycanitesmobs.elementalmobs.entity.EntitySpriggan;
import com.lycanitesmobs.elementalmobs.entity.EntityTremor;
import com.lycanitesmobs.elementalmobs.entity.EntityVolcan;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;

public class EntityGeonach
extends EntityCreatureTameable
implements IMob,
IGroupRock,
IFusable {
    public int geonachBlockBreakRadius = 0;
    public float fireDamageAbsorbed = 0.0f;
    protected IFusable fusionTarget;

    public EntityGeonach(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.hasAttackSound = true;
        this.geonachBlockBreakRadius = ConfigBase.getConfig(this.creatureInfo.group, "general").getInt("Features", "Rare Geonach Block Break Radius", this.geonachBlockBreakRadius, "Controls how large the Celestial Geonach's block breaking radius is when it is charging towards its target. Set to -1 to disable. For their block breaking radius on spawn, see the ROCK spawn type features instead. Note that this is only for the extremely rare Geonach.");
        this.setupMob();
        this.field_70138_W = 1.0f;
        this.attackPhaseMax = (byte)3;
        this.justAttackedTime = (short)10;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFollowFuse(this).setLostDistance(16.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee(this).setLongMemory(true));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiSit);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowOwner(this).setStrayDistance(8.0).setLostDistance(32.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWander(this));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest(this).setTargetClass(EntityPlayer.class));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAILookIdle(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAITargetOwnerRevenge(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAITargetOwnerAttack(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetRevenge(this).setHelpCall(true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntitySilverfish.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityPlayer.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityVillager.class));
        this.field_70715_bh.func_75776_a(6, (EntityAIBase)new EntityAITargetOwnerThreats(this));
        this.field_70715_bh.func_75776_a(7, (EntityAIBase)new EntityAITargetFuse(this));
    }

    @Override
    public void func_70105_a(float width, float height) {
        if (this.getSubspeciesIndex() == 3) {
            super.func_70105_a(width * 2.0f, height * 2.0f);
            return;
        }
        super.func_70105_a(width, height);
    }

    @Override
    public double getRenderScale() {
        if (this.getSubspeciesIndex() == 3) {
            return this.sizeScale * 2.0;
        }
        return this.sizeScale;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_130014_f_().field_72995_K) {
            if (this.getSubspeciesIndex() == 3 && !this.isPetType("familiar") && this.hasAttackTarget() && this.func_70068_e((Entity)this.func_70638_az()) > 1.0 && this.func_70681_au().nextInt(20) == 0) {
                if (this.field_70163_u - 1.0 > this.func_70638_az().field_70163_u) {
                    this.leap(6.0f, -1.0, (Entity)this.func_70638_az());
                } else if (this.field_70163_u + 1.0 < this.func_70638_az().field_70163_u) {
                    this.leap(6.0f, 1.0, (Entity)this.func_70638_az());
                } else {
                    this.leap(6.0f, 0.0, (Entity)this.func_70638_az());
                }
                if (this.func_130014_f_().func_82736_K().func_82766_b("mobGriefing") && this.geonachBlockBreakRadius > -1 && !this.isTamed()) {
                    this.destroyArea((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 10.0f, true, this.geonachBlockBreakRadius);
                }
            }
            if (!this.isTamed()) {
                if (this.updateTick % 40L == 0L && this.func_180799_ab()) {
                    this.transform(EntityVolcan.class, null, false);
                }
                if (this.fireDamageAbsorbed >= 10.0f) {
                    this.transform(EntityVolcan.class, null, false);
                }
            }
        }
        if (this.func_130014_f_().field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                int[] nArray = new int[1];
                nArray[0] = BlockTallGrass.func_176210_f((IBlockState)Blocks.field_150348_b.func_176223_P());
                this.func_130014_f_().func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, nArray);
            }
        }
    }

    @Override
    public float getAISpeedModifier() {
        if (this.hasAttackTarget() && this.func_70638_az() instanceof EntitySilverfish) {
            return 4.0f;
        }
        return super.getAISpeedModifier();
    }

    @Override
    public boolean attackMelee(Entity target, double damageScale) {
        if (!super.attackMelee(target, damageScale)) {
            return false;
        }
        if (target instanceof EntitySilverfish) {
            target.func_70106_y();
        }
        this.nextAttackPhase();
        return true;
    }

    @Override
    public int getMeleeCooldown() {
        if (this.getAttackPhase() == 2) {
            return super.getMeleeCooldown() * 3;
        }
        return super.getMeleeCooldown();
    }

    @Override
    public int getRangedCooldown() {
        if (this.getAttackPhase() == 2) {
            return super.getRangedCooldown() * 3;
        }
        return super.getRangedCooldown();
    }

    @Override
    public boolean isFlying() {
        return true;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public float getDamageModifier(DamageSource damageSrc) {
        if (damageSrc.func_76346_g() != null) {
            EntityLivingBase entityLiving;
            if (damageSrc.func_76346_g() instanceof EntitySilverfish) {
                return 0.0f;
            }
            Item heldItem = null;
            if (damageSrc.func_76346_g() instanceof EntityLivingBase && (entityLiving = (EntityLivingBase)damageSrc.func_76346_g()).func_184586_b(EnumHand.MAIN_HAND) != null) {
                heldItem = entityLiving.func_184586_b(EnumHand.MAIN_HAND).func_77973_b();
            }
            if (ObjectLists.isPickaxe(heldItem)) {
                return 4.0f;
            }
        }
        return 1.0f;
    }

    @Override
    public boolean isDamageTypeApplicable(String type, DamageSource source, float damage) {
        if (type.equals("cactus") || type.equals("inWall")) {
            return false;
        }
        if (source.func_76347_k()) {
            this.fireDamageAbsorbed += damage;
            return false;
        }
        return super.isDamageTypeApplicable(type, source, damage);
    }

    @Override
    public boolean canBurn() {
        return true;
    }

    @Override
    public IFusable getFusionTarget() {
        return this.fusionTarget;
    }

    @Override
    public void setFusionTarget(IFusable fusionTarget) {
        this.fusionTarget = fusionTarget;
    }

    @Override
    public Class getFusionClass(IFusable fusable) {
        if (fusable instanceof EntityCinder) {
            return EntityVolcan.class;
        }
        if (fusable instanceof EntityJengu) {
            return EntitySpriggan.class;
        }
        if (fusable instanceof EntityArgus) {
            return EntityTremor.class;
        }
        return null;
    }
}

