/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.elementalmobs.entity;

import com.lycanitesmobs.api.IFusable;
import com.lycanitesmobs.core.entity.EntityCreatureTameable;
import com.lycanitesmobs.core.entity.ai.EntityAIAttackMelee;
import com.lycanitesmobs.core.entity.ai.EntityAIFollowFuse;
import com.lycanitesmobs.core.entity.ai.EntityAIFollowOwner;
import com.lycanitesmobs.core.entity.ai.EntityAILookIdle;
import com.lycanitesmobs.core.entity.ai.EntityAIStealth;
import com.lycanitesmobs.core.entity.ai.EntityAITargetAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetFuse;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerThreats;
import com.lycanitesmobs.core.entity.ai.EntityAITargetRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAIWander;
import com.lycanitesmobs.core.entity.ai.EntityAIWatchClosest;
import com.lycanitesmobs.elementalmobs.entity.EntityCinder;
import com.lycanitesmobs.elementalmobs.entity.EntityDjinn;
import com.lycanitesmobs.elementalmobs.entity.EntityGeonach;
import com.lycanitesmobs.elementalmobs.entity.EntityGrue;
import com.lycanitesmobs.elementalmobs.entity.EntityTremor;
import com.lycanitesmobs.elementalmobs.entity.EntityWraith;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityArgus
extends EntityCreatureTameable
implements IMob,
IFusable {
    private int teleportTime = 60;
    protected IFusable fusionTarget;

    public EntityArgus(World par1World) {
        super(par1World);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.hasAttackSound = true;
        this.spawnsInWater = true;
        this.setupMob();
        this.field_70138_W = 1.0f;
        this.justAttackedTime = (short)40;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFollowFuse(this).setLostDistance(16.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIStealth(this).setStealthTime(20).setStealthAttack(true).setStealthMove(true));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee(this).setLongMemory(true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiSit);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFollowOwner(this).setStrayDistance(8.0).setLostDistance(32.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWander(this));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest(this).setTargetClass(EntityPlayer.class));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAILookIdle(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAITargetOwnerRevenge(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAITargetOwnerAttack(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetRevenge(this).setHelpCall(true));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityPlayer.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityVillager.class));
        this.field_70715_bh.func_75776_a(6, (EntityAIBase)new EntityAITargetOwnerThreats(this));
        this.field_70715_bh.func_75776_a(7, (EntityAIBase)new EntityAITargetFuse(this));
    }

    @Override
    public void func_70105_a(float width, float height) {
        if (this.getSubspeciesIndex() == 3) {
            super.func_70105_a(width * 2.0f, height * 2.0f);
            return;
        }
        super.func_70105_a(width, height);
    }

    @Override
    public double getRenderScale() {
        if (this.getSubspeciesIndex() == 3) {
            return this.sizeScale * 2.0;
        }
        return this.sizeScale;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_130014_f_().field_72995_K && this.hasAttackTarget() && this.teleportTime-- <= 0) {
            this.teleportTime = 20 + this.func_70681_au().nextInt(20);
            this.playJumpSound();
            BlockPos teleportPosition = this.getFacingPosition((Entity)this.func_70638_az(), (double)(-this.func_70638_az().field_70130_N) - 3.0, 0.0);
            if (this.canTeleportTo(this.func_130014_f_(), teleportPosition) && this.canTeleportTo(this.func_130014_f_(), new BlockPos(teleportPosition.func_177958_n(), teleportPosition.func_177956_o() + 1, teleportPosition.func_177952_p()))) {
                this.func_70107_b(teleportPosition.func_177958_n(), teleportPosition.func_177956_o(), teleportPosition.func_177952_p());
            } else if (this.canTeleportTo(this.func_130014_f_(), teleportPosition) && this.canTeleportTo(this.func_130014_f_(), teleportPosition)) {
                this.func_70107_b(this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v);
            }
        }
        if (this.func_130014_f_().field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                this.func_130014_f_().func_175688_a(EnumParticleTypes.SUSPENDED_DEPTH, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public boolean canTeleportTo(World world, BlockPos pos) {
        IBlockState blockState = this.func_130014_f_().func_180495_p(pos);
        if (blockState.func_177230_c() == null) {
            return false;
        }
        if (blockState.func_185915_l()) {
            return false;
        }
        if (this.getSubspeciesIndex() >= 3) {
            return true;
        }
        return this.testLightLevel(pos) <= 1;
    }

    @Override
    public boolean isFlying() {
        return true;
    }

    @Override
    public boolean isStrongSwimmer() {
        return true;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public boolean isDamageTypeApplicable(String type, DamageSource source, float damage) {
        if (type.equals("inWall")) {
            return false;
        }
        return super.isDamageTypeApplicable(type, source, damage);
    }

    @Override
    public boolean func_70648_aU() {
        return true;
    }

    @Override
    public IFusable getFusionTarget() {
        return this.fusionTarget;
    }

    @Override
    public void setFusionTarget(IFusable fusionTarget) {
        this.fusionTarget = fusionTarget;
    }

    @Override
    public Class getFusionClass(IFusable fusable) {
        if (fusable instanceof EntityCinder) {
            return EntityGrue.class;
        }
        if (fusable instanceof EntityGeonach) {
            return EntityTremor.class;
        }
        if (fusable instanceof EntityDjinn) {
            return EntityWraith.class;
        }
        return null;
    }
}

