/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.desertmobs.entity;

import com.lycanitesmobs.api.IGroupAnimal;
import com.lycanitesmobs.core.entity.EntityCreatureAgeable;
import com.lycanitesmobs.core.entity.ai.EntityAIAttackMelee;
import com.lycanitesmobs.core.entity.ai.EntityAIFollowMaster;
import com.lycanitesmobs.core.entity.ai.EntityAIFollowParent;
import com.lycanitesmobs.core.entity.ai.EntityAILookIdle;
import com.lycanitesmobs.core.entity.ai.EntityAIMate;
import com.lycanitesmobs.core.entity.ai.EntityAISwimming;
import com.lycanitesmobs.core.entity.ai.EntityAITargetMaster;
import com.lycanitesmobs.core.entity.ai.EntityAITargetMasterAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetParent;
import com.lycanitesmobs.core.entity.ai.EntityAITargetRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAITempt;
import com.lycanitesmobs.core.entity.ai.EntityAIWander;
import com.lycanitesmobs.core.entity.ai.EntityAIWatchClosest;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.ObjectLists;
import com.lycanitesmobs.desertmobs.entity.EntityJoustAlpha;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityJoust
extends EntityCreatureAgeable
implements IAnimals,
IGroupAnimal {
    public EntityJoust(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.hasAttackSound = true;
        this.babySpawnChance = 0.1;
        this.canGrow = true;
        this.attackTime = 10;
        this.setupMob();
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIMate(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAITempt(this).setItemList("CactusFood"));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee(this).setLongMemory(false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowParent(this).setSpeed(1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFollowMaster(this).setSpeed(1.0).setStrayDistance(8.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander(this));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest(this).setTargetClass(EntityPlayer.class));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAILookIdle(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAITargetRevenge(this).setHelpClasses(EntityJoustAlpha.class));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAITargetMasterAttack(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetParent(this).setSightCheck(false).setDistance(32.0));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetMaster(this).setTargetClass(EntityJoustAlpha.class).setSightCheck(false).setRange(64.0));
    }

    @Override
    public void onFirstSpawn() {
        CreatureInfo alphaInfo = CreatureManager.getInstance().getCreature("joustalpha");
        if (alphaInfo != null) {
            float alphaChance = (float)alphaInfo.creatureSpawn.spawnWeight / (float)Math.max(this.creatureInfo.creatureSpawn.spawnWeight, 1);
            if (this.func_70681_au().nextFloat() <= alphaChance) {
                EntityJoustAlpha alpha = new EntityJoustAlpha(this.func_130014_f_());
                alpha.func_82149_j((Entity)this);
                this.func_130014_f_().func_72838_d((Entity)alpha);
                this.func_130014_f_().func_72900_e((Entity)this);
            }
        }
        super.onFirstSpawn();
    }

    @Override
    public float getBlockPathWeight(int x, int y, int z) {
        IBlockState blockState = this.func_130014_f_().func_180495_p(new BlockPos(x, y - 1, z));
        if (blockState.func_177230_c() != Blocks.field_150350_a) {
            if (blockState.func_185904_a() == Material.field_151595_p) {
                return 10.0f;
            }
            if (blockState.func_185904_a() == Material.field_151571_B) {
                return 7.0f;
            }
            if (blockState.func_185904_a() == Material.field_151576_e) {
                return 5.0f;
            }
        }
        return super.getBlockPathWeight(x, y, z);
    }

    @Override
    public boolean func_184652_a(EntityPlayer player) {
        if (!this.hasAttackTarget() && !this.hasMaster()) {
            return true;
        }
        return super.func_184652_a(player);
    }

    @Override
    public boolean func_70686_a(Class targetClass) {
        if (targetClass.isAssignableFrom(EntityJoustAlpha.class)) {
            return false;
        }
        return super.func_70686_a(targetClass);
    }

    @Override
    public boolean isDamageTypeApplicable(String type, DamageSource source, float damage) {
        if (type.equals("cactus")) {
            return false;
        }
        return super.isDamageTypeApplicable(type, source, damage);
    }

    @Override
    public EntityCreatureAgeable createChild(EntityCreatureAgeable partener) {
        return new EntityJoust(this.func_130014_f_());
    }

    @Override
    public boolean isBreedingItem(ItemStack testStack) {
        return ObjectLists.inItemList("cactusfood", testStack);
    }

    @Override
    public void setGrowingAge(int age) {
        if (age == 0 && this.getAge() < 0 && this.func_70681_au().nextFloat() >= 0.9f) {
            EntityJoustAlpha alphaJoust = new EntityJoustAlpha(this.func_130014_f_());
            alphaJoust.func_82149_j((Entity)this);
            this.func_130014_f_().func_72838_d((Entity)alphaJoust);
            this.func_130014_f_().func_72900_e((Entity)this);
        }
        super.setGrowingAge(age);
    }
}

