/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.desertmobs.entity;

import com.lycanitesmobs.api.IGroupAlpha;
import com.lycanitesmobs.api.IGroupHunter;
import com.lycanitesmobs.api.IGroupPredator;
import com.lycanitesmobs.api.IGroupPrey;
import com.lycanitesmobs.core.config.ConfigBase;
import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.entity.ai.EntityAIAttackMelee;
import com.lycanitesmobs.core.entity.ai.EntityAIAvoid;
import com.lycanitesmobs.core.entity.ai.EntityAILookIdle;
import com.lycanitesmobs.core.entity.ai.EntityAISwimming;
import com.lycanitesmobs.core.entity.ai.EntityAITargetAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetAvoid;
import com.lycanitesmobs.core.entity.ai.EntityAITargetRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAIWander;
import com.lycanitesmobs.core.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class EntityGorgomite
extends EntityCreatureBase
implements IMob,
IGroupPrey {
    private int gorgomiteSwarmLimit = 10;

    public EntityGorgomite(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.ARTHROPOD;
        this.hasAttackSound = true;
        this.setWidth = 0.9f;
        this.setHeight = 0.9f;
        this.setupMob();
        this.gorgomiteSwarmLimit = ConfigBase.getConfig(this.creatureInfo.group, "general").getInt("Features", "Gorgomite Swarm Limit", this.gorgomiteSwarmLimit, "Limits how many Gorgomites there can be when swarming.");
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAvoid(this).setNearSpeed(2.0).setFarSpeed(1.5).setNearDistance(5.0).setFarDistance(10.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee(this).setLongMemory(true));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander(this));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest(this).setTargetClass(EntityPlayer.class));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAILookIdle(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAITargetRevenge(this).setHelpCall(true));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityPlayer.class));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityVillager.class));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAvoid(this).setTargetClass(IGroupHunter.class));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAvoid(this).setTargetClass(IGroupPredator.class));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAvoid(this).setTargetClass(IGroupAlpha.class));
    }

    @Override
    public void func_70636_d() {
        if (!this.func_130014_f_().field_72995_K && this.hasAttackTarget() && this.updateTick % 20L == 0L) {
            this.allyUpdate();
        }
        super.func_70636_d();
    }

    public void allyUpdate() {
        float random;
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        if (this.gorgomiteSwarmLimit > 0 && this.nearbyCreatureCount(this.getClass(), 64.0) < this.gorgomiteSwarmLimit && (random = this.field_70146_Z.nextFloat()) <= 0.25f) {
            this.spawnAlly(this.field_70165_t - 2.0 + (double)(random * 4.0f), this.field_70163_u, this.field_70161_v - 2.0 + (double)(random * 4.0f));
        }
    }

    public void spawnAlly(double x, double y, double z) {
        EntityGorgomite minion = new EntityGorgomite(this.func_130014_f_());
        minion.func_70012_b(x, y, z, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
        if (minion instanceof EntityCreatureBase) {
            ((EntityCreatureBase)minion).setMinion(true);
            ((EntityCreatureBase)minion).setSubspecies(this.getSubspeciesIndex(), true);
        }
        this.func_130014_f_().func_72838_d((Entity)minion);
        if (this.func_70638_az() != null) {
            minion.func_70604_c(this.func_70638_az());
        }
    }

    @Override
    public boolean func_70686_a(Class targetClass) {
        if (targetClass.isAssignableFrom(IGroupAlpha.class)) {
            return false;
        }
        if (targetClass.isAssignableFrom(IGroupPredator.class)) {
            return false;
        }
        return super.func_70686_a(targetClass);
    }

    @Override
    public void func_70645_a(DamageSource par1DamageSource) {
        this.allyUpdate();
        super.func_70645_a(par1DamageSource);
    }

    @Override
    public boolean canClimb() {
        return true;
    }

    @Override
    public boolean isDamageTypeApplicable(String type, DamageSource source, float damage) {
        if (type.equals("cactus")) {
            return false;
        }
        return super.isDamageTypeApplicable(type, source, damage);
    }
}

