/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.demonmobs.entity;

import com.lycanitesmobs.AssetManager;
import com.lycanitesmobs.api.IGroupBoss;
import com.lycanitesmobs.api.IGroupDemon;
import com.lycanitesmobs.core.entity.EntityCreatureTameable;
import com.lycanitesmobs.core.entity.EntityProjectileBase;
import com.lycanitesmobs.core.info.ObjectLists;
import com.lycanitesmobs.demonmobs.DemonMobs;
import com.lycanitesmobs.demonmobs.entity.EntityRahovart;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityHellfireWall
extends EntityProjectileBase {
    public Entity shootingEntity;

    public EntityHellfireWall(World par1World) {
        super(par1World);
    }

    public EntityHellfireWall(World par1World, EntityLivingBase par2EntityLivingBase) {
        super(par1World, par2EntityLivingBase);
    }

    public EntityHellfireWall(World par1World, double par2, double par4, double par6) {
        super(par1World, par2, par4, par6);
    }

    @Override
    public void setup() {
        this.entityName = "hellfirewall";
        this.group = DemonMobs.instance.group;
        this.setBaseDamage(10);
        this.setProjectileScale(20.0f);
        this.func_70105_a(10.0f, 10.0f);
        this.movement = false;
        this.pierce = true;
        this.pierceBlocks = true;
        this.projectileLife = 40;
        this.animationFrameMax = 59;
        this.textureTiling = 2;
        this.field_70145_X = true;
        this.waterProof = true;
        this.lavaProof = true;
    }

    public boolean func_70027_ad() {
        return false;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        Vec3d vec3 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d vec31 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult movingobjectposition = this.func_130014_f_().func_72933_a(vec3, vec31);
        if (!this.func_130014_f_().field_72995_K) {
            List list = this.func_130014_f_().func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72321_a(1.0, 1.0, 1.0));
            double d0 = 0.0;
            EntityLivingBase entitylivingbase = this.func_85052_h();
            for (int j = 0; j < list.size(); ++j) {
                Entity entity = (Entity)list.get(j);
                this.func_70184_a(new RayTraceResult(entity));
            }
        }
    }

    @Override
    public boolean entityLivingCollision(EntityLivingBase entityLiving) {
        if (!entityLiving.func_70045_F()) {
            entityLiving.func_70015_d(this.getEffectDuration(10) / 20);
        }
        return true;
    }

    @Override
    public boolean canDamage(EntityLivingBase targetEntity) {
        EntityLivingBase owner = this.func_85052_h();
        if (owner == null) {
            if (targetEntity instanceof EntityRahovart) {
                return false;
            }
            if (targetEntity instanceof IGroupDemon) {
                return false;
            }
        }
        return super.canDamage(targetEntity);
    }

    @Override
    public void onDamage(EntityLivingBase target, float damage, boolean attackSuccess) {
        for (PotionEffect potionEffect : target.func_70651_bq().toArray(new PotionEffect[target.func_70651_bq().size()])) {
            if (!ObjectLists.inEffectList("buffs", potionEffect.func_188419_a())) continue;
            target.func_184589_d(potionEffect.func_188419_a());
        }
        boolean obliterate = true;
        if (target instanceof EntityPlayer) {
            obliterate = false;
        } else if (target instanceof EntityTameable) {
            obliterate = !(((EntityTameable)target).func_70902_q() instanceof EntityPlayer);
        } else if (target instanceof EntityCreatureTameable) {
            boolean bl = obliterate = !(((EntityCreatureTameable)target).func_70902_q() instanceof EntityPlayer);
        }
        if (target instanceof IGroupBoss) {
            obliterate = false;
        }
        if (target instanceof IEntityOwnable) {
            boolean bl = obliterate = ((IEntityOwnable)target).func_70902_q() == null;
        }
        if (obliterate) {
            target.func_70606_j(0.0f);
        }
        super.onDamage(target, damage, attackSuccess);
    }

    @Override
    public SoundEvent getLaunchSound() {
        return AssetManager.getSound("hellfirewall");
    }

    public float func_70013_c() {
        return 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        return 0xF000F0;
    }
}

