/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.spawner.trigger;

import com.google.gson.JsonObject;
import com.lycanitesmobs.core.info.ObjectLists;
import com.lycanitesmobs.core.spawner.Spawner;
import com.lycanitesmobs.core.spawner.trigger.BlockSpawnTrigger;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TreeBlockSpawnTrigger
extends BlockSpawnTrigger {
    public TreeBlockSpawnTrigger(Spawner spawner) {
        super(spawner);
    }

    @Override
    public void loadFromJSON(JsonObject json) {
        super.loadFromJSON(json);
    }

    @Override
    public boolean isTriggerBlock(IBlockState blockState, World world, BlockPos blockPos) {
        return this.isTreeLogBlock(blockState.func_177230_c(), world, blockPos) || this.isTreeLeavesBlock(blockState.func_177230_c(), world, blockPos);
    }

    public boolean isTreeLogBlock(Block block, World world, BlockPos pos) {
        if (block instanceof BlockLog || ObjectLists.isInOreDictionary("logWood", block)) {
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            for (int searchX = x - 1; searchX <= x + 1; ++searchX) {
                block1: for (int searchZ = z - 1; searchZ <= z + 1; ++searchZ) {
                    for (int searchY = y; searchY <= Math.min(world.func_72800_K(), y + 32); ++searchY) {
                        Block searchBlock = world.func_180495_p(new BlockPos(searchX, searchY, searchZ)).func_177230_c();
                        if (searchBlock == block || searchBlock == null) continue;
                        if (ObjectLists.isInOreDictionary("treeLeaves", searchBlock)) {
                            return true;
                        }
                        if (!world.func_175623_d(new BlockPos(x, searchY, z))) continue block1;
                    }
                }
            }
        }
        return false;
    }

    public boolean isTreeLeavesBlock(Block block, World world, BlockPos pos) {
        if (block instanceof BlockLeaves || ObjectLists.isInOreDictionary("treeLeaves", block)) {
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            for (int searchX = x - 1; searchX <= x + 1; ++searchX) {
                block1: for (int searchZ = z - 1; searchZ <= z + 1; ++searchZ) {
                    for (int searchY = y; searchY >= Math.max(0, y - 32); --searchY) {
                        Block searchBlock = world.func_180495_p(new BlockPos(searchX, searchY, searchZ)).func_177230_c();
                        if (searchBlock == block || searchBlock == null) continue;
                        if (ObjectLists.isInOreDictionary("logWood", searchBlock)) {
                            return true;
                        }
                        if (!world.func_175623_d(new BlockPos(x, searchY, z))) continue block1;
                    }
                }
            }
        }
        return false;
    }
}

