/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.spawner.trigger;

import com.google.gson.JsonObject;
import com.lycanitesmobs.core.spawner.Spawner;
import com.lycanitesmobs.core.spawner.trigger.SpawnTrigger;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class TickSpawnTrigger
extends SpawnTrigger {
    public double tickRate = 400.0;
    public double lastTickDistanceMin = -1.0;
    public double lastTickDistanceMax = -1.0;
    public boolean useWorldTime = false;
    protected Map<EntityPlayer, BlockPos> lastTickPositions = new HashMap<EntityPlayer, BlockPos>();

    public TickSpawnTrigger(Spawner spawner) {
        super(spawner);
    }

    @Override
    public void loadFromJSON(JsonObject json) {
        if (json.has("tickRate")) {
            this.tickRate = json.get("tickRate").getAsDouble();
        }
        if (json.has("lastTickDistanceMin")) {
            this.lastTickDistanceMin = json.get("lastTickDistanceMin").getAsDouble();
        }
        if (json.has("lastTickDistanceMax")) {
            this.lastTickDistanceMax = json.get("lastTickDistanceMax").getAsDouble();
        }
        if (json.has("useWorldTime")) {
            this.useWorldTime = json.get("useWorldTime").getAsBoolean();
        }
        super.loadFromJSON(json);
    }

    public void onTick(EntityPlayer player, long ticks) {
        if (this.useWorldTime && (double)(player.func_130014_f_().func_72820_D() % 24000L) != this.tickRate) {
            return;
        }
        if (ticks == 0L || (double)ticks % this.tickRate != 0.0) {
            return;
        }
        if (this.chance < 1.0 && player.func_70681_au().nextDouble() > this.chance) {
            return;
        }
        if (this.lastTickDistanceMin > -1.0 || this.lastTickDistanceMax > -1.0) {
            BlockPos playerPos = player.func_180425_c();
            if (!this.lastTickPositions.containsKey(player)) {
                this.lastTickPositions.put(player, playerPos);
            } else {
                playerPos = this.lastTickPositions.get(player);
            }
            double lastTickDistance = player.func_180425_c().func_177951_i((Vec3i)playerPos);
            if (this.lastTickDistanceMin > -1.0 && lastTickDistance < this.lastTickDistanceMin) {
                return;
            }
            if (this.lastTickDistanceMax > -1.0 && lastTickDistance > this.lastTickDistanceMax) {
                return;
            }
        }
        this.trigger(player.func_130014_f_(), player, player.func_180425_c(), 0, 0);
    }
}

