/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.spawner.trigger;

import com.google.gson.JsonObject;
import com.lycanitesmobs.ExtendedPlayer;
import com.lycanitesmobs.core.spawner.Spawner;
import com.lycanitesmobs.core.spawner.trigger.SpawnTrigger;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SleepSpawnTrigger
extends SpawnTrigger {
    public int cooldown = 1200;
    protected Map<EntityPlayer, Integer> playerUsedTicks = new HashMap<EntityPlayer, Integer>();

    public SleepSpawnTrigger(Spawner spawner) {
        super(spawner);
    }

    @Override
    public void loadFromJSON(JsonObject json) {
        if (json.has("cooldown")) {
            this.cooldown = json.get("cooldown").getAsInt();
        }
        super.loadFromJSON(json);
    }

    public boolean onSleep(World world, EntityPlayer player, BlockPos spawnPos) {
        ExtendedPlayer playerExt;
        if (this.cooldown > -1 && (playerExt = ExtendedPlayer.getForPlayer(player)) != null) {
            int lastUsedTicks = 0;
            if (!this.playerUsedTicks.containsKey(player)) {
                this.playerUsedTicks.put(player, lastUsedTicks);
            } else {
                lastUsedTicks = this.playerUsedTicks.get(player);
            }
            if (playerExt.timePlayed - (long)lastUsedTicks < (long)this.cooldown) {
                return false;
            }
        }
        if (this.chance < 1.0 && player.func_70681_au().nextDouble() > this.chance) {
            return false;
        }
        return this.trigger(world, player, spawnPos, 0, 0);
    }
}

