/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.spawner.trigger;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.spawner.Spawner;
import com.lycanitesmobs.core.spawner.trigger.SpawnTrigger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;

public abstract class EntitySpawnTrigger
extends SpawnTrigger {
    public List<EnumCreatureAttribute> entityTypes = new ArrayList<EnumCreatureAttribute>();
    public String entityTypesListType = "whitelist";
    public List<String> entityIds = new ArrayList<String>();
    public String entityIdsListType = "blacklist";

    public EntitySpawnTrigger(Spawner spawner) {
        super(spawner);
    }

    @Override
    public void loadFromJSON(JsonObject json) {
        Iterator jsonIterator;
        JsonArray jsonArray;
        if (json.has("entityTypes")) {
            jsonArray = json.get("entityTypes").getAsJsonArray();
            jsonIterator = jsonArray.iterator();
            while (jsonIterator.hasNext()) {
                EnumCreatureAttribute entityType = EnumCreatureAttribute.valueOf((String)((JsonElement)jsonIterator.next()).getAsString().toUpperCase());
                if (entityType == null) continue;
                this.entityTypes.add(entityType);
            }
        }
        if (json.has("entityTypesListType")) {
            this.entityTypesListType = json.get("entityTypesListType").getAsString();
        }
        if (json.has("entityIds")) {
            jsonArray = json.get("entityIds").getAsJsonArray();
            jsonIterator = jsonArray.iterator();
            while (jsonIterator.hasNext()) {
                String entityId = ((JsonElement)jsonIterator.next()).getAsString();
                if (entityId == null) continue;
                this.entityIds.add(entityId);
            }
        }
        if (json.has("entityIdsListType")) {
            this.entityIdsListType = json.get("entityIdsListType").getAsString();
        }
        super.loadFromJSON(json);
    }

    public boolean isMatchingEntity(EntityLivingBase killedEntity) {
        if (this.entityTypes.contains(killedEntity.func_70668_bt()) ? "blacklist".equalsIgnoreCase(this.entityTypesListType) : "whitelist".equalsIgnoreCase(this.entityTypesListType)) {
            return false;
        }
        String entityId = EntityList.func_75621_b((Entity)killedEntity);
        if (killedEntity instanceof EntityCreatureBase) {
            entityId = ((EntityCreatureBase)killedEntity).creatureInfo.getEntityId();
        }
        return !(entityId == null ? "whitelist".equalsIgnoreCase(this.entityIdsListType) : (this.entityIds.contains(entityId) ? "blacklist".equalsIgnoreCase(this.entityIdsListType) : "whitelist".equalsIgnoreCase(this.entityIdsListType)));
    }
}

