/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.spawner.condition;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lycanitesmobs.ExtendedWorld;
import com.lycanitesmobs.core.spawner.condition.SpawnCondition;
import java.util.Iterator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class WorldSpawnCondition
extends SpawnCondition {
    public int[] dimensionIds;
    public String dimensionListType = "whitelist";
    public double worldDayMin = -1.0;
    public double worldDayMax = -1.0;
    public double worldDayN = -1.0;
    public int dayTimeMin = -1;
    public int dayTimeMax = -1;
    public String weather = "any";
    public short difficultyMin = (short)-1;
    public short difficultyMax = (short)-1;
    public int moonPhase = -1;

    @Override
    public void loadFromJSON(JsonObject json) {
        if (json.has("dimensionIds")) {
            JsonArray jsonArray = json.get("dimensionIds").getAsJsonArray();
            this.dimensionIds = new int[jsonArray.size()];
            Iterator jsonIterator = jsonArray.iterator();
            int i = 0;
            while (jsonIterator.hasNext()) {
                this.dimensionIds[i] = ((JsonElement)jsonIterator.next()).getAsInt();
                ++i;
            }
        }
        if (json.has("dimensionListType")) {
            this.dimensionListType = json.get("dimensionListType").getAsString();
        }
        if (json.has("worldDayMin")) {
            this.worldDayMin = json.get("worldDayMin").getAsInt();
        }
        if (json.has("worldDayMax")) {
            this.worldDayMax = json.get("worldDayMax").getAsInt();
        }
        if (json.has("worldDayN")) {
            this.worldDayN = json.get("worldDayN").getAsInt();
        }
        if (json.has("dayTimeMin")) {
            this.dayTimeMin = json.get("dayTimeMin").getAsInt();
        }
        if (json.has("dayTimeMax")) {
            this.dayTimeMax = json.get("dayTimeMax").getAsInt();
        }
        if (json.has("weather")) {
            this.weather = json.get("weather").getAsString();
        }
        if (json.has("difficultyMin")) {
            this.difficultyMin = json.get("difficultyMin").getAsShort();
        }
        if (json.has("difficultyMax")) {
            this.difficultyMax = json.get("difficultyMax").getAsShort();
        }
        if (json.has("moonPhase")) {
            this.moonPhase = json.get("moonPhase").getAsInt();
        }
        super.loadFromJSON(json);
    }

    @Override
    public boolean isMet(World world, EntityPlayer player) {
        ExtendedWorld worldExt = ExtendedWorld.getForWorld(world);
        int time = (int)Math.floor((double)world.func_72820_D() % 24000.0);
        int day = (int)Math.floor((double)(worldExt.useTotalWorldTime ? world.func_82737_E() : world.func_72820_D()) / 23999.0);
        if (this.dimensionIds != null) {
            boolean dimensionIdFound = false;
            for (int dimensionId : this.dimensionIds) {
                if (world.field_73011_w.getDimension() != dimensionId) continue;
                dimensionIdFound = true;
                break;
            }
            if ("whitelist".equalsIgnoreCase(this.dimensionListType) && !dimensionIdFound) {
                return false;
            }
            if ("blacklist".equalsIgnoreCase(this.dimensionListType) && dimensionIdFound) {
                return false;
            }
        }
        if (this.worldDayMin >= 0.0 && (double)day < this.worldDayMin) {
            return false;
        }
        if (this.worldDayMax >= 0.0 && (double)day > this.worldDayMax) {
            return false;
        }
        if (this.worldDayN >= 0.0 && (day == 0 || (double)day % this.worldDayN != 0.0)) {
            return false;
        }
        if (this.dayTimeMin >= 0 && time < this.dayTimeMin) {
            return false;
        }
        if (this.dayTimeMax >= 0 && time > this.dayTimeMax) {
            return false;
        }
        if ("clear".equalsIgnoreCase(this.weather) && (world.func_72896_J() || world.func_72911_I())) {
            return false;
        }
        if ("rain".equalsIgnoreCase(this.weather) && (!world.func_72896_J() || world.func_72911_I())) {
            return false;
        }
        if ("storm".equalsIgnoreCase(this.weather) && !world.func_72911_I()) {
            return false;
        }
        if (!(!"rainstorm".equalsIgnoreCase(this.weather) || world.func_72896_J() && world.func_72911_I())) {
            return false;
        }
        if ("notclear".equalsIgnoreCase(this.weather) && !world.func_72896_J() && !world.func_72911_I()) {
            return false;
        }
        if (this.difficultyMin >= 0 && world.func_175659_aa().func_151525_a() < this.difficultyMin) {
            return false;
        }
        if (this.difficultyMax >= 0 && world.func_175659_aa().func_151525_a() > this.difficultyMax) {
            return false;
        }
        if (this.moonPhase >= 0 && world.field_73011_w.func_76559_b(world.func_72820_D()) != this.moonPhase) {
            return false;
        }
        return super.isMet(world, player);
    }
}

