/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.spawner;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.Utilities;
import com.lycanitesmobs.core.JSONLoader;
import com.lycanitesmobs.core.info.GroupInfo;
import com.lycanitesmobs.core.spawner.Spawner;
import com.lycanitesmobs.core.spawner.condition.SpawnCondition;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SpawnerManager
extends JSONLoader {
    public static SpawnerManager INSTANCE;
    public Map<String, Spawner> spawners = new HashMap<String, Spawner>();
    public List<SpawnCondition> globalSpawnConditions = new ArrayList<SpawnCondition>();

    public static SpawnerManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SpawnerManager();
        }
        return INSTANCE;
    }

    public void loadAllFromJSON() {
        JsonObject globalJson;
        LycanitesMobs.printDebug("JSONSpawner", "Loading JSON Spawners!");
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        HashMap<String, JsonObject> spawnerJSONs = new HashMap<String, JsonObject>();
        Path path = Utilities.getAssetPath(this.getClass(), LycanitesMobs.group.filename, "spawners");
        HashMap<String, JsonObject> defaultSpawnerJSONs = new HashMap<String, JsonObject>();
        this.loadJsonObjects(gson, path, defaultSpawnerJSONs, "name", "spawner");
        path = Utilities.getAssetPath(this.getClass(), LycanitesMobs.group.filename, "mobevents");
        HashMap<String, JsonObject> defaultMobEventsJSONs = new HashMap<String, JsonObject>();
        this.loadJsonObjects(gson, path, defaultMobEventsJSONs, "name", "spawner");
        String configPath = LycanitesMobs.proxy.getMinecraftDir() + "/config/" + "lycanitesmobs" + "/";
        File customSpawnersDir = new File(configPath + "spawners");
        customSpawnersDir.mkdirs();
        path = customSpawnersDir.toPath();
        HashMap<String, JsonObject> customSpawnerJSONs = new HashMap<String, JsonObject>();
        this.loadJsonObjects(gson, path, customSpawnerJSONs, "name", "spawner");
        File customMobEventsDir = new File(configPath + "mobevents");
        path = customMobEventsDir.toPath();
        HashMap<String, JsonObject> customMobEventsJSONs = new HashMap<String, JsonObject>();
        this.loadJsonObjects(gson, path, customMobEventsJSONs, "name", "spawner");
        this.writeDefaultJSONObjects(gson, defaultSpawnerJSONs, customSpawnerJSONs, spawnerJSONs, true, "spawners");
        this.writeDefaultJSONObjects(gson, defaultMobEventsJSONs, customMobEventsJSONs, spawnerJSONs, true, "mobevents");
        LycanitesMobs.printDebug("", "Loading " + spawnerJSONs.size() + " JSON Spawners...");
        for (String spawnerJSONName : spawnerJSONs.keySet()) {
            try {
                JsonObject spawnerJSON = (JsonObject)spawnerJSONs.get(spawnerJSONName);
                LycanitesMobs.printDebug("JSONSpawner", "Loading Spawner JSON: " + spawnerJSON);
                Spawner spawner = new Spawner();
                spawner.loadFromJSON(spawnerJSON);
                this.addSpawner(spawner);
            }
            catch (JsonParseException e) {
                LycanitesMobs.printWarning("", "Parsing error loading JSON Spawner: " + spawnerJSONName);
                e.printStackTrace();
            }
            catch (Exception e) {
                LycanitesMobs.printWarning("", "There was a problem loading JSON Spawner: " + spawnerJSONName);
                e.printStackTrace();
            }
        }
        LycanitesMobs.printDebug("", "Complete! " + this.spawners.size() + " JSON Spawners Loaded In Total.");
        this.globalSpawnConditions.clear();
        Path defaultGlobalPath = Utilities.getAssetPath(this.getClass(), LycanitesMobs.group.filename, "globalspawner.json");
        JsonObject defaultGlobalJson = this.loadJsonObject(gson, defaultGlobalPath);
        File customGlobalFile = new File(configPath + "globalspawner.json");
        JsonObject customGlobalJson = null;
        if (customGlobalFile.exists()) {
            customGlobalJson = this.loadJsonObject(gson, customGlobalFile.toPath());
        }
        if ((globalJson = this.writeDefaultJSONObject(gson, "globalspawner", defaultGlobalJson, customGlobalJson)).has("conditions")) {
            JsonArray jsonArray = globalJson.get("conditions").getAsJsonArray();
            Iterator jsonIterator = jsonArray.iterator();
            while (jsonIterator.hasNext()) {
                JsonObject spawnConditionJson = ((JsonElement)jsonIterator.next()).getAsJsonObject();
                SpawnCondition spawnCondition = SpawnCondition.createFromJSON(spawnConditionJson);
                this.globalSpawnConditions.add(spawnCondition);
            }
        }
        if (this.globalSpawnConditions.size() > 0) {
            LycanitesMobs.printDebug("JSONSpawner", "Loaded " + this.globalSpawnConditions.size() + " Global Spawn Conditions.");
        }
    }

    @Override
    public void parseJson(GroupInfo groupInfo, String name, JsonObject json) {
    }

    public void reload() {
        LycanitesMobs.printDebug("JSONSpawner", "Destroying JSON Spawners!");
        for (Spawner spawner : this.spawners.values().toArray(new Spawner[this.spawners.size()])) {
            spawner.destroy();
        }
        this.loadAllFromJSON();
    }

    public void addSpawner(Spawner spawner) {
        if (this.spawners.containsKey(spawner.name)) {
            LycanitesMobs.printWarning("", "[Spawner Manager] Tried to add a Spawner with a name that is already in use: " + spawner.name);
            return;
        }
        if (this.spawners.values().contains(spawner)) {
            LycanitesMobs.printWarning("", "[Spawner Manager] Tried to add a Spawner that is already added: " + spawner.name);
            return;
        }
        this.spawners.put(spawner.name, spawner);
    }

    public void removeSpawner(Spawner spawner) {
        if (!this.spawners.containsKey(spawner.name)) {
            LycanitesMobs.printWarning("", "[Spawner Manager] Tried to remove a Spawner that hasn't been added: " + spawner.name);
            return;
        }
        this.spawners.remove(spawner.name);
    }
}

