/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.spawner;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lycanitesmobs.ExtendedWorld;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.mobevent.MobEvent;
import com.lycanitesmobs.core.mobevent.MobEventPlayerServer;
import com.lycanitesmobs.core.spawner.MobSpawn;
import com.lycanitesmobs.core.spawner.SpawnerEventListener;
import com.lycanitesmobs.core.spawner.SpawnerManager;
import com.lycanitesmobs.core.spawner.SpawnerMobRegistry;
import com.lycanitesmobs.core.spawner.condition.SpawnCondition;
import com.lycanitesmobs.core.spawner.location.SpawnLocation;
import com.lycanitesmobs.core.spawner.trigger.SpawnTrigger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.eventhandler.Event;

public class Spawner {
    public List<SpawnCondition> conditions = new ArrayList<SpawnCondition>();
    public List<SpawnTrigger> triggers = new ArrayList<SpawnTrigger>();
    public List<SpawnLocation> locations = new ArrayList<SpawnLocation>();
    public List<MobSpawn> mobSpawns = new ArrayList<MobSpawn>();
    public String name;
    public String sharedName;
    public boolean loadDefault = false;
    public boolean enabled = true;
    public int conditionsRequired = 0;
    public int triggersRequired = 1;
    public Map<Integer, String> triggerCountMessages = new HashMap<Integer, String>();
    public String multipleLocations = "combine";
    public int mobCountMin = 1;
    public int mobCountMax = 1;
    public boolean ignoreDimensions = false;
    public boolean ignoreBiomes = false;
    public boolean ignoreCollision = false;
    public boolean ignoreLightLevel = false;
    public boolean ignoreGroupLimit = false;
    protected double groupLimitRange = 32.0;
    protected boolean ignoreForgeCanSpawnEvent = false;
    public boolean forceNoDespawn = false;
    public boolean chainSpawning = true;
    public boolean enableWithoutMobs = false;
    public String eventName = "";
    public int blockBreakRadius = -1;
    protected Map<EntityPlayer, Integer> triggerCounts = new HashMap<EntityPlayer, Integer>();

    public void loadFromJSON(JsonObject json) {
        Iterator jsonIterator;
        JsonArray jsonArray;
        this.sharedName = this.name = json.get("name").getAsString();
        if (json.has("sharedName")) {
            this.sharedName = json.get("sharedName").getAsString();
        }
        if (json.has("loadDefault")) {
            this.loadDefault = json.get("loadDefault").getAsBoolean();
        }
        if (json.has("enabled")) {
            this.enabled = json.get("enabled").getAsBoolean();
        }
        if (json.has("conditionsRequired")) {
            this.conditionsRequired = json.get("conditionsRequired").getAsInt();
        }
        if (json.has("triggersRequired")) {
            this.triggersRequired = json.get("triggersRequired").getAsInt();
        }
        if (json.has("triggerCountMessages")) {
            jsonArray = json.get("triggerCountMessages").getAsJsonArray();
            jsonIterator = jsonArray.iterator();
            while (jsonIterator.hasNext()) {
                JsonObject tcmJson = ((JsonElement)jsonIterator.next()).getAsJsonObject();
                this.triggerCountMessages.put(tcmJson.get("count").getAsInt(), tcmJson.get("message").getAsString());
            }
        }
        if (json.has("multipleLocations")) {
            this.multipleLocations = json.get("multipleLocations").getAsString();
        }
        if (json.has("mobCountMin")) {
            this.mobCountMin = json.get("mobCountMin").getAsInt();
        }
        if (json.has("mobCountMax")) {
            this.mobCountMax = json.get("mobCountMax").getAsInt();
        }
        if (json.has("ignoreDimensions")) {
            this.ignoreDimensions = json.get("ignoreDimensions").getAsBoolean();
        }
        if (json.has("ignoreBiomes")) {
            this.ignoreBiomes = json.get("ignoreBiomes").getAsBoolean();
        }
        if (json.has("ignoreCollision")) {
            this.ignoreCollision = json.get("ignoreCollision").getAsBoolean();
        }
        if (json.has("ignoreLightLevel")) {
            this.ignoreLightLevel = json.get("ignoreLightLevel").getAsBoolean();
        }
        if (json.has("ignoreGroupLimit")) {
            this.ignoreGroupLimit = json.get("ignoreGroupLimit").getAsBoolean();
        }
        if (json.has("groupLimitRange")) {
            this.groupLimitRange = json.get("groupLimitRange").getAsDouble();
        }
        if (json.has("ignoreForgeCanSpawnEvent")) {
            this.ignoreForgeCanSpawnEvent = json.get("ignoreForgeCanSpawnEvent").getAsBoolean();
        }
        if (json.has("forceNoDespawn")) {
            this.forceNoDespawn = json.get("forceNoDespawn").getAsBoolean();
        }
        if (json.has("chainSpawning")) {
            this.chainSpawning = json.get("chainSpawning").getAsBoolean();
        }
        if (json.has("enableWithoutMobs")) {
            this.enableWithoutMobs = json.get("enableWithoutMobs").getAsBoolean();
        }
        if (json.has("eventName")) {
            this.eventName = json.get("eventName").getAsString();
        }
        if (json.has("blockBreakRadius")) {
            this.blockBreakRadius = json.get("blockBreakRadius").getAsInt();
        }
        if (json.has("conditions")) {
            jsonArray = json.get("conditions").getAsJsonArray();
            jsonIterator = jsonArray.iterator();
            while (jsonIterator.hasNext()) {
                JsonObject conditionJson = ((JsonElement)jsonIterator.next()).getAsJsonObject();
                SpawnCondition spawnCondition = SpawnCondition.createFromJSON(conditionJson);
                this.conditions.add(spawnCondition);
            }
        }
        if (json.has("triggers")) {
            jsonArray = json.get("triggers").getAsJsonArray();
            jsonIterator = jsonArray.iterator();
            while (jsonIterator.hasNext()) {
                JsonObject triggerJson = ((JsonElement)jsonIterator.next()).getAsJsonObject();
                SpawnTrigger spawnTrigger = SpawnTrigger.createFromJSON(triggerJson, this);
                this.triggers.add(spawnTrigger);
                if (!this.enabled) continue;
                SpawnerEventListener.getInstance().addTrigger(spawnTrigger);
            }
        }
        if (json.has("locations")) {
            jsonArray = json.get("locations").getAsJsonArray();
            jsonIterator = jsonArray.iterator();
            while (jsonIterator.hasNext()) {
                JsonObject locationJson = ((JsonElement)jsonIterator.next()).getAsJsonObject();
                SpawnLocation spawnLocation = SpawnLocation.createFromJSON(locationJson);
                this.locations.add(spawnLocation);
            }
        }
        if (json.has("mobSpawns")) {
            jsonArray = json.get("mobSpawns").getAsJsonArray();
            jsonIterator = jsonArray.iterator();
            while (jsonIterator.hasNext()) {
                JsonObject mobSpawnJson = ((JsonElement)jsonIterator.next()).getAsJsonObject();
                MobSpawn mobSpawn = MobSpawn.createFromJSON(mobSpawnJson);
                if (mobSpawn == null) continue;
                this.mobSpawns.add(mobSpawn);
            }
        }
    }

    public void destroy() {
        for (SpawnTrigger spawnTrigger : this.triggers) {
            SpawnerEventListener.getInstance().removeTrigger(spawnTrigger);
        }
        SpawnerManager.getInstance().removeSpawner(this);
    }

    public boolean isEnabled(World world, EntityPlayer player) {
        if (!this.enabled || CreatureManager.getInstance().spawnConfig.disableAllSpawning || !world.func_82736_K().func_82766_b("doMobSpawning")) {
            return false;
        }
        if (!"".equals(this.eventName)) {
            ExtendedWorld worldExt = ExtendedWorld.getForWorld(world);
            if (worldExt == null) {
                return false;
            }
            if (worldExt.getMobEventPlayerServer(this.eventName) == null) {
                return false;
            }
        }
        return this.enableWithoutMobs || !this.mobSpawns.isEmpty() || SpawnerMobRegistry.getMobSpawns(this.sharedName) != null;
    }

    public boolean canSpawn(World world, EntityPlayer player) {
        if (!SpawnerManager.getInstance().globalSpawnConditions.isEmpty()) {
            LycanitesMobs.printDebug("JSONSpawner", "Global Conditions Required: " + SpawnerManager.getInstance().globalSpawnConditions.size());
            for (SpawnCondition condition : SpawnerManager.getInstance().globalSpawnConditions) {
                if (condition.isMet(world, player)) continue;
                LycanitesMobs.printDebug("JSONSpawner", "Global Condition: " + condition + "Failed");
                return false;
            }
        }
        if (this.conditions.isEmpty()) {
            LycanitesMobs.printDebug("JSONSpawner", "No Conditions");
            return true;
        }
        LycanitesMobs.printDebug("JSONSpawner", "Conditions Required: " + (this.conditionsRequired > 0 ? Integer.valueOf(this.conditionsRequired) : "All"));
        int conditionsMet = 0;
        int conditionsRequired = this.conditionsRequired > 0 ? this.conditionsRequired : this.conditions.size();
        for (SpawnCondition condition : this.conditions) {
            boolean met = condition.isMet(world, player);
            LycanitesMobs.printDebug("JSONSpawner", "Condition: " + condition + " " + (met ? "Passed" : "Failed"));
            if (!met || ++conditionsMet < conditionsRequired) continue;
            LycanitesMobs.printDebug("JSONSpawner", "Sufficient Conditions Met");
            return true;
        }
        LycanitesMobs.printDebug("JSONSpawner", "Insufficient Conditions Met: " + conditionsMet + "/" + conditionsRequired);
        return false;
    }

    public boolean trigger(World world, EntityPlayer player, BlockPos triggerPos, int level, int countAmount, int chain) {
        int currentCount;
        if (!this.isEnabled(world, player)) {
            return false;
        }
        LycanitesMobs.printDebug("JSONSpawner", "~O==================== Spawner Triggered: " + this.name + " ====================O~");
        if (!this.canSpawn(world, player)) {
            LycanitesMobs.printDebug("JSONSpawner", "This Spawner Cannot Spawn");
            return false;
        }
        if (this.triggersRequired <= 1 || player == null) {
            LycanitesMobs.printDebug("JSONSpawner", "Only one trigger required.");
            return this.doSpawn(world, player, triggerPos, level, chain);
        }
        if (!this.triggerCounts.containsKey(player)) {
            this.triggerCounts.put(player, Math.max(countAmount, 0));
        }
        int lastCount = currentCount = this.triggerCounts.get(player).intValue();
        currentCount = countAmount == 0 ? 0 : (currentCount += countAmount);
        if (currentCount != lastCount && this.triggerCountMessages.containsKey(currentCount)) {
            String message = I18n.func_74838_a((String)this.triggerCountMessages.get(currentCount));
            player.func_145747_a((ITextComponent)new TextComponentString(message));
        }
        LycanitesMobs.printDebug("JSONSpawner", "Trigger " + currentCount + "/" + this.triggersRequired);
        if (currentCount >= this.triggersRequired) {
            this.triggerCounts.put(player, 0);
            return this.doSpawn(world, player, triggerPos, level, chain);
        }
        this.triggerCounts.put(player, currentCount);
        return false;
    }

    public boolean doSpawn(World world, EntityPlayer player, BlockPos triggerPos, int level, int chain) {
        int mobCount = this.mobCountMin;
        if (this.mobCountMax > this.mobCountMin) {
            mobCount = world.field_73012_v.nextInt(this.mobCountMax - this.mobCountMin) + 1 + this.mobCountMin;
        }
        ExtendedWorld worldExt = ExtendedWorld.getForWorld(world);
        LycanitesMobs.printDebug("JSONSpawner", "Spawning Wave: " + mobCount + " Mob(s)");
        LycanitesMobs.printDebug("JSONSpawner", "Trigger World: " + world);
        LycanitesMobs.printDebug("JSONSpawner", "Trigger Player: " + player);
        LycanitesMobs.printDebug("JSONSpawner", "Trigger Position: " + triggerPos);
        List<BlockPos> spawnPositions = this.getSpawnPos(world, player, triggerPos);
        if (spawnPositions.isEmpty()) {
            LycanitesMobs.printDebug("JSONSpawner", "No Spawn Positions Found From Spawn Location");
            return false;
        }
        Collections.shuffle(spawnPositions);
        LycanitesMobs.printDebug("JSONSpawner", "Positions Found: " + spawnPositions.size());
        ArrayList<Biome> biomes = null;
        if (!this.ignoreBiomes) {
            biomes = new ArrayList<Biome>();
            for (BlockPos spawnPos : spawnPositions) {
                Biome biome = world.func_180494_b(spawnPos);
                if (biomes.contains(biome)) continue;
                biomes.add(biome);
            }
            LycanitesMobs.printDebug("JSONSpawner", "Biomes Found: " + biomes.size());
        } else {
            LycanitesMobs.printDebug("JSONSpawner", "All biome checks are ignored by this Spawner.");
        }
        List<MobSpawn> mobSpawns = this.getMobSpawns(world, player, spawnPositions.size(), biomes);
        LycanitesMobs.printDebug("JSONSpawner", "Mobs Found: " + mobSpawns.size());
        if (mobSpawns.size() == 0) {
            return false;
        }
        int mobsSpawned = 0;
        for (BlockPos spawnPos : spawnPositions) {
            if (mobsSpawned >= mobCount) break;
            LycanitesMobs.printDebug("JSONSpawner", "---------- Spawn Iteration: " + mobsSpawned + " ----------");
            LycanitesMobs.printDebug("JSONSpawner", "Spawn Position: " + spawnPos);
            MobSpawn mobSpawn = this.chooseMobToSpawn(world, mobSpawns);
            if (mobSpawn == null) {
                LycanitesMobs.printDebug("JSONSpawner", "No Mob Spawn Chosen");
                continue;
            }
            LycanitesMobs.printDebug("JSONSpawner", "Spawn Mob: " + mobSpawn);
            EntityLiving entityLiving = mobSpawn.createEntity(world);
            if (entityLiving == null) {
                LycanitesMobs.printWarning("JSONSpawner", "Unable to instantiate an entity. Class: " + mobSpawn.entityClass);
                continue;
            }
            EntityCreatureBase entityCreature = null;
            if (entityLiving instanceof EntityCreatureBase) {
                entityCreature = (EntityCreatureBase)entityLiving;
                LycanitesMobs.printDebug("JSONSpawner", "Mob is a Lycanites Mob");
            } else {
                LycanitesMobs.printDebug("JSONSpawner", "Mob is not a Lycanites Mob");
            }
            LycanitesMobs.printDebug("JSONSpawner", "Attempting to spawn " + entityLiving + "...");
            entityLiving.func_70012_b((double)spawnPos.func_177958_n() + 0.5, (double)spawnPos.func_177956_o(), (double)spawnPos.func_177952_p() + 0.5, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
            Event.Result canSpawn = ForgeEventFactory.canEntitySpawn((EntityLiving)entityLiving, (World)world, (float)((float)spawnPos.func_177958_n() + 0.5f), (float)spawnPos.func_177956_o(), (float)((float)spawnPos.func_177952_p() + 0.5f), (boolean)false);
            if (canSpawn == Event.Result.DENY && !this.ignoreForgeCanSpawnEvent && !mobSpawn.ignoreForgeCanSpawnEvent) {
                LycanitesMobs.printDebug("JSONSpawner", "Spawn Check Failed! Spawning blocked by Forge Can Spawn Event, this is caused another mod.");
                continue;
            }
            if (!this.mobInstanceSpawnCheck(entityLiving, mobSpawn, world, player, spawnPos, level, canSpawn == Event.Result.ALLOW)) {
                LycanitesMobs.printDebug("JSONSpawner", "Mob Instance Spawn Check Failed!");
                continue;
            }
            this.spawnEntity(world, worldExt, entityLiving, level, mobSpawn, player, chain);
            if (!ForgeEventFactory.doSpecialSpawn((EntityLiving)entityLiving, (World)world, (float)((float)spawnPos.func_177958_n() + 0.5f), (float)spawnPos.func_177956_o(), (float)((float)spawnPos.func_177952_p() + 0.5f)) && entityCreature != null) {
                entityLiving.func_180482_a(world.func_175649_E(spawnPos), null);
            }
            LycanitesMobs.printDebug("JSONSpawner", "Spawn Checks Passed! Mob Spawned!");
            ++mobsSpawned;
        }
        return mobsSpawned > 0;
    }

    public List<BlockPos> getSpawnPos(World world, EntityPlayer player, BlockPos triggerPos) {
        LycanitesMobs.printDebug("JSONSpawner", "Searching for Spawn Positions...");
        List<BlockPos> spawnPositions = new ArrayList<BlockPos>();
        if (this.locations.isEmpty()) {
            LycanitesMobs.printDebug("JSONSpawner", "No Spawn Locations, Using Trigger Position");
            spawnPositions.add(triggerPos);
            return spawnPositions;
        }
        if (this.locations.size() == 1) {
            LycanitesMobs.printDebug("JSONSpawner", "Only One Spawn Location");
            return this.locations.get(0).getSpawnPositions(world, player, triggerPos);
        }
        LycanitesMobs.printDebug("JSONSpawner", "Multiple Spawn Locations, Mode: " + this.multipleLocations);
        if ("order".equals(this.multipleLocations)) {
            for (SpawnLocation spawnLocation : this.locations) {
                spawnPositions = spawnLocation.getSpawnPositions(world, player, triggerPos);
                if (spawnPositions.isEmpty()) continue;
                return spawnPositions;
            }
        }
        if ("random".equals(this.multipleLocations)) {
            ArrayList<List<BlockPos>> possibleSpawnPosLists = new ArrayList<List<BlockPos>>();
            for (SpawnLocation location : this.locations) {
                spawnPositions = location.getSpawnPositions(world, player, triggerPos);
                if (spawnPositions.isEmpty()) continue;
                possibleSpawnPosLists.add(spawnPositions);
            }
            if (possibleSpawnPosLists.isEmpty()) {
                return spawnPositions;
            }
            if (possibleSpawnPosLists.size() == 1) {
                return (List)possibleSpawnPosLists.get(0);
            }
            int n = world.field_73012_v.nextInt(possibleSpawnPosLists.size());
            return (List)possibleSpawnPosLists.get(n);
        }
        if ("combine".equals(this.multipleLocations)) {
            for (SpawnLocation spawnLocation : this.locations) {
                spawnPositions.addAll(spawnLocation.getSpawnPositions(world, player, triggerPos));
            }
            return spawnPositions;
        }
        return spawnPositions;
    }

    public List<MobSpawn> getMobSpawns(World world, EntityPlayer player, int blockCount, List<Biome> biomes) {
        ArrayList<MobSpawn> allMobSpawns = new ArrayList<MobSpawn>();
        Collection<MobSpawn> globalSpawns = SpawnerMobRegistry.getMobSpawns(this.sharedName);
        if (globalSpawns != null) {
            allMobSpawns.addAll(globalSpawns);
        }
        allMobSpawns.addAll(this.mobSpawns);
        ArrayList<MobSpawn> viableMobSpawns = new ArrayList<MobSpawn>();
        for (MobSpawn possibleMobSpawn : allMobSpawns) {
            if (!possibleMobSpawn.canSpawn(world, blockCount, biomes, this.ignoreDimensions)) continue;
            viableMobSpawns.add(possibleMobSpawn);
        }
        return viableMobSpawns;
    }

    public MobSpawn chooseMobToSpawn(World world, List<MobSpawn> mobSpawns) {
        int totalWeights = 0;
        for (MobSpawn mobSpawn : mobSpawns) {
            totalWeights += mobSpawn.getWeight();
        }
        if (totalWeights <= 0) {
            return null;
        }
        int randomWeight = 1;
        if (totalWeights > 1) {
            randomWeight = world.field_73012_v.nextInt(totalWeights - 1) + 1;
        }
        int searchWeight = 0;
        MobSpawn chosenMobSpawn = null;
        Iterator<MobSpawn> iterator = mobSpawns.iterator();
        while (iterator.hasNext()) {
            MobSpawn mobSpawn;
            chosenMobSpawn = mobSpawn = iterator.next();
            if (mobSpawn.getWeight() + searchWeight > randomWeight) break;
            searchWeight += mobSpawn.getWeight();
        }
        return chosenMobSpawn;
    }

    public boolean mobInstanceSpawnCheck(EntityLiving entityLiving, MobSpawn mobSpawn, World world, EntityPlayer player, BlockPos spawnPos, int level, boolean forgeForced) {
        if (entityLiving instanceof EntityCreatureBase) {
            EntityCreatureBase entityCreature = (EntityCreatureBase)entityLiving;
            LycanitesMobs.printDebug("JSONSpawner", "Checking Mob Collision...");
            if (!this.ignoreCollision && !entityCreature.checkSpawnCollision(world, spawnPos)) {
                return false;
            }
            LycanitesMobs.printDebug("JSONSpawner", "Checking For Nearby Boss...");
            if (!entityCreature.checkSpawnBoss(world, spawnPos)) {
                return false;
            }
            if (mobSpawn.ignoreMobInstanceConditions) {
                LycanitesMobs.printDebug("JSONSpawner", "All Mob Instance Checks Ignored");
                return true;
            }
            if (!this.ignoreLightLevel && !mobSpawn.ignoreLightLevel) {
                LycanitesMobs.printDebug("JSONSpawner", "Checking Light Level...");
                if (!entityCreature.checkSpawnLightLevel(world, spawnPos)) {
                    return false;
                }
            }
            if (!this.ignoreGroupLimit && !mobSpawn.ignoreGroupLimit) {
                LycanitesMobs.printDebug("JSONSpawner", "Checking Group Limit...");
                if (!entityCreature.checkSpawnGroupLimit(world, spawnPos, this.groupLimitRange)) {
                    return false;
                }
            }
            return true;
        }
        if (!mobSpawn.ignoreMobInstanceConditions) {
            LycanitesMobs.printDebug("JSONSpawner", "None Lycanites Mobs Checks...");
            return entityLiving.func_70601_bi();
        }
        LycanitesMobs.printDebug("JSONSpawner", "All Mob Instance Checks Ignored");
        return true;
    }

    public void spawnEntity(World world, ExtendedWorld worldExt, EntityLiving entityLiving, int level, MobSpawn mobSpawn, EntityPlayer player, int chain) {
        MobEventPlayerServer mobEventPlayerServer;
        entityLiving.field_71088_bW = entityLiving.func_82147_ab();
        if (entityLiving instanceof EntityCreatureBase) {
            EntityCreatureBase entityCreature = (EntityCreatureBase)entityLiving;
            entityCreature.forceNoDespawn = this.forceNoDespawn;
            boolean bl = entityCreature.spawnedRare = level > 0;
            if (this.blockBreakRadius > -1 && chain == 0) {
                entityCreature.destroyArea((int)entityLiving.field_70165_t - 1, (int)entityLiving.field_70163_u, (int)entityLiving.field_70161_v, 100.0f, true, this.blockBreakRadius, (EntityPlayer)(this.chainSpawning ? player : null), chain + 1);
            }
            if (!"".equals(this.eventName) && worldExt != null && (mobEventPlayerServer = worldExt.getMobEventPlayerServer(this.eventName)) != null) {
                entityCreature.spawnEventType = mobEventPlayerServer.mobEvent.title;
                if (mobEventPlayerServer.mobEvent.name.equals(worldExt.getWorldEventName())) {
                    entityCreature.spawnEventCount = worldExt.getWorldEventCount();
                }
            }
        }
        world.func_72838_d((Entity)entityLiving);
        mobSpawn.onSpawned(entityLiving, player);
        if (!"".equals(this.eventName) && worldExt != null && (mobEventPlayerServer = worldExt.getMobEventPlayerServer(this.eventName)) != null) {
            MobEvent mobEvent = mobEventPlayerServer.mobEvent;
            mobEvent.onSpawn(entityLiving, mobEventPlayerServer.world, mobEventPlayerServer.player, mobEventPlayerServer.origin, mobEventPlayerServer.level, mobEventPlayerServer.ticks);
        }
    }
}

