/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.renderer;

import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.renderer.LayerBase;
import com.lycanitesmobs.core.renderer.RenderCreature;
import javax.vecmath.Vector4f;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class LayerEffect
extends LayerBase {
    public String textureSuffix = "effect";
    public boolean glow = false;
    public boolean additive = false;
    public boolean subspecies = true;

    public LayerEffect(RenderCreature renderer, String textureSuffix) {
        super(renderer);
        this.name = textureSuffix;
        this.textureSuffix = textureSuffix;
    }

    public LayerEffect(RenderCreature renderer, String textureSuffix, boolean glow, boolean additive, boolean subspecies) {
        super(renderer);
        this.name = textureSuffix;
        this.textureSuffix = textureSuffix;
        this.glow = glow;
        this.additive = additive;
        this.subspecies = subspecies;
    }

    @Override
    public Vector4f getPartColor(String partName, EntityCreatureBase entity, boolean trophy) {
        return new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public ResourceLocation getLayerTexture(EntityCreatureBase entity) {
        return entity.getTexture(this.textureSuffix);
    }

    @Override
    public void onRenderStart(String partName, Entity entity, boolean trophy) {
        if (this.glow) {
            int i = 0xF000F0;
            int j = i % 65536;
            int k = i / 65536;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)j, (float)k);
        }
        GL11.glEnable((int)3042);
        if (this.additive) {
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        }
    }

    @Override
    public void onRenderFinish(String partName, Entity entity, boolean trophy) {
        if (this.glow) {
            int i = entity.func_70070_b();
            int j = i % 65536;
            int k = i / 65536;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)j, (float)k);
        }
        GL11.glDisable((int)3042);
    }
}

