/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.network;

import com.lycanitesmobs.core.tileentity.TileEntityBase;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class MessageTileEntityButton
implements IMessage,
IMessageHandler<MessageTileEntityButton, IMessage> {
    public byte buttonId;
    public BlockPos tileEntityPos;

    public MessageTileEntityButton() {
    }

    public MessageTileEntityButton(byte buttonId, BlockPos tileEntityPos) {
        this.buttonId = buttonId;
        this.tileEntityPos = tileEntityPos;
    }

    public IMessage onMessage(MessageTileEntityButton message, MessageContext ctx) {
        if (ctx.side != Side.SERVER) {
            return null;
        }
        World world = ctx.getServerHandler().field_147369_b.func_130014_f_();
        if (world == null) {
            return null;
        }
        WorldServer mainThread = (WorldServer)world;
        mainThread.func_152344_a(() -> {
            TileEntity tileEntity = world.func_175625_s(message.tileEntityPos);
            if (!(tileEntity instanceof TileEntityBase)) {
                return;
            }
            TileEntityBase tileEntityBase = (TileEntityBase)tileEntity;
            tileEntityBase.onGuiButton(message.buttonId);
        });
        return null;
    }

    public void fromBytes(ByteBuf buf) {
        PacketBuffer packet = new PacketBuffer(buf);
        this.buttonId = packet.readByte();
        this.tileEntityPos = new BlockPos(packet.readInt(), packet.readInt(), packet.readInt());
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer packet = new PacketBuffer(buf);
        packet.writeByte((int)this.buttonId);
        packet.writeInt(this.tileEntityPos.func_177958_n());
        packet.writeInt(this.tileEntityPos.func_177956_o());
        packet.writeInt(this.tileEntityPos.func_177952_p());
    }
}

