/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.mods;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureManager;
import java.lang.reflect.Method;
import net.minecraftforge.fml.common.Loader;

public class DLDungeons {
    public static void init() {
        if (!Loader.isModLoaded((String)"DLDungeonsJBG") && !Loader.isModLoaded((String)"dldungeonsjbg")) {
            return;
        }
        LycanitesMobs.printInfo("", "Doomlike Dungeons Mod Detected...");
        Class<?> dlDungeonsAPI = null;
        Method isLoaded = null;
        try {
            dlDungeonsAPI = Class.forName("jaredbgreat.dldungeons.api.DLDungeonsAPI");
            isLoaded = dlDungeonsAPI.getMethod("isLoaded", new Class[0]);
        }
        catch (Exception e) {
            LycanitesMobs.printWarning("", "Unable to find DLDungeons API Class/Method via reflection:");
            e.printStackTrace();
        }
        if (dlDungeonsAPI == null || isLoaded == null) {
            return;
        }
        try {
            if (((Boolean)isLoaded.invoke(null, new Object[0])).booleanValue()) {
                CreatureManager.getInstance().dlDungeonsLoaded = true;
            }
        }
        catch (Exception e) {
            LycanitesMobs.printWarning("", "Unable to invoke DLDungeons API method isLoaded():");
            e.printStackTrace();
        }
    }

    public static void addMob(CreatureInfo creatureInfo) {
        String mobName = creatureInfo.getEntityId();
        String themes = creatureInfo.group.dungeonThemes;
        if (!"".equalsIgnoreCase(themes) && creatureInfo.dungeonLevel > 0) {
            try {
                Class<?> dlDungeonsAPI = Class.forName("jaredbgreat.dldungeons.api.DLDungeonsAPI");
                Method addMob = dlDungeonsAPI.getMethod("addMob", String.class, Integer.TYPE, String[].class);
                addMob.invoke(null, mobName, creatureInfo.dungeonLevel, themes.split(","));
                LycanitesMobs.printDebug("MobSetup", "[DLDungeons] Added " + mobName + " with the level: " + creatureInfo.dungeonLevel + " and themes: " + themes);
            }
            catch (Exception e) {
                LycanitesMobs.printWarning("", "Unable to add " + mobName + " to DLDungeons API:");
            }
        }
    }
}

