/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.modelloader.obj;

import com.lycanitesmobs.core.modelloader.obj.IndexedModel;
import com.lycanitesmobs.core.modelloader.obj.Mesh;
import com.lycanitesmobs.core.modelloader.obj.OBJLoader;
import com.lycanitesmobs.core.modelloader.obj.ObjEvent;
import com.lycanitesmobs.core.modelloader.obj.ObjModel;
import com.lycanitesmobs.core.modelloader.obj.ObjObject;
import com.lycanitesmobs.core.modelloader.obj.TessellatorModelEvent;
import com.lycanitesmobs.core.modelloader.obj.Vertex;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventBus;
import org.lwjgl.opengl.GL11;

public class TessellatorModel
extends ObjModel {
    public static final EventBus MODEL_RENDERING_BUS = new EventBus();

    public TessellatorModel(ResourceLocation resourceLocation) {
        super(resourceLocation.func_110623_a());
        String path = resourceLocation.toString();
        try {
            InputStream inputStream = Minecraft.func_71410_x().func_110442_L().func_110536_a(resourceLocation).func_110527_b();
            String content = new String(this.read(inputStream), "UTF-8");
            String startPath = path.substring(0, path.lastIndexOf(47) + 1);
            HashMap<ObjObject, IndexedModel> map = new OBJLoader().loadModel(startPath, content);
            this.objObjects.clear();
            Set<ObjObject> keys = map.keySet();
            for (ObjObject object : keys) {
                Mesh mesh;
                object.mesh = mesh = new Mesh();
                this.objObjects.add(object);
                map.get(object).toMesh(mesh);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void renderImpl() {
        Collections.sort(this.objObjects, (a, b) -> {
            Vec3d v = Minecraft.func_71410_x().func_175606_aa().func_174791_d();
            double aDist = v.func_72438_d(new Vec3d((double)a.center.x, (double)a.center.y, (double)a.center.z));
            double bDist = v.func_72438_d(new Vec3d((double)b.center.x, (double)b.center.y, (double)b.center.z));
            return Double.compare(aDist, bDist);
        });
        for (ObjObject object : this.objObjects) {
            this.renderGroup(object);
        }
    }

    @Override
    public void renderGroupsImpl(String group) {
        for (ObjObject object : this.objObjects) {
            if (!object.getName().equals(group)) continue;
            this.renderGroup(object);
        }
    }

    @Override
    public void renderGroupImpl(ObjObject obj, Vector4f color, Vector2f textureOffset) {
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tess.func_178180_c();
        if (obj.mesh == null) {
            return;
        }
        int[] indices = obj.mesh.indices;
        Vertex[] vertices = obj.mesh.vertices;
        if (obj.mesh.normals == null) {
            obj.mesh.normals = new Vector3f[indices.length];
        }
        vertexBuffer.func_181668_a(4, DefaultVertexFormats.field_181712_l);
        for (int i = 0; i < indices.length; i += 3) {
            Vector3f normal = obj.mesh.normals[i];
            if (normal == null) {
                obj.mesh.normals[i] = normal = this.getNormal(vertices[indices[i]].getPos(), vertices[indices[i + 1]].getPos(), vertices[indices[i + 2]].getPos());
            }
            for (int iv = 0; iv < 3; ++iv) {
                Vertex v = vertices[indices[i + iv]];
                vertexBuffer.func_181662_b((double)v.getPos().x, (double)v.getPos().y, (double)v.getPos().z).func_187315_a((double)(v.getTexCoords().x + textureOffset.getX() * 0.01f), (double)(1.0f - (v.getTexCoords().y + textureOffset.getY() * 0.01f))).func_181666_a(color.x, color.y, color.z, color.w).func_181663_c(normal.x, normal.y, normal.z).func_181675_d();
            }
        }
        tess.func_78381_a();
        GL11.glDisable((int)3042);
    }

    public Vector3f getNormal(Vector3f p1, Vector3f p2, Vector3f p3) {
        Vector3f output = new Vector3f();
        Vector3f calU = new Vector3f(p2.x - p1.x, p2.y - p1.y, p2.z - p1.z);
        Vector3f calV = new Vector3f(p3.x - p1.x, p3.y - p1.y, p3.z - p1.z);
        output.x = calU.y * calV.z - calU.z * calV.y;
        output.y = calU.z * calV.x - calU.x * calV.z;
        output.z = calU.x * calV.y - calU.y * calV.x;
        output.normalize();
        return output;
    }

    @Override
    public boolean fireEvent(ObjEvent event) {
        TessellatorModelEvent evt = null;
        if (event.type == ObjEvent.EventType.PRE_RENDER_GROUP) {
            evt = new TessellatorModelEvent.RenderGroupEvent.Pre(((ObjObject)event.data[1]).getName(), this);
        } else if (event.type == ObjEvent.EventType.POST_RENDER_GROUP) {
            evt = new TessellatorModelEvent.RenderGroupEvent.Post(((ObjObject)event.data[1]).getName(), this);
        } else if (event.type == ObjEvent.EventType.PRE_RENDER_ALL) {
            evt = new TessellatorModelEvent.RenderPre(this);
        } else if (event.type == ObjEvent.EventType.POST_RENDER_ALL) {
            evt = new TessellatorModelEvent.RenderPost(this);
        }
        if (evt != null) {
            return !MODEL_RENDERING_BUS.post((Event)evt);
        }
        return true;
    }
}

