/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.modelloader.obj;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.modelloader.obj.Material;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector3f;

public class MtlMaterialLib {
    public static final String COMMENT = "#";
    public static final String NEW_MATERIAL = "newmtl";
    public static final String AMBIENT_COLOR = "Ka";
    public static final String DIFFUSE_COLOR = "Kd";
    public static final String SPECULAR_COLOR = "Ks";
    public static final String TRANSPARENCY_D = "d";
    public static final String TRANSPARENCY_TR = "Tr";
    public static final String ILLUMINATION = "illum";
    public static final String TEXTURE_AMBIENT = "map_Ka";
    public static final String TEXTURE_DIFFUSE = "map_Kd";
    public static final String TEXTURE_SPECULAR = "map_Ks";
    public static final String TEXTURE_TRANSPARENCY = "map_d";
    private ArrayList<Material> materials;
    private String path;
    private String startPath;

    public MtlMaterialLib(String path) {
        this.path = path;
        this.startPath = path.substring(0, path.lastIndexOf(47) + 1);
        this.materials = new ArrayList();
    }

    public void parse(String content) {
        String[] lines = content.split("\n");
        Material current = null;
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i].trim();
            String[] parts = line.split(" ");
            if (parts[0].equals(COMMENT)) continue;
            if (parts[0].equals(NEW_MATERIAL)) {
                Material material = new Material(parts[1]);
                this.materials.add(material);
                current = material;
                continue;
            }
            if (parts[0].equals(AMBIENT_COLOR)) {
                current.ambientColor = new Vector3f(Float.parseFloat(parts[1]), Float.parseFloat(parts[2]), Float.parseFloat(parts[3]));
                continue;
            }
            if (parts[0].equals(DIFFUSE_COLOR)) {
                current.diffuseColor = new Vector3f(Float.parseFloat(parts[1]), Float.parseFloat(parts[2]), Float.parseFloat(parts[3]));
                continue;
            }
            if (parts[0].equals(TEXTURE_DIFFUSE)) {
                current.diffuseTexture = this.loadTexture(this.startPath + parts[1]);
                continue;
            }
            if (parts[0].equals(TEXTURE_AMBIENT)) {
                current.ambientTexture = this.loadTexture(this.startPath + parts[1]);
                continue;
            }
            if (!parts[0].equals(TRANSPARENCY_D) && !parts[0].equals(TRANSPARENCY_TR)) continue;
            current.transparency = (float)Double.parseDouble(parts[1]);
        }
    }

    private int loadTexture(String string) {
        try {
            string = string.replace("models/", "textures/");
            ResourceLocation resourceLocation = new ResourceLocation(string);
            InputStream inputStream = Minecraft.func_71410_x().func_110442_L().func_110536_a(resourceLocation).func_110527_b();
            return MtlMaterialLib.loadTexture(ImageIO.read(inputStream));
        }
        catch (IOException e) {
            LycanitesMobs.printWarning("", "Unable to load a texture from the obj material file.");
            e.printStackTrace();
            return 0;
        }
    }

    public static ByteBuffer imageToByteBuffer(BufferedImage img) {
        int[] pixels = img.getRGB(0, 0, img.getWidth(), img.getHeight(), null, 0, img.getWidth());
        int bufLen = pixels.length * 4;
        ByteBuffer oglPixelBuf = BufferUtils.createByteBuffer((int)bufLen);
        for (int y = 0; y < img.getHeight(); ++y) {
            for (int x = 0; x < img.getWidth(); ++x) {
                int rgb = pixels[y * img.getWidth() + x];
                float a = (float)(rgb >> 24 & 0xFF) / 255.0f;
                float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
                float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
                float b = (float)(rgb >> 0 & 0xFF) / 255.0f;
                oglPixelBuf.put((byte)(r * 255.0f));
                oglPixelBuf.put((byte)(g * 255.0f));
                oglPixelBuf.put((byte)(b * 255.0f));
                oglPixelBuf.put((byte)(a * 255.0f));
            }
        }
        oglPixelBuf.flip();
        return oglPixelBuf;
    }

    public static int loadTexture(BufferedImage img) {
        ByteBuffer oglPixelBuf = MtlMaterialLib.imageToByteBuffer(img);
        int id = GL11.glGenTextures();
        int target = 3553;
        GL11.glBindTexture((int)target, (int)id);
        GL11.glTexParameterf((int)target, (int)10241, (float)9728.0f);
        GL11.glTexParameterf((int)target, (int)10240, (float)9728.0f);
        GL11.glTexEnvf((int)8960, (int)8704, (float)8448.0f);
        GL11.glTexParameteri((int)target, (int)33084, (int)0);
        GL11.glTexParameteri((int)target, (int)33085, (int)0);
        GL11.glTexImage2D((int)target, (int)0, (int)32856, (int)img.getWidth(), (int)img.getHeight(), (int)0, (int)6408, (int)5121, (ByteBuffer)oglPixelBuf);
        GL11.glBindTexture((int)target, (int)0);
        return id;
    }

    public List<Material> getMaterials() {
        return this.materials;
    }
}

