/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.model;

import com.lycanitesmobs.core.model.Animator;
import com.lycanitesmobs.core.model.ModelObjAnimationFrame;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModelObjPart {
    public String name;
    public ModelObjPart parent;
    public String parentName;
    public Map<String, ModelObjPart> children = new HashMap<String, ModelObjPart>();
    public float centerX;
    public float centerY;
    public float centerZ;
    public List<ModelObjAnimationFrame> animationFrames = new ArrayList<ModelObjAnimationFrame>();

    public ModelObjPart(String partName, String parentName, float centerX, float centerY, float centerZ) {
        this.name = partName;
        this.parentName = parentName;
        this.centerX = centerX;
        this.centerY = centerY;
        this.centerZ = centerZ;
    }

    public void addChildren(ModelObjPart[] parts) {
        for (ModelObjPart part : parts) {
            if (part == null || part == this || part.parentName == null || this.children.containsKey(part.parentName) || !this.name.equals(part.parentName)) continue;
            this.children.put(part.name, part);
            part.parent = this;
        }
    }

    public void addAnimationFrame(ModelObjAnimationFrame frame) {
        this.animationFrames.add(frame);
    }

    public void applyAnimationFrames(Animator animator) {
        if (this.parent != null) {
            this.parent.applyAnimationFrames(animator);
        }
        animator.doTranslate(this.centerX, this.centerY, this.centerZ);
        for (ModelObjAnimationFrame animationFrame : this.animationFrames) {
            animationFrame.apply(animator);
        }
        animator.doTranslate(-this.centerX, -this.centerY, -this.centerZ);
    }
}

