/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.info.GroupInfo;
import com.lycanitesmobs.core.model.Animator;
import com.lycanitesmobs.core.model.ModelCustom;
import com.lycanitesmobs.core.model.ModelObjAnimationFrame;
import com.lycanitesmobs.core.model.ModelObjPart;
import com.lycanitesmobs.core.model.ModelObjState;
import com.lycanitesmobs.core.modelloader.obj.ObjObject;
import com.lycanitesmobs.core.modelloader.obj.TessellatorModel;
import com.lycanitesmobs.core.renderer.LayerBase;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;

@SideOnly(value=Side.CLIENT)
public class ModelObj
extends ModelCustom {
    public static float modelXRotOffset = 180.0f;
    public static float modelYPosOffset = -1.5f;
    public TessellatorModel wavefrontObject;
    public List<ObjObject> wavefrontParts;
    public Map<String, ModelObjPart> animationParts = new HashMap<String, ModelObjPart>();
    public float lookHeadScaleX = 1.0f;
    public float lookHeadScaleY = 1.0f;
    public float lookNeckScaleX = 0.0f;
    public float lookNeckScaleY = 0.0f;
    public float lookBodyScaleX = 0.0f;
    public float lookBodyScaleY = 0.0f;
    public boolean bigChildHead = false;
    public boolean bodyIsTrophy = true;
    public float trophyScale = 1.0f;
    public float[] trophyOffset = new float[0];
    public float[] trophyMouthOffset = new float[0];
    public boolean dontColor = false;
    protected Animator animator;
    protected ModelObjPart currentAnimationPart;
    protected Map<Entity, ModelObjState> modelStates = new HashMap<Entity, ModelObjState>();
    protected ModelObjState currentModelState;

    public ModelObj() {
        this(1.0f);
    }

    public ModelObj(float shadowSize) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelObj initModel(String name, GroupInfo groupInfo, String path) {
        this.wavefrontObject = new TessellatorModel(new ResourceLocation(groupInfo.filename, "models/" + path + ".obj"));
        this.wavefrontParts = this.wavefrontObject.objObjects;
        if (this.wavefrontParts.isEmpty()) {
            LycanitesMobs.printWarning("", "Unable to load any parts for the " + name + " model!");
        }
        this.animator = new Animator();
        ResourceLocation animPartsLoc = new ResourceLocation(groupInfo.filename, "models/" + path + "_parts.json");
        try {
            Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
            InputStream in = Minecraft.func_71410_x().func_110442_L().func_110536_a(animPartsLoc).func_110527_b();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            try {
                JsonArray jsonArray = (JsonArray)JsonUtils.func_193839_a((Gson)gson, (Reader)reader, JsonArray.class);
                Iterator jsonIterator = jsonArray.iterator();
                while (jsonIterator.hasNext()) {
                    JsonObject partJson = ((JsonElement)jsonIterator.next()).getAsJsonObject();
                    String partName = partJson.get("name").getAsString();
                    String partParentName = partJson.get("parent").getAsString();
                    if (partParentName.isEmpty()) {
                        partParentName = null;
                    }
                    float partCenterX = Float.parseFloat(partJson.get("centerX").getAsString());
                    float partCenterY = Float.parseFloat(partJson.get("centerY").getAsString());
                    float partCenterZ = Float.parseFloat(partJson.get("centerZ").getAsString());
                    this.addAnimationPart(partName, partParentName, partCenterX, partCenterY, partCenterZ);
                }
            }
            finally {
                IOUtils.closeQuietly((Reader)reader);
            }
        }
        catch (Exception e) {
            LycanitesMobs.printWarning("", "There was a problem loading animation parts for " + name + ":");
            e.printStackTrace();
        }
        for (ModelObjPart part : this.animationParts.values()) {
            part.addChildren(this.animationParts.values().toArray(new ModelObjPart[this.animationParts.size()]));
        }
        return this;
    }

    public void addAnimationPart(String partName, String parentName, float centerX, float centerY, float centerZ) {
        if (this.animationParts.containsKey(partName = partName.toLowerCase())) {
            LycanitesMobs.printWarning("", "Tried to add an animation part that already exists: " + partName + ".");
            return;
        }
        if (parentName != null && (parentName = parentName.toLowerCase()).equals(partName)) {
            parentName = null;
        }
        ModelObjPart animationPart = new ModelObjPart(partName, parentName, centerX, centerY, centerZ);
        this.animationParts.put(partName, animationPart);
    }

    @Override
    public void render(Entity entity, float time, float distance, float loop, float lookY, float lookX, float scale, LayerBase layer) {
        String partName;
        if (!(entity instanceof EntityLiving)) {
            return;
        }
        boolean renderAsTrophy = false;
        if (scale < 0.0f) {
            renderAsTrophy = true;
            scale = -scale;
        } else {
            scale *= 16.0f;
            if (entity instanceof EntityCreatureBase) {
                scale = (float)((double)scale * ((EntityCreatureBase)entity).getRenderScale());
            }
        }
        this.currentModelState = this.getModelState(entity);
        this.updateAttackProgress(entity);
        for (ObjObject part : this.wavefrontParts) {
            partName = part.getName().toLowerCase();
            this.currentAnimationPart = this.animationParts.get(partName);
            if (this.currentAnimationPart == null) continue;
            this.animatePart(partName, (EntityLiving)entity, time, distance, loop, -lookY, lookX, scale);
            if (!renderAsTrophy) continue;
            if (partName.contains("head")) {
                if (!partName.contains("left")) {
                    this.translate(-0.3f, 0.0f, 0.0f);
                    this.angle(5.0f, 0.0f, 1.0f, 0.0f);
                }
                if (!partName.contains("right")) {
                    this.translate(0.3f, 0.0f, 0.0f);
                    this.angle(-5.0f, 0.0f, 1.0f, 0.0f);
                }
            }
            if (this.trophyOffset.length < 3) continue;
            this.translate(this.trophyOffset[0], this.trophyOffset[1], this.trophyOffset[2]);
        }
        for (ObjObject part : this.wavefrontParts) {
            partName = part.getName().toLowerCase();
            if (!this.canRenderPart(partName, entity, layer, renderAsTrophy)) continue;
            this.currentAnimationPart = this.animationParts.get(partName);
            if (this.currentAnimationPart == null) continue;
            GlStateManager.func_179094_E();
            GlStateManager.func_179141_d();
            this.animator.doAngle(modelXRotOffset, 1.0f, 0.0f, 0.0f);
            this.animator.doTranslate(0.0f, modelYPosOffset, 0.0f);
            if (this.field_78091_s && !renderAsTrophy) {
                this.childScale(partName);
                if (this.bigChildHead && (partName.equals("head") || partName.equals("mouth"))) {
                    this.translate(-(this.currentAnimationPart.centerX / 2.0f), -(this.currentAnimationPart.centerY / 2.0f), -(this.currentAnimationPart.centerZ / 2.0f));
                }
            }
            if (renderAsTrophy) {
                this.animator.doScale(this.trophyScale, this.trophyScale, this.trophyScale);
            }
            this.animator.doScale(scale, scale, scale);
            this.currentAnimationPart.applyAnimationFrames(this.animator);
            this.onRenderStart(layer, partName, entity, renderAsTrophy);
            this.wavefrontObject.renderGroup(part, this.getPartColor(partName, entity, layer, renderAsTrophy, loop), this.getPartTextureOffset(partName, entity, layer, renderAsTrophy, loop));
            this.onRenderFinish(layer, partName, entity, renderAsTrophy);
            GlStateManager.func_179121_F();
        }
        for (ModelObjPart animationPart : this.animationParts.values()) {
            animationPart.animationFrames.clear();
        }
    }

    public void onRenderStart(LayerBase layer, String partName, Entity entity, boolean renderAsTrophy) {
        if (layer != null) {
            layer.onRenderStart(partName, entity, renderAsTrophy);
        }
    }

    public void onRenderFinish(LayerBase layer, String partName, Entity entity, boolean renderAsTrophy) {
        if (layer != null) {
            layer.onRenderFinish(partName, entity, renderAsTrophy);
        }
    }

    @Override
    public boolean canRenderPart(String partName, Entity entity, LayerBase layer, boolean trophy) {
        if (partName == null) {
            return false;
        }
        if (!this.animationParts.containsKey(partName = partName.toLowerCase())) {
            return false;
        }
        if (trophy && !this.isTrophyPart(partName)) {
            return false;
        }
        return super.canRenderPart(partName, entity, layer, trophy);
    }

    public boolean isTrophyPart(String partName) {
        if (partName == null) {
            return false;
        }
        if ((partName = partName.toLowerCase()).contains("head") || partName.contains("mouth") || partName.contains("eye")) {
            return true;
        }
        return this.bodyIsTrophy && partName.contains("body");
    }

    public void animatePart(String partName, EntityLiving entity, float time, float distance, float loop, float lookY, float lookX, float scale) {
        float rotX = 0.0f;
        float rotY = 0.0f;
        float rotZ = 0.0f;
        if (partName.toLowerCase().equals("head")) {
            rotX = (float)((double)rotX + Math.toDegrees(lookX / 57.295776f) * (double)this.lookHeadScaleX);
            rotY = (float)((double)rotY + Math.toDegrees(lookY / 57.295776f) * (double)this.lookHeadScaleY);
        }
        if (partName.equals("neck")) {
            rotX = (float)((double)rotX + Math.toDegrees(lookX / 57.295776f) * (double)this.lookNeckScaleX);
            rotY = (float)((double)rotY + Math.toDegrees(lookY / 57.295776f) * (double)this.lookNeckScaleY);
        }
        this.rotate(rotX, rotY, rotZ);
    }

    public ModelObjState getModelState(Entity entity) {
        if (entity == null) {
            return null;
        }
        if (this.modelStates.containsKey(entity)) {
            if (entity.field_70128_L) {
                this.modelStates.remove(entity);
                return null;
            }
            return this.modelStates.get(entity);
        }
        ModelObjState modelState = new ModelObjState(entity);
        this.modelStates.put(entity, modelState);
        return modelState;
    }

    public void childScale(String partName) {
        this.animator.doScale(0.5f, 0.5f, 0.5f);
    }

    public void updateAttackProgress(Entity entity) {
        if (this.currentModelState == null || !(entity instanceof EntityCreatureBase)) {
            return;
        }
        EntityCreatureBase entityCreature = (EntityCreatureBase)entity;
        if (this.currentModelState.attackAnimationPlaying) {
            if (this.currentModelState.attackAnimationIncreasing) {
                this.currentModelState.attackAnimationProgress = Math.min(this.currentModelState.attackAnimationProgress + this.currentModelState.attackAnimationSpeed, 1.0f);
                if (this.currentModelState.attackAnimationProgress >= 1.0f) {
                    this.currentModelState.attackAnimationIncreasing = false;
                }
            } else {
                this.currentModelState.attackAnimationProgress = Math.max(this.currentModelState.attackAnimationProgress - this.currentModelState.attackAnimationSpeed, 0.0f);
                if (this.currentModelState.attackAnimationProgress <= 0.0f) {
                    this.currentModelState.attackAnimationPlaying = false;
                }
            }
        } else if (entityCreature.justAttacked()) {
            this.currentModelState.attackAnimationPlaying = true;
            this.currentModelState.attackAnimationIncreasing = true;
            this.currentModelState.attackAnimationProgress = 0.0f;
        }
    }

    public float getAttackProgress() {
        if (this.currentModelState == null) {
            return 0.0f;
        }
        return this.currentModelState.attackAnimationProgress;
    }

    public void angle(float rotation, float angleX, float angleY, float angleZ) {
        this.currentAnimationPart.addAnimationFrame(new ModelObjAnimationFrame("angle", rotation, angleX, angleY, angleZ));
    }

    public void rotate(float rotX, float rotY, float rotZ) {
        this.currentAnimationPart.addAnimationFrame(new ModelObjAnimationFrame("rotate", 1.0f, rotX, rotY, rotZ));
    }

    public void translate(float posX, float posY, float posZ) {
        this.currentAnimationPart.addAnimationFrame(new ModelObjAnimationFrame("translate", 1.0f, posX, posY, posZ));
    }

    public void scale(float scaleX, float scaleY, float scaleZ) {
        this.currentAnimationPart.addAnimationFrame(new ModelObjAnimationFrame("scale", 1.0f, scaleX, scaleY, scaleZ));
    }

    public double rotateToPoint(double aTarget, double bTarget) {
        return this.rotateToPoint(0.0, 0.0, aTarget, bTarget);
    }

    public double rotateToPoint(double aCenter, double bCenter, double aTarget, double bTarget) {
        if (aTarget - aCenter == 0.0) {
            if (aTarget > aCenter) {
                return 0.0;
            }
            if (aTarget < aCenter) {
                return 180.0;
            }
        }
        if (bTarget - bCenter == 0.0) {
            if (bTarget > bCenter) {
                return 90.0;
            }
            if (bTarget < bCenter) {
                return -90.0;
            }
        }
        if (aTarget - aCenter == 0.0 && bTarget - bCenter == 0.0) {
            return 0.0;
        }
        return Math.toDegrees(Math.atan2(aCenter - aTarget, bCenter - bTarget) - 1.5707963267948966);
    }

    public double[] rotateToPoint(double xCenter, double yCenter, double zCenter, double xTarget, double yTarget, double zTarget) {
        double[] rotations = new double[]{this.rotateToPoint(yCenter, -zCenter, yTarget, -zTarget), this.rotateToPoint(-zCenter, xCenter, -zTarget, xTarget), this.rotateToPoint(yCenter, xCenter, yTarget, xTarget)};
        return rotations;
    }
}

