/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.info.GroupInfo;
import com.lycanitesmobs.core.model.Animator;
import com.lycanitesmobs.core.model.ModelObjAnimationFrame;
import com.lycanitesmobs.core.model.ModelObjPart;
import com.lycanitesmobs.core.model.ModelObjState;
import com.lycanitesmobs.core.modelloader.obj.ObjObject;
import com.lycanitesmobs.core.modelloader.obj.TessellatorModel;
import com.lycanitesmobs.core.renderer.IItemModelRenderer;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.lwjgl.opengl.GL11;

public abstract class ModelItemBase {
    public static float modelXRotOffset = 180.0f;
    public static float modelYPosOffset = -1.5f;
    public TessellatorModel wavefrontObject;
    public List<ObjObject> wavefrontParts;
    public Map<String, ModelObjPart> animationParts = new HashMap<String, ModelObjPart>();
    protected Animator animator;
    protected ModelObjPart currentAnimationPart;
    protected Map<ItemStack, ModelObjState> modelStates = new HashMap<ItemStack, ModelObjState>();
    protected ModelObjState currentModelState;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelItemBase initModel(String name, GroupInfo groupInfo, String path) {
        this.wavefrontObject = new TessellatorModel(new ResourceLocation(groupInfo.filename, "models/" + path + ".obj"));
        this.wavefrontParts = this.wavefrontObject.objObjects;
        if (this.wavefrontParts.isEmpty()) {
            LycanitesMobs.printWarning("", "Unable to load any parts for the " + name + " model!");
        }
        this.animator = new Animator();
        ResourceLocation animPartsLoc = new ResourceLocation(groupInfo.filename, "models/" + path + "_parts.json");
        try {
            Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
            InputStream in = Minecraft.func_71410_x().func_110442_L().func_110536_a(animPartsLoc).func_110527_b();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            try {
                JsonArray jsonArray = (JsonArray)JsonUtils.func_193839_a((Gson)gson, (Reader)reader, JsonArray.class);
                Iterator jsonIterator = jsonArray.iterator();
                while (jsonIterator.hasNext()) {
                    JsonObject partJson = ((JsonElement)jsonIterator.next()).getAsJsonObject();
                    String partName = partJson.get("name").getAsString();
                    String partParentName = partJson.get("parent").getAsString();
                    if (partParentName.isEmpty()) {
                        partParentName = null;
                    }
                    float partCenterX = Float.parseFloat(partJson.get("centerX").getAsString());
                    float partCenterY = Float.parseFloat(partJson.get("centerY").getAsString());
                    float partCenterZ = Float.parseFloat(partJson.get("centerZ").getAsString());
                    this.addAnimationPart(partName, partParentName, partCenterX, partCenterY, partCenterZ);
                }
            }
            finally {
                IOUtils.closeQuietly((Reader)reader);
            }
        }
        catch (Exception e) {
            LycanitesMobs.printWarning("", "There was a problem loading animation parts for " + name + ":");
            e.printStackTrace();
        }
        for (ModelObjPart part : this.animationParts.values()) {
            part.addChildren(this.animationParts.values().toArray(new ModelObjPart[this.animationParts.size()]));
        }
        return this;
    }

    public void addAnimationPart(String partName, String parentName, float centerX, float centerY, float centerZ) {
        if (this.animationParts.containsKey(partName = partName.toLowerCase())) {
            LycanitesMobs.printWarning("", "Tried to add an animation part that already exists: " + partName + ".");
            return;
        }
        if (parentName != null && (parentName = parentName.toLowerCase()).equals(partName)) {
            parentName = null;
        }
        ModelObjPart animationPart = new ModelObjPart(partName, parentName, centerX, centerY, centerZ);
        this.animationParts.put(partName, animationPart);
    }

    public void render(ItemStack itemStack, EnumHand hand, IItemModelRenderer renderer) {
        String partName;
        if (itemStack == null) {
            return;
        }
        float loop = 0.0f;
        renderer.bindItemTexture(this.getTexture(itemStack));
        for (ObjObject part : this.wavefrontParts) {
            partName = part.getName().toLowerCase();
            if (!this.canRenderPart(partName, itemStack)) continue;
            this.currentAnimationPart = this.animationParts.get(partName);
            this.animatePart(partName, itemStack, loop);
            if (!"base".equals(partName)) continue;
            this.translate(0.9f, 1.0f, -0.5f);
            this.rotate(90.0f, -90.0f, 0.0f);
            this.scale(0.9f, 0.9f, 0.9f);
        }
        for (ObjObject part : this.wavefrontParts) {
            partName = part.getName().toLowerCase();
            if (!this.canRenderPart(partName, itemStack)) continue;
            this.currentAnimationPart = this.animationParts.get(partName);
            GlStateManager.func_179094_E();
            GlStateManager.func_179141_d();
            this.doAngle(modelXRotOffset, 1.0f, 0.0f, 0.0f);
            this.doTranslate(0.0f, modelYPosOffset, 0.0f);
            this.currentAnimationPart.applyAnimationFrames(this.animator);
            this.wavefrontObject.renderGroup(part, this.getPartColor(partName, itemStack), new Vector2f(0.0f, 0.0f));
            GlStateManager.func_179121_F();
        }
        for (ModelObjPart animationPart : this.animationParts.values()) {
            animationPart.animationFrames.clear();
        }
    }

    public boolean canRenderPart(String partName, ItemStack itemStack) {
        if (partName == null) {
            return false;
        }
        return this.animationParts.containsKey(partName = partName.toLowerCase());
    }

    public void animatePart(String partName, ItemStack itemStack, float loop) {
    }

    public ResourceLocation getTexture(ItemStack itemStack) {
        return null;
    }

    public Vector4f getPartColor(String partName, ItemStack itemStack) {
        return new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void doAngle(float rotation, float angleX, float angleY, float angleZ) {
        GL11.glRotatef((float)rotation, (float)angleX, (float)angleY, (float)angleZ);
    }

    public void doRotate(float rotX, float rotY, float rotZ) {
        GL11.glRotatef((float)rotX, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)rotY, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)rotZ, (float)0.0f, (float)0.0f, (float)1.0f);
    }

    public void doTranslate(float posX, float posY, float posZ) {
        GL11.glTranslatef((float)posX, (float)posY, (float)posZ);
    }

    public void doScale(float scaleX, float scaleY, float scaleZ) {
        GL11.glScalef((float)scaleX, (float)scaleY, (float)scaleZ);
    }

    public void angle(float rotation, float angleX, float angleY, float angleZ) {
        this.currentAnimationPart.addAnimationFrame(new ModelObjAnimationFrame("angle", rotation, angleX, angleY, angleZ));
    }

    public void rotate(float rotX, float rotY, float rotZ) {
        this.currentAnimationPart.addAnimationFrame(new ModelObjAnimationFrame("rotate", 1.0f, rotX, rotY, rotZ));
    }

    public void translate(float posX, float posY, float posZ) {
        this.currentAnimationPart.addAnimationFrame(new ModelObjAnimationFrame("translate", 1.0f, posX, posY, posZ));
    }

    public void scale(float scaleX, float scaleY, float scaleZ) {
        this.currentAnimationPart.addAnimationFrame(new ModelObjAnimationFrame("scale", 1.0f, scaleX, scaleY, scaleZ));
    }

    public double rotateToPoint(double aTarget, double bTarget) {
        return this.rotateToPoint(0.0, 0.0, aTarget, bTarget);
    }

    public double rotateToPoint(double aCenter, double bCenter, double aTarget, double bTarget) {
        if (aTarget - aCenter == 0.0) {
            if (aTarget > aCenter) {
                return 0.0;
            }
            if (aTarget < aCenter) {
                return 180.0;
            }
        }
        if (bTarget - bCenter == 0.0) {
            if (bTarget > bCenter) {
                return 90.0;
            }
            if (bTarget < bCenter) {
                return -90.0;
            }
        }
        if (aTarget - aCenter == 0.0 && bTarget - bCenter == 0.0) {
            return 0.0;
        }
        return Math.toDegrees(Math.atan2(aCenter - aTarget, bCenter - bTarget) - 1.5707963267948966);
    }

    public double[] rotateToPoint(double xCenter, double yCenter, double zCenter, double xTarget, double yTarget, double zTarget) {
        double[] rotations = new double[]{this.rotateToPoint(yCenter, -zCenter, yTarget, -zTarget), this.rotateToPoint(-zCenter, xCenter, -zTarget, xTarget), this.rotateToPoint(yCenter, xCenter, yTarget, xTarget)};
        return rotations;
    }
}

