/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.model;

import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.renderer.LayerBase;
import com.lycanitesmobs.core.renderer.LayerEquipment;
import com.lycanitesmobs.core.renderer.LayerSaddle;
import com.lycanitesmobs.core.renderer.RenderCreature;
import java.util.HashMap;
import java.util.Map;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector4f;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ModelCustom
extends ModelBase {
    public Map<ModelRenderer, float[]> initRotations = new HashMap<ModelRenderer, float[]>();

    public ModelCustom() {
        this(1.0f);
    }

    public ModelCustom(float shadowSize) {
        this.field_78090_t = 128;
        this.field_78089_u = 128;
    }

    public void addCustomLayers(RenderCreature renderer) {
        renderer.func_177094_a(new LayerEquipment(renderer, "chest"));
        renderer.func_177094_a(new LayerSaddle(renderer));
    }

    public void setRotation(ModelRenderer model, float x, float y, float z) {
        model.field_78795_f = x;
        model.field_78796_g = y;
        model.field_78808_h = z;
        if (!this.initRotations.containsKey(model)) {
            this.initRotations.put(model, new float[]{x, y, z});
        }
    }

    public void func_78088_a(Entity entity, float time, float distance, float loop, float lookY, float lookX, float scale) {
        this.render(entity, time, distance, loop, lookY, lookX, scale, null);
    }

    public void render(Entity entity, float time, float distance, float loop, float lookY, float lookX, float scale, LayerBase layer) {
        float sizeScale = 1.0f;
        if (entity instanceof EntityCreatureBase) {
            sizeScale = (float)((double)sizeScale * ((EntityCreatureBase)entity).getRenderScale());
        }
        GL11.glScalef((float)sizeScale, (float)sizeScale, (float)sizeScale);
        GL11.glTranslatef((float)0.0f, (float)(0.5f - sizeScale / 2.0f), (float)0.0f);
        this.setAngles((EntityLiving)entity, time, distance, loop, lookY, lookX, scale);
        this.animate((EntityLiving)entity, time, distance, loop, lookY, lookX, scale);
    }

    public boolean canRenderPart(String partName, Entity entity, LayerBase layer, boolean trophy) {
        if (layer == null) {
            return this.canBaseRenderPart(partName, entity, trophy);
        }
        if (entity instanceof EntityCreatureBase) {
            return layer.canRenderPart(partName, (EntityCreatureBase)entity, trophy);
        }
        return false;
    }

    public boolean canBaseRenderPart(String partName, Entity entity, boolean trophy) {
        return true;
    }

    public Vector4f getPartColor(String partName, Entity entity, LayerBase layer, boolean trophy, float loop) {
        if (layer == null || !(entity instanceof EntityCreatureBase)) {
            return this.getBasePartColor(partName, entity, trophy, loop);
        }
        return layer.getPartColor(partName, (EntityCreatureBase)entity, trophy);
    }

    public Vector4f getBasePartColor(String partName, Entity entity, boolean trophy, float loop) {
        return new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public Vector2f getPartTextureOffset(String partName, Entity entity, LayerBase layer, boolean trophy, float loop) {
        if (layer == null || !(entity instanceof EntityCreatureBase)) {
            return this.getBaseTextureOffset(partName, entity, trophy, loop);
        }
        return layer.getTextureOffset(partName, (EntityCreatureBase)entity, trophy, loop);
    }

    public Vector2f getBaseTextureOffset(String partName, Entity entity, boolean trophy, float loop) {
        return new Vector2f(0.0f, 0.0f);
    }

    public void setAngles(EntityLiving entity, float time, float distance, float loop, float lookY, float lookX, float scale) {
        for (Map.Entry<ModelRenderer, float[]> initRotation : this.initRotations.entrySet()) {
            float[] rotations = initRotation.getValue();
            this.setRotation(initRotation.getKey(), rotations[0], rotations[1], rotations[2]);
        }
    }

    public void animate(EntityLiving entity, float time, float distance, float loop, float lookY, float lookX, float scale) {
    }
}

