/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.item.equipment.features;

import com.google.gson.JsonObject;
import com.lycanitesmobs.core.item.equipment.features.EquipmentFeature;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.translation.I18n;

public class SummonEquipmentFeature
extends EquipmentFeature {
    public String summonMobId;
    public double summonChance = 0.05;
    public int summonDuration = 60;
    public int summonCountMin = 1;
    public int summonCountMax = 1;

    @Override
    public void loadFromJSON(JsonObject json) {
        this.summonMobId = json.get("summonMobId").getAsString();
        if (json.has("summonChance")) {
            this.summonChance = json.get("summonChance").getAsDouble();
        }
        if (json.has("summonDuration")) {
            this.summonDuration = json.get("summonDuration").getAsInt();
        }
        if (json.has("summonCountMin")) {
            this.summonCountMin = json.get("summonCountMin").getAsInt();
        }
        if (json.has("summonCountMax")) {
            this.summonCountMax = json.get("summonCountMax").getAsInt();
        }
        super.loadFromJSON(json);
    }

    @Override
    public String getDescription(ItemStack itemStack, int level) {
        if (!this.isActive(itemStack, level)) {
            return null;
        }
        String description = I18n.func_74838_a((String)("equipment.feature." + this.featureType)) + " " + I18n.func_74838_a((String)("entity." + this.summonMobId + ".name"));
        description = description + "\n" + I18n.func_74838_a((String)"equipment.feature.summon.chance") + " " + Math.round(this.summonChance * 100.0) + "%";
        if (this.summonDuration > 0) {
            description = description + "\n" + I18n.func_74838_a((String)"equipment.feature.effect.duration") + " " + (float)this.summonDuration / 20.0f;
        }
        description = this.summonCountMin != this.summonCountMax ? description + "\n" + I18n.func_74838_a((String)"equipment.feature.summon.count") + " " + this.summonCountMin + " - " + this.summonCountMax : description + "\n" + I18n.func_74838_a((String)"equipment.feature.summon.count") + " " + this.summonCountMax;
        return description;
    }
}

