/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.item.equipment.features;

import com.google.gson.JsonObject;
import com.lycanitesmobs.core.helpers.JSONHelper;
import com.lycanitesmobs.core.item.equipment.features.EquipmentFeature;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.translation.I18n;

public class HarvestEquipmentFeature
extends EquipmentFeature {
    public String harvestType;
    public String harvestShape = "block";
    public Vec3i harvestRange = new Vec3i(0, 0, 0);
    public double harvestRangeLevelMultiplier = 1.0;

    @Override
    public void loadFromJSON(JsonObject json) {
        this.harvestType = json.get("harvestType").getAsString();
        if (json.has("harvestType")) {
            this.harvestType = json.get("harvestType").getAsString();
        }
        if (json.has("harvestShape")) {
            this.harvestShape = json.get("harvestShape").getAsString();
        }
        this.harvestRange = JSONHelper.getVec3i(json, "harvestRange");
        if (json.has("harvestRangeLevelMultiplier")) {
            this.harvestRangeLevelMultiplier = json.get("harvestRangeLevelMultiplier").getAsDouble();
        }
        super.loadFromJSON(json);
    }

    @Override
    public String getDescription(ItemStack itemStack, int level) {
        if (!this.isActive(itemStack, level)) {
            return null;
        }
        String description = I18n.func_74838_a((String)("equipment.feature." + this.featureType)) + " " + this.harvestType;
        description = description + "\n" + I18n.func_74838_a((String)"equipment.feature.harvest.shape") + " " + this.harvestShape;
        Vec3i vec3i = new Vec3i(0, 0, 0);
        if (this.harvestRange.func_177951_i(vec3i) > 0.0) {
            description = description + "\n" + I18n.func_74838_a((String)"equipment.feature.harvest.range") + " " + this.getHarvestRangeString(level);
        }
        return description;
    }

    public String getHarvestRangeString(int level) {
        String harvestRangeString = "" + Math.round((double)this.harvestRange.func_177958_n() + (double)(this.harvestRange.func_177958_n() * (level - 1)) * this.harvestRangeLevelMultiplier);
        harvestRangeString = harvestRangeString + ", " + Math.round((double)this.harvestRange.func_177956_o() + (double)(this.harvestRange.func_177956_o() * (level - 1)) * this.harvestRangeLevelMultiplier);
        harvestRangeString = harvestRangeString + ", " + Math.round((double)this.harvestRange.func_177952_p() + (double)(this.harvestRange.func_177952_p() * (level - 1)) * this.harvestRangeLevelMultiplier);
        return harvestRangeString;
    }
}

