/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.item.equipment.features;

import com.google.gson.JsonObject;
import com.lycanitesmobs.core.item.equipment.features.EquipmentFeature;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.translation.I18n;

public class EffectEquipmentFeature
extends EquipmentFeature {
    public String effectType;
    public String effectTarget;
    public int effectDuration = 0;
    public int effectStrength = 0;

    @Override
    public void loadFromJSON(JsonObject json) {
        this.effectType = json.get("effectType").getAsString();
        this.effectTarget = json.get("effectTarget").getAsString();
        if (json.has("effectDuration")) {
            this.effectDuration = json.get("effectDuration").getAsInt();
        }
        if (json.has("effectStrength")) {
            this.effectStrength = json.get("effectStrength").getAsInt();
        }
        super.loadFromJSON(json);
    }

    @Override
    public String getDescription(ItemStack itemStack, int level) {
        if (!this.isActive(itemStack, level)) {
            return null;
        }
        String description = I18n.func_74838_a((String)("equipment.feature." + this.featureType)) + " " + this.effectType + " (" + this.effectTarget + ")";
        if (!"self".equals(this.effectTarget) && this.effectDuration > 0) {
            description = description + "\n" + I18n.func_74838_a((String)"equipment.feature.effect.duration") + " " + (float)this.effectDuration / 20.0f;
        }
        if (this.effectStrength > 0) {
            description = description + "\n" + I18n.func_74838_a((String)"equipment.feature.effect.strength") + " " + this.effectStrength;
        }
        return description;
    }
}

