/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.item.equipment;

import com.google.common.collect.Multimap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lycanitesmobs.AssetManager;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.info.GroupInfo;
import com.lycanitesmobs.core.item.ItemBase;
import com.lycanitesmobs.core.item.equipment.features.EquipmentFeature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.vecmath.Vector4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class ItemEquipmentPart
extends ItemBase {
    public static ItemStack ITEMSTACK_TO_RENDER;
    public static Map<String, ItemEquipmentPart> MOB_PART_DROPS;
    public List<EquipmentFeature> features = new ArrayList<EquipmentFeature>();
    public String slotType;
    public String dropMobId;
    public float dropChance = 1.0f;
    public int levelMin = 1;
    public int levelMax = 3;

    public ItemEquipmentPart(GroupInfo groupInfo) {
        this.group = groupInfo;
        this.func_77625_d(1);
        this.func_77637_a(LycanitesMobs.equipmentPartsTab);
    }

    public void loadFromJSON(JsonObject json) {
        this.itemName = json.get("itemName").getAsString();
        this.slotType = json.get("slotType").getAsString();
        if (json.has("dropMobId")) {
            this.dropMobId = json.get("dropMobId").getAsString();
            if (!"".equals(this.dropMobId)) {
                MOB_PART_DROPS.put(this.dropMobId, this);
            }
        }
        if (json.has("dropChance")) {
            this.dropChance = json.get("dropChance").getAsFloat();
        }
        if (json.has("levelMin")) {
            this.levelMin = json.get("levelMin").getAsInt();
        }
        if (json.has("levelMax")) {
            this.levelMax = json.get("levelMax").getAsInt();
        }
        if (json.has("features")) {
            JsonArray jsonArray = json.get("features").getAsJsonArray();
            Iterator jsonIterator = jsonArray.iterator();
            while (jsonIterator.hasNext()) {
                JsonObject featureJson = ((JsonElement)jsonIterator.next()).getAsJsonObject();
                EquipmentFeature feature = EquipmentFeature.createFromJSON(featureJson);
                this.features.add(feature);
            }
        }
        this.setRegistryName(this.group.filename, this.itemName);
        this.func_77655_b(this.itemName);
        AssetManager.addTexture(this.itemName, this.group, "textures/equipment/" + this.itemName + ".png");
    }

    @Override
    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<String> tooltip, ITooltipFlag tooltipFlag) {
        super.func_77624_a(itemStack, world, tooltip, tooltipFlag);
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        for (String description : this.getAdditionalDescriptions(itemStack, world, tooltipFlag)) {
            List formattedDescriptionList = fontRenderer.func_78271_c("-------------------\n" + description, descriptionWidth);
            for (Object formattedDescription : formattedDescriptionList) {
                if (!(formattedDescription instanceof String)) continue;
                tooltip.add("\u00a73" + formattedDescription);
            }
        }
    }

    @Override
    public String getDescription(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        return I18n.func_74838_a((String)"item.equipmentpart.description");
    }

    public List<String> getAdditionalDescriptions(ItemStack itemStack, @Nullable World world, ITooltipFlag tooltipFlag) {
        ArrayList<String> descriptions = new ArrayList<String>();
        int level = this.getLevel(itemStack);
        String baseFeature = I18n.func_74838_a((String)"equipment.slottype") + " " + this.slotType;
        baseFeature = baseFeature + "\n" + I18n.func_74838_a((String)"equipment.level") + " " + level + "/" + this.levelMax;
        descriptions.add(baseFeature);
        for (EquipmentFeature feature : this.features) {
            String featureDescription = feature.getDescription(itemStack, level);
            if (featureDescription == null || "".equals(featureDescription)) continue;
            descriptions.add(featureDescription);
        }
        return descriptions;
    }

    @Override
    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        return super.getAttributeModifiers(slot, stack);
    }

    public int getMetadata(ItemStack stack) {
        ITEMSTACK_TO_RENDER = stack;
        return super.getMetadata(stack);
    }

    public NBTTagCompound getTagCompound(ItemStack itemStack) {
        if (itemStack.func_77942_o()) {
            return itemStack.func_77978_p();
        }
        return new NBTTagCompound();
    }

    public void initializePart(World world, ItemStack itemStack) {
        NBTTagCompound nbt = this.getTagCompound(itemStack);
        if (!nbt.func_74764_b("equipmentLevel")) {
            int level = this.levelMax;
            if (this.levelMin < this.levelMax) {
                level = this.levelMin + world.field_73012_v.nextInt(this.levelMax - this.levelMin + 1);
            }
            nbt.func_74768_a("equipmentLevel", level);
        }
        itemStack.func_77982_d(nbt);
    }

    public int getLevel(ItemStack itemStack) {
        NBTTagCompound nbt = this.getTagCompound(itemStack);
        int level = 1;
        if (nbt.func_74764_b("equipmentLevel")) {
            level = nbt.func_74762_e("equipmentLevel");
        }
        return level;
    }

    public Vector4f getColor(ItemStack itemStack) {
        NBTTagCompound nbt = this.getTagCompound(itemStack);
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        if (nbt.func_74764_b("equipmentColorR")) {
            r = nbt.func_74760_g("equipmentColorR");
        }
        if (nbt.func_74764_b("equipmentColorG")) {
            r = nbt.func_74760_g("equipmentColorG");
        }
        if (nbt.func_74764_b("equipmentColorB")) {
            r = nbt.func_74760_g("equipmentColorB");
        }
        return new Vector4f(r, g, b, 1.0f);
    }

    @Override
    public ModelResourceLocation getModelResourceLocation() {
        return new ModelResourceLocation(new ResourceLocation("lycanitesmobs", "equipmentpart"), "inventory");
    }

    public ResourceLocation getTexture(ItemStack itemStack) {
        return AssetManager.getTexture(this.itemName);
    }

    static {
        MOB_PART_DROPS = new HashMap<String, ItemEquipmentPart>();
    }
}

