/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.item;

import com.lycanitesmobs.ExtendedPlayer;
import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.entity.EntityCreatureTameable;
import com.lycanitesmobs.core.entity.EntityPortal;
import com.lycanitesmobs.core.gui.GUIMinion;
import com.lycanitesmobs.core.item.ItemScepter;
import com.lycanitesmobs.core.pets.SummonSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemStaffSummoning
extends ItemScepter {
    public EntityPortal portalEntity;

    public ItemStaffSummoning(String itemName, String textureName) {
        this.itemName = itemName;
        this.textureName = textureName;
        this.setup();
        this.func_185043_a(new ResourceLocation("using"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack itemStack, World world, EntityLivingBase entity) {
                return entity != null && entity.func_184587_cr() && entity.func_184607_cu() == itemStack ? 1.0f : 0.0f;
            }
        });
    }

    @Override
    public int getDurability() {
        return 500;
    }

    @Override
    public void damageItemRapid(ItemStack itemStack, EntityLivingBase entity) {
    }

    @Override
    public void damageItemCharged(ItemStack itemStack, EntityLivingBase entity, float power) {
        if (this.portalEntity != null) {
            itemStack.func_77972_a(this.portalEntity.summonAmount, entity);
        }
    }

    @Override
    public int getChargeTime(ItemStack itemStack) {
        return 1;
    }

    @Override
    public int getRapidTime(ItemStack itemStack) {
        return 20;
    }

    public int getSummonCostBoost() {
        return 0;
    }

    public float getSummonCostMod() {
        return 1.0f;
    }

    public int getSummonDuration() {
        return 1200;
    }

    public int getSummonAmount() {
        return 1;
    }

    public boolean getAdditionalCosts(EntityPlayer player) {
        return true;
    }

    public void applyMinionBehaviour(EntityCreatureTameable minion, EntityPlayer player) {
        SummonSet summonSet = ExtendedPlayer.getForPlayer(player).getSelectedSummonSet();
        summonSet.applyBehaviour(minion);
    }

    public void applyMinionEffects(EntityCreatureBase minion) {
    }

    @Override
    public void func_77615_a(ItemStack itemStack, World world, EntityLivingBase entity, int useRemaining) {
        super.func_77615_a(itemStack, world, entity, useRemaining);
        this.portalEntity = null;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        ExtendedPlayer playerExt = ExtendedPlayer.getForPlayer(player);
        if (playerExt != null) {
            SummonSet summonSet = playerExt.getSelectedSummonSet();
            if (summonSet.isUseable()) {
                if (!player.func_130014_f_().field_72995_K) {
                    this.portalEntity = new EntityPortal(world, player, summonSet.getCreatureClass(), this);
                    this.portalEntity.func_70012_b(player.field_70165_t, player.field_70163_u, player.field_70161_v, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                    world.func_72838_d((Entity)this.portalEntity);
                }
            } else {
                this.portalEntity = null;
                if (!player.func_130014_f_().field_72995_K) {
                    playerExt.sendAllSummonSetsToPlayer();
                }
                if (player.func_130014_f_().field_72995_K) {
                    GUIMinion.openToPlayer(player, playerExt.selectedSummonSet);
                }
            }
        }
        return super.func_77659_a(world, player, hand);
    }

    @Override
    public boolean rapidAttack(ItemStack itemStack, World world, EntityLivingBase entity) {
        return false;
    }

    @Override
    public boolean chargedAttack(ItemStack itemStack, World world, EntityLivingBase entity, float power) {
        if (this.portalEntity != null) {
            boolean success = this.portalEntity.summonCreatures();
            this.portalEntity = null;
            return success;
        }
        return false;
    }

    @Override
    public boolean func_82789_a(ItemStack itemStack, ItemStack repairStack) {
        if (repairStack.func_77973_b() == Items.field_151043_k) {
            return true;
        }
        return super.func_82789_a(itemStack, repairStack);
    }
}

