/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.item;

import com.google.common.collect.Multimap;
import com.lycanitesmobs.core.entity.EntityProjectileBase;
import com.lycanitesmobs.core.item.ItemBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemScepter
extends ItemBase {
    protected float damageScale = 1.0f;
    protected int weaponFlash = 0;

    public ItemScepter() {
        this.func_77625_d(1);
        this.func_77656_e(this.getDurability());
        this.func_185043_a(new ResourceLocation("using"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack itemStack, World world, EntityLivingBase entity) {
                return entity != null && entity.func_184587_cr() && entity.func_184607_cu() == itemStack ? 1.0f : 0.0f;
            }
        });
    }

    @Override
    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int par4, boolean par5) {
        super.func_77663_a(itemStack, world, entity, par4, par5);
    }

    public boolean onEntitySwing(EntityLivingBase entity, ItemStack itemStack) {
        if (entity instanceof EntityPlayer) {
            entity.func_184598_c(EnumHand.MAIN_HAND);
            return true;
        }
        return super.onEntitySwing(entity, itemStack);
    }

    public boolean onLeftClickEntity(ItemStack itemStack, EntityPlayer player, Entity entity) {
        return true;
    }

    @Override
    public void onItemLeftClick(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (hand == EnumHand.OFF_HAND) {
            return;
        }
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        player.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    @Override
    public void onUsingTick(ItemStack itemStack, EntityLivingBase entity, int useRemaining) {
        int rapidRemainder;
        if (itemStack == null || entity == null || entity.func_130014_f_() == null) {
            return;
        }
        int useTime = this.func_77626_a(itemStack) - useRemaining;
        if (useTime >= this.getRapidTime(itemStack) && (rapidRemainder = useTime % this.getRapidTime(itemStack)) == 0 && entity.func_130014_f_() != null && this.rapidAttack(itemStack, entity.func_130014_f_(), entity)) {
            this.damageItemRapid(itemStack, entity);
            this.weaponFlash = Math.max(20, this.getRapidTime(itemStack));
        }
        if (useTime >= this.getChargeTime(itemStack)) {
            this.weaponFlash = Math.max(20, this.getChargeTime(itemStack));
        }
        super.onUsingTick(itemStack, entity, useRemaining);
    }

    @Override
    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        int useTime = this.func_77626_a(stack) - timeLeft;
        float power = (float)useTime / (float)this.getChargeTime(stack);
        this.weaponFlash = 0;
        if ((double)power < 0.1) {
            return;
        }
        if (power > 1.0f) {
            power = 1.0f;
        }
        if (this.chargedAttack(stack, worldIn, entityLiving, power)) {
            this.damageItemCharged(stack, entityLiving, power);
            this.weaponFlash = Math.min(20, this.getChargeTime(stack));
        }
    }

    @Override
    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.BOW;
    }

    public void damageItemRapid(ItemStack itemStack, EntityLivingBase entity) {
        itemStack.func_77972_a(1, entity);
    }

    public void damageItemCharged(ItemStack itemStack, EntityLivingBase entity, float power) {
        itemStack.func_77972_a(Math.max((int)power, 1), entity);
    }

    public int getDurability() {
        return 1000;
    }

    public int func_77626_a(ItemStack itemStack) {
        return 72000;
    }

    public int getChargeTime(ItemStack itemStack) {
        return this.func_77626_a(itemStack);
    }

    public int getRapidTime(ItemStack itemStack) {
        return this.func_77626_a(itemStack);
    }

    public boolean rapidAttack(ItemStack itemStack, World world, EntityLivingBase entity) {
        if (!world.field_72995_K) {
            // empty if block
        }
        return false;
    }

    public boolean chargedAttack(ItemStack itemStack, World world, EntityLivingBase entity, float power) {
        if (!world.field_72995_K) {
            // empty if block
        }
        return false;
    }

    @Override
    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        return super.getAttributeModifiers(slot, stack);
    }

    @Override
    public int func_77619_b() {
        return 18;
    }

    public void playSound(ItemStack itemStack, World world, EntityLivingBase entity, float power, EntityProjectileBase projectile) {
        this.playSound(world, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, projectile.getLaunchSound(), SoundCategory.PLAYERS, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
    }

    @Override
    public boolean func_82789_a(ItemStack itemStack, ItemStack repairStack) {
        return super.func_82789_a(itemStack, repairStack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }
}

