/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.item;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.info.GroupInfo;
import com.lycanitesmobs.core.info.ItemInfo;
import com.lycanitesmobs.core.item.ItemBase;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class ItemCustomFood
extends ItemFood {
    public String itemName = "customfood";
    public GroupInfo group = LycanitesMobs.group;
    public String texturePath = "customfood";
    public FOOD_CLASS foodClass = FOOD_CLASS.NONE;
    protected PotionEffect effect;
    protected float effectChance;

    public ItemCustomFood(String setItemName, GroupInfo group, String setTexturePath, int feed, float saturation, FOOD_CLASS foodClass) {
        super(feed, saturation, false);
        this.itemName = setItemName;
        this.group = group;
        this.texturePath = setTexturePath;
        this.foodClass = foodClass;
        this.func_77625_d(64);
        this.setRegistryName(this.group.filename, this.itemName);
        this.func_77637_a(LycanitesMobs.itemsTab);
        this.func_77655_b(this.itemName);
        this.setPotionEffect(MobEffects.field_76432_h, 1, this.getInstantHealing(), 1.0f);
    }

    public ItemCustomFood(String setItemName, GroupInfo group, int feed, float saturation, FOOD_CLASS foodClass) {
        this(setItemName, group, setItemName.toLowerCase(), feed, saturation, foodClass);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        String description = this.getDescription(stack, worldIn, tooltip, flagIn);
        if (!"".equalsIgnoreCase(description) && !("item." + this.itemName + ".description").equals(description)) {
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            List formattedDescriptionList = fontRenderer.func_78271_c(description, ItemBase.descriptionWidth);
            for (Object formattedDescription : formattedDescriptionList) {
                if (!(formattedDescription instanceof String)) continue;
                tooltip.add("\u00a7a" + formattedDescription);
            }
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public String getDescription(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        return I18n.func_74838_a((String)("item." + this.itemName + ".description"));
    }

    public int getEffectDuration() {
        if (this.foodClass == FOOD_CLASS.RAW) {
            return ItemInfo.durationRaw * 20;
        }
        if (this.foodClass == FOOD_CLASS.COOKED) {
            return ItemInfo.durationCooked * 20;
        }
        if (this.foodClass == FOOD_CLASS.MEAL) {
            return ItemInfo.durationMeal * 20;
        }
        if (this.foodClass == FOOD_CLASS.FEAST) {
            return ItemInfo.durationFeast * 20;
        }
        return 1;
    }

    public int getInstantHealing() {
        if (this.foodClass == FOOD_CLASS.COOKED) {
            return ItemInfo.healingCooked;
        }
        if (this.foodClass == FOOD_CLASS.MEAL) {
            return ItemInfo.healingMeal;
        }
        if (this.foodClass == FOOD_CLASS.FEAST) {
            return ItemInfo.healingFeast;
        }
        return 0;
    }

    public ItemCustomFood setPotionEffect(Potion potion, int duration, int amplifier, float chance) {
        PotionEffect potionEffect;
        this.effect = potionEffect = new PotionEffect(potion, duration * 20, amplifier, false, false);
        this.func_185070_a(potionEffect, chance);
        return this;
    }

    public ItemCustomFood setAlwaysEdible() {
        super.func_77848_i();
        return this;
    }

    public static enum FOOD_CLASS {
        NONE(0),
        RAW(1),
        COOKED(2),
        MEAL(3),
        FEAST(4);

        public final int id;

        private FOOD_CLASS(int value) {
            this.id = value;
        }

        public int getValue() {
            return this.id;
        }
    }
}

