/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.info;

import com.lycanitesmobs.core.config.ConfigBase;
import com.lycanitesmobs.core.entity.CreatureStats;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.text.translation.I18n;

public class Subspecies {
    public static int baseSpeciesWeight = 400;
    public static Map<String, Integer> commonWeights = new HashMap<String, Integer>(){
        {
            this.put("common", 100);
            this.put("uncommon", 20);
            this.put("rare", 2);
            this.put("legendary", 1);
        }
    };
    public static Map<String, Double> statMultipliers = new HashMap<String, Double>();
    public static int uncommonDropScale = 2;
    public static int rareDropScale = 5;
    public static double uncommonExperienceScale = 2.0;
    public static double rareExperienceScale = 10.0;
    public static boolean rareHealthBars = false;
    public int index;
    public String name;
    public String type;
    public int weight;

    public static void loadGlobalSettings(ConfigBase config) {
        baseSpeciesWeight = config.getInt("Mob Variations", "Subspecies Base Weight", baseSpeciesWeight, "The weight of base subspecies (regular mobs).");
        commonWeights.put("uncommon", config.getInt("Mob Variations", "Subspecies Uncommon Weight", commonWeights.get("uncommon"), "The weight of uncommon subspecies (such as Azure, Verdant, Scarlet, etc)."));
        commonWeights.put("rare", config.getInt("Mob Variations", "Subspecies Rare Weight", commonWeights.get("rare"), "The weight of rare subspecies (such as Lunar or Celestial)."));
        String[] subspeciesNames = new String[]{"uncommon", "rare"};
        statMultipliers = new HashMap<String, Double>();
        config.setCategoryComment("Subspecies Multipliers", "Here you can scale the stats of every mob on a per subspecies basis.");
        for (String subspeciesName : subspeciesNames) {
            for (String statName : CreatureStats.STAT_NAMES) {
                double defaultValue = 1.0;
                if ("uncommon".equals(subspeciesName) && "health".equals(statName)) {
                    defaultValue = 2.0;
                }
                if ("rare".equals(subspeciesName)) {
                    if ("health".equals(statName)) {
                        defaultValue = 20.0;
                    } else if ("attackSpeed".equals(statName)) {
                        defaultValue = 2.0;
                    } else if ("rangedSpeed".equals(statName)) {
                        defaultValue = 2.0;
                    } else if ("effect".equals(statName)) {
                        defaultValue = 2.0;
                    }
                }
                statMultipliers.put((subspeciesName + "-" + statName).toUpperCase(), config.getDouble("Subspecies Multipliers", subspeciesName + " " + statName, defaultValue));
            }
        }
        uncommonDropScale = config.getInt("Mob Variations", "Subspecies Uncommon Item Drops Scale", uncommonDropScale, "When a creature with the uncommon subspecies (Azure, Verdant, etc) dies, its item drops amount is multiplied by this value.");
        rareDropScale = config.getInt("Mob Variations", "Subspecies Rare Item Drops Scale", rareDropScale, "When a creature with the rare subspecies (Celestial, Lunar, etc) dies, its item drops amount is multiplied by this value.");
        uncommonExperienceScale = config.getDouble("Mob Variations", "Subspecies Uncommon Experience Scale", uncommonExperienceScale, "When a creature with the uncommon subspecies (Azure, Verdant, etc) dies, its experience amount is multiplied by this value.");
        rareExperienceScale = config.getDouble("Mob Variations", "Subspecies Rare Experience Scale", rareExperienceScale, "When a creature with the rare subspecies (Celestial, Lunar, etc) dies, its experience amount is multiplied by this value.");
        rareHealthBars = config.getBool("Mob Variations", "Subspecies Rare Health Bars", rareHealthBars, "If set to true, rare subspecies such as the Lunar Grue or Celestial Geonach will display boss health bars.");
    }

    public Subspecies(String setName, int setWeight) {
        this.name = setName.toLowerCase();
        this.weight = setWeight;
    }

    public Subspecies(String name, String type) {
        this.name = name.toLowerCase();
        this.type = type;
        this.weight = commonWeights.get(type);
    }

    public String getTitle() {
        return I18n.func_74838_a((String)("subspecies." + this.name + ".name"));
    }
}

