/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.info;

import com.google.gson.JsonObject;
import com.lycanitesmobs.LycanitesMobs;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class ItemDrop {
    public ItemStack itemStack = null;
    public ItemStack burningItemStack = null;
    public Map<Integer, ItemStack> effectsItem = new HashMap<Integer, ItemStack>();
    public int minAmount = 1;
    public int maxAmount = 1;
    public float chance = 0.0f;
    public int subspeciesID = -1;

    /*
     * Enabled aggressive block sorting
     */
    public static ItemDrop createFromJSON(JsonObject json) {
        ItemDrop itemDrop = null;
        int itemMetadata = 0;
        if (!json.has("item")) {
            LycanitesMobs.printWarning("", "[JSON] Unable to load item drop from json as it has no name!");
            return itemDrop;
        }
        if (json.has("metadata")) {
            itemMetadata = json.get("metadata").getAsInt();
        }
        String itemId = json.get("item").getAsString();
        Item item = (Item)GameRegistry.findRegistry(Item.class).getValue(new ResourceLocation(itemId));
        if (item != null) {
            itemDrop = new ItemDrop(new ItemStack(item, 1, itemMetadata), 1.0f);
            itemDrop.loadFromJSON(json);
            return itemDrop;
        }
        LycanitesMobs.printWarning("", "[JSON] Unable to load item drop from the item id: " + itemId);
        return null;
    }

    public ItemDrop(ItemStack itemStack, float chance) {
        this.itemStack = itemStack;
        this.minAmount = 1;
        this.maxAmount = 1;
        this.chance = chance;
    }

    public ItemDrop(NBTTagCompound nbtTagCompound) {
        this.readFromNBT(nbtTagCompound);
    }

    public void loadFromJSON(JsonObject json) {
        if (json.has("minAmount")) {
            this.minAmount = json.get("minAmount").getAsInt();
        }
        if (json.has("maxAmount")) {
            this.maxAmount = json.get("maxAmount").getAsInt();
        }
        if (json.has("chance")) {
            this.chance = json.get("chance").getAsFloat();
        }
        if (json.has("subspecies")) {
            this.subspeciesID = json.get("subspecies").getAsInt();
        }
        if (json.has("burningItem")) {
            int dropMeta = 0;
            if (json.has("burningMetadata")) {
                dropMeta = json.get("burningMetadata").getAsInt();
            }
            String dropName = json.get("burningItem").getAsString();
            ItemStack itemStack = null;
            if (Item.func_111206_d((String)dropName) != null) {
                itemStack = new ItemStack(Item.func_111206_d((String)dropName), 1, dropMeta);
            } else if (Block.func_149684_b((String)dropName) != null) {
                itemStack = new ItemStack(Block.func_149684_b((String)dropName), 1, dropMeta);
            }
            this.burningItemStack = itemStack;
        }
    }

    public ItemDrop setDrop(ItemStack item) {
        this.itemStack = item;
        return this;
    }

    public ItemDrop setBurningDrop(ItemStack item) {
        this.burningItemStack = item;
        return this;
    }

    public ItemDrop setEffectDrop(int effectID, ItemStack item) {
        this.effectsItem.put(effectID, item);
        return this;
    }

    public ItemDrop setMinAmount(int amount) {
        this.minAmount = amount;
        return this;
    }

    public ItemDrop setMaxAmount(int amount) {
        this.maxAmount = amount;
        return this;
    }

    public ItemDrop setChance(float chance) {
        this.chance = chance;
        return this;
    }

    public ItemDrop setSubspecies(int subspeciesID) {
        this.subspeciesID = subspeciesID;
        return this;
    }

    public int getQuantity(Random random, int bonus) {
        float roll = random.nextFloat();
        if ((roll = Math.max(roll, 0.0f)) > this.chance) {
            return 0;
        }
        int max = this.maxAmount + bonus;
        int min = this.minAmount;
        if (max <= min) {
            return min;
        }
        float dropRange = (float)(max - min) * (roll /= this.chance);
        int dropAmount = min + Math.round(dropRange);
        return dropAmount;
    }

    public ItemStack getItemStack(EntityLivingBase entity, int quantity) {
        ItemStack drop = this.itemStack;
        if (entity.func_70027_ad() && this.burningItemStack != null) {
            drop = this.burningItemStack;
        }
        for (Object potionEffect : entity.func_70651_bq()) {
            int effectID;
            if (!(potionEffect instanceof PotionEffect) || !this.effectsItem.containsKey(effectID = Potion.func_188409_a((Potion)((PotionEffect)potionEffect).func_188419_a()))) continue;
            drop = this.effectsItem.get(effectID);
        }
        if (drop != null) {
            drop.func_190920_e(quantity);
        }
        return drop;
    }

    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        this.itemStack = new ItemStack(nbtTagCompound);
        this.minAmount = nbtTagCompound.func_74762_e("MinAmount");
        this.maxAmount = nbtTagCompound.func_74762_e("MaxAmount");
        this.chance = nbtTagCompound.func_74760_g("Chance");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbtTagCompound) {
        NBTTagCompound itemNBT = new NBTTagCompound();
        this.itemStack.func_77955_b(itemNBT);
        nbtTagCompound.func_74782_a("ItemStack", (NBTBase)itemNBT);
        nbtTagCompound.func_74768_a("MinAmount", this.minAmount);
        nbtTagCompound.func_74768_a("MaxAmount", this.maxAmount);
        nbtTagCompound.func_74776_a("Chance", this.chance);
        return nbtTagCompound;
    }
}

