/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.info;

import com.google.common.collect.Maps;
import com.lycanitesmobs.LycanitesMobs;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class EntityListCustom {
    public Map<ResourceLocation, Class> IDtoClassMapping = new HashMap<ResourceLocation, Class>();
    private Map<Class, ResourceLocation> classToIDMapping = new HashMap<Class, ResourceLocation>();
    public Map<ResourceLocation, EntityEggInfo> entityEggs = Maps.newLinkedHashMap();

    public void addMapping(Class entityClass, ResourceLocation entityID) {
        this.IDtoClassMapping.put(entityID, entityClass);
        this.classToIDMapping.put(entityClass, entityID);
    }

    public void addMapping(Class entityClass, ResourceLocation entityID, int baseColor, int spotColor) {
        this.addMapping(entityClass, entityID);
        this.entityEggs.put(entityID, new EntityEggInfo(entityID, baseColor, spotColor));
    }

    public Entity createEntityFromNBT(NBTTagCompound nbtTagCompound, World world) {
        Entity entity = null;
        if ("Minecart".equals(nbtTagCompound.func_74779_i("id"))) {
            switch (nbtTagCompound.func_74762_e("Type")) {
                case 0: {
                    nbtTagCompound.func_74778_a("id", "MinecartRideable");
                    break;
                }
                case 1: {
                    nbtTagCompound.func_74778_a("id", "MinecartChest");
                    break;
                }
                case 2: {
                    nbtTagCompound.func_74778_a("id", "MinecartFurnace");
                }
            }
            nbtTagCompound.func_82580_o("Type");
        }
        this.createEntityByID(new ResourceLocation(nbtTagCompound.func_74779_i("id")), world);
        return entity;
    }

    public Entity createEntityByID(ResourceLocation entityID, World world) {
        Entity entity = null;
        try {
            Class entityClass = this.getClassFromID(entityID);
            if (entityClass != null) {
                entity = (Entity)entityClass.getConstructor(World.class).newInstance(world);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (entity == null) {
            LycanitesMobs.printWarning("", "Unable to spawn entity with the id " + entityID);
        }
        return entity;
    }

    public ResourceLocation getEntityID(Entity entity) {
        Class<?> entityClass = entity.getClass();
        return this.classToIDMapping.containsKey(entityClass) ? this.classToIDMapping.get(entityClass) : null;
    }

    public Class getClassFromID(ResourceLocation entityID) {
        return this.IDtoClassMapping.get(entityID);
    }

    public static class EntityEggInfo {
        public final ResourceLocation spawnedID;
        public final int primaryColor;
        public final int secondaryColor;

        public EntityEggInfo(ResourceLocation entityID, int primaryColor, int secondaryColor) {
            this.spawnedID = entityID;
            this.primaryColor = primaryColor;
            this.secondaryColor = secondaryColor;
        }
    }
}

